/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.LocalString;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.Instances;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;

public class NBTreeClassifierTree
extends ClassifierTree {
    public NBTreeClassifierTree(ModelSelection modelSelection) {
        super(modelSelection);
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException(LocalString.get("Class is numeric!"));
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.buildTree(instances, false);
        this.cleanup(new Instances(instances, 0));
        this.assignIDs(-1);
    }

    protected ClassifierTree getNewTree(Instances instances) throws Exception {
        NBTreeClassifierTree nBTreeClassifierTree = new NBTreeClassifierTree(this.m_toSelectModel);
        nBTreeClassifierTree.buildTree(instances, false);
        return nBTreeClassifierTree;
    }

    protected ClassifierTree getNewTree(Instances instances, Instances instances2) throws Exception {
        NBTreeClassifierTree nBTreeClassifierTree = new NBTreeClassifierTree(this.m_toSelectModel);
        nBTreeClassifierTree.buildTree(instances, instances2, false);
        return nBTreeClassifierTree;
    }

    public String printLeafModels() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_isLeaf) {
            stringBuffer.append(LocalString.get("\nLeaf number: ") + this.m_id + " ");
            stringBuffer.append(this.m_localModel.toString());
            stringBuffer.append("\n");
        } else {
            for (int i = 0; i < this.m_sons.length; ++i) {
                stringBuffer.append(((NBTreeClassifierTree)this.m_sons[i]).printLeafModels());
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_isLeaf) {
                stringBuffer.append(": NB");
                stringBuffer.append(this.m_id);
            } else {
                this.dumpTreeNB(0, stringBuffer);
            }
            stringBuffer.append("\n" + this.printLeafModels());
            stringBuffer.append(LocalString.get("\n\nNumber of Leaves  : \t") + this.numLeaves() + "\n");
            stringBuffer.append(LocalString.get("\nSize of the tree : \t") + this.numNodes() + "\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return LocalString.get("Can't print nb tree.");
        }
    }

    private void dumpTreeNB(int n, StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("|   ");
            }
            stringBuffer.append(this.m_localModel.leftSide(this.m_train));
            stringBuffer.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append(": NB ");
                stringBuffer.append(this.m_sons[i].m_id);
                continue;
            }
            ((NBTreeClassifierTree)this.m_sons[i]).dumpTreeNB(n + 1, stringBuffer);
        }
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("digraph J48Tree {\n"));
        if (this.m_isLeaf) {
            stringBuffer.append("N" + this.m_id + LocalString.get(" [label=\"") + LocalString.get("NB model") + "\" " + LocalString.get("shape=box style=filled "));
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append(LocalString.get("data =\n") + this.m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
        } else {
            stringBuffer.append("N" + this.m_id + LocalString.get(" [label=\"") + this.m_localModel.leftSide(this.m_train) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append(LocalString.get("data =\n") + this.m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
            this.graphTree(stringBuffer);
        }
        return stringBuffer.toString() + "}\n";
    }

    private void graphTree(StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("N" + this.m_id + "->" + "N" + this.m_sons[i].m_id + LocalString.get(" [label=\"") + this.m_localModel.rightSide(i, this.m_train).trim() + "\"]\n");
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append("N" + this.m_sons[i].m_id + LocalString.get(" [label=\"") + LocalString.get("NB Model") + "\" " + LocalString.get("shape=box style=filled "));
                if (this.m_train != null && this.m_train.numInstances() > 0) {
                    stringBuffer.append(LocalString.get("data =\n") + this.m_sons[i].m_train + "\n");
                    stringBuffer.append(",\n");
                }
                stringBuffer.append("]\n");
                continue;
            }
            stringBuffer.append("N" + this.m_sons[i].m_id + LocalString.get(" [label=\"") + this.m_sons[i].m_localModel.leftSide(this.m_train) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append(LocalString.get("data =\n") + this.m_sons[i].m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
            ((NBTreeClassifierTree)this.m_sons[i]).graphTree(stringBuffer);
        }
    }
}

