/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.trees.m5.Rule;
import weka.classifiers.trees.m5.RuleNode;
import weka.core.AdditionalMeasureProducer;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public abstract class M5Base
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer {
    private Instances m_instances;
    private int m_classIndex;
    private int m_numAttributes;
    private int m_numInstances;
    protected FastVector m_ruleSet;
    private boolean m_generateRules = false;
    private boolean m_unsmoothedPredictions = false;
    private ReplaceMissingValues m_replaceMissing;
    private NominalToBinary m_nominalToBinary;
    protected boolean m_saveInstances = false;
    protected boolean m_regressionTree;
    protected boolean m_useUnpruned = false;
    protected double m_minNumInstances = 4.0;

    public String globalInfo() {
        return LocalString.get("The original algorithm M5 was invented by Quinlan:\n") + LocalString.get("Quinlan J. R. (1992). Learning with continuous classes. Proceedings of ") + LocalString.get("the Australian Joint Conference on Artificial Intelligence. 343--348. ") + LocalString.get("World Scientific, Singapore.\n") + "\n" + LocalString.get("Yong Wang made improvements and created M5':\n") + LocalString.get("Wang, Y and Witten, I. H. (1997). Induction of model trees for ") + LocalString.get("predicting continuous classes. Proceedings of the poster papers of ") + LocalString.get("the European Conference on Machine Learning. University of Economics, ") + LocalString.get("Faculty of Informatics and Statistics, Prague.");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option(LocalString.get("\tUse unpruned tree/rules\n"), "N", 0, "-N"));
        vector.addElement(new Option(LocalString.get("\tUse unsmoothed predictions\n"), "U", 0, "-U"));
        vector.addElement(new Option(LocalString.get("\tBuild regression tree/rule rather ") + LocalString.get("than a model tree/rule\n"), "R", 0, "-R"));
        vector.addElement(new Option(LocalString.get("\tSet minimum number of instances ") + LocalString.get("per leaf\n\t(default 4)"), "M", 1, LocalString.get("-M <minimum number of instances>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setUnpruned(Utils.getFlag('N', stringArray));
        this.setUseUnsmoothed(Utils.getFlag('U', stringArray));
        this.setBuildRegressionTree(Utils.getFlag('R', stringArray));
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMinNumInstances(new Double(string));
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        if (this.getUnpruned()) {
            stringArray[n++] = "-N";
        }
        if (this.getUseUnsmoothed()) {
            stringArray[n++] = "-U";
        }
        if (this.getBuildRegressionTree()) {
            stringArray[n++] = "-R";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMinNumInstances();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void setUnpruned(boolean bl) {
        this.m_useUnpruned = bl;
    }

    public boolean getUnpruned() {
        return this.m_useUnpruned;
    }

    protected void setGenerateRules(boolean bl) {
        this.m_generateRules = bl;
    }

    protected boolean getGenerateRules() {
        return this.m_generateRules;
    }

    public void setUseUnsmoothed(boolean bl) {
        this.m_unsmoothedPredictions = bl;
    }

    public boolean getUseUnsmoothed() {
        return this.m_unsmoothedPredictions;
    }

    public boolean getBuildRegressionTree() {
        return this.m_regressionTree;
    }

    public void setBuildRegressionTree(boolean bl) {
        this.m_regressionTree = bl;
    }

    public void setMinNumInstances(double d) {
        this.m_minNumInstances = d;
    }

    public double getMinNumInstances() {
        return this.m_minNumInstances;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        this.m_instances = new Instances(instances);
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_instances.deleteWithMissingClass();
        this.m_replaceMissing.setInputFormat(this.m_instances);
        this.m_instances = Filter.useFilter(this.m_instances, this.m_replaceMissing);
        this.m_nominalToBinary = new NominalToBinary();
        this.m_nominalToBinary.setInputFormat(this.m_instances);
        this.m_instances = Filter.useFilter(this.m_instances, this.m_nominalToBinary);
        this.m_instances.randomize(new Random(1L));
        this.m_classIndex = this.m_instances.classIndex();
        this.m_numAttributes = this.m_instances.numAttributes();
        this.m_numInstances = this.m_instances.numInstances();
        this.m_ruleSet = new FastVector();
        if (this.m_generateRules) {
            Rule rule;
            Instances instances2 = this.m_instances;
            double d = 0.0;
            double d2 = 0.0;
            do {
                rule = new Rule();
                rule.setSmoothing(!this.m_unsmoothedPredictions);
                rule.setRegressionTree(this.m_regressionTree);
                rule.setUnpruned(this.m_useUnpruned);
                rule.setSaveInstances(false);
                rule.setMinNumInstances(this.m_minNumInstances);
                rule.buildClassifier(instances2);
                this.m_ruleSet.addElement(rule);
            } while ((instances2 = rule.notCoveredInstances()).numInstances() > 0);
        } else {
            Rule rule = new Rule();
            rule.setUseTree(true);
            rule.setSmoothing(!this.m_unsmoothedPredictions);
            rule.setSaveInstances(this.m_saveInstances);
            rule.setRegressionTree(this.m_regressionTree);
            rule.setUnpruned(this.m_useUnpruned);
            rule.setMinNumInstances(this.m_minNumInstances);
            Instances instances3 = this.m_instances;
            rule.buildClassifier(instances3);
            this.m_ruleSet.addElement(rule);
            this.m_instances = new Instances(this.m_instances, 0);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = 0.0;
        boolean bl = false;
        this.m_replaceMissing.input(instance);
        instance = this.m_replaceMissing.output();
        this.m_nominalToBinary.input(instance);
        instance = this.m_nominalToBinary.output();
        if (this.m_ruleSet == null) {
            throw new Exception(LocalString.get("Classifier has not been built yet!"));
        }
        if (!this.m_generateRules) {
            Rule rule = (Rule)this.m_ruleSet.elementAt(0);
            return rule.classifyInstance(instance);
        }
        for (int i = 0; i < this.m_ruleSet.size(); ++i) {
            boolean bl2 = false;
            Rule rule = (Rule)this.m_ruleSet.elementAt(i);
            try {
                d = rule.classifyInstance(instance);
                bl = true;
            }
            catch (Exception exception) {
                bl2 = true;
            }
            if (!bl2) break;
        }
        if (!bl) {
            System.out.println(LocalString.get("Error in predicting (DecList)"));
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_ruleSet == null) {
            return LocalString.get("Classifier hasn't been built yet!");
        }
        if (this.m_generateRules) {
            stringBuffer.append("M5 " + (this.m_useUnpruned ? LocalString.get("unpruned ") : LocalString.get("pruned ")) + (this.m_regressionTree ? LocalString.get("regression ") : LocalString.get("model ")) + LocalString.get("rules "));
            if (!this.m_unsmoothedPredictions) {
                stringBuffer.append(LocalString.get("\n(using smoothed linear models) "));
            }
            stringBuffer.append(":\n");
            stringBuffer.append(LocalString.get("Number of Rules : ") + this.m_ruleSet.size() + "\n\n");
            for (int i = 0; i < this.m_ruleSet.size(); ++i) {
                Rule rule = (Rule)this.m_ruleSet.elementAt(i);
                stringBuffer.append(LocalString.get("Rule: ") + (i + 1) + "\n");
                stringBuffer.append(rule.toString());
            }
        } else {
            Rule rule = (Rule)this.m_ruleSet.elementAt(0);
            stringBuffer.append(rule.toString());
        }
        return stringBuffer.toString();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(LocalString.get("measureNumRules"));
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase(LocalString.get("measureNumRules")) == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (M5)"));
    }

    public double measureNumRules() {
        if (this.m_generateRules) {
            return this.m_ruleSet.size();
        }
        return ((Rule)this.m_ruleSet.elementAt((int)0)).m_topOfTree.numberOfLinearModels();
    }

    public RuleNode getM5RootNode() {
        Rule rule = (Rule)this.m_ruleSet.elementAt(0);
        return rule.getM5RootNode();
    }
}

