/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import weka.LocalString;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class CheckOptionHandler {
    public static String printOptions(String[] stringArray) {
        if (stringArray == null) {
            return LocalString.get("<null>");
        }
        return Utils.joinOptions(stringArray);
    }

    public static void compareOptions(String[] stringArray, String[] stringArray2) throws Exception {
        if (stringArray == null) {
            throw new Exception(LocalString.get("first set of options is null!"));
        }
        if (stringArray2 == null) {
            throw new Exception(LocalString.get("second set of options is null!"));
        }
        if (stringArray.length != stringArray2.length) {
            throw new Exception(LocalString.get("problem found!\n") + LocalString.get("First set: ") + CheckOptionHandler.printOptions(stringArray) + '\n' + LocalString.get("Second set: ") + CheckOptionHandler.printOptions(stringArray2) + '\n' + LocalString.get("options differ in length"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            throw new Exception(LocalString.get("problem found!\n") + LocalString.get("\tFirst set: ") + CheckOptionHandler.printOptions(stringArray) + '\n' + LocalString.get("\tSecond set: ") + CheckOptionHandler.printOptions(stringArray2) + '\n' + '\t' + stringArray[i] + " != " + stringArray2[i]);
        }
    }

    public static void checkOptionHandler(OptionHandler optionHandler, String[] stringArray) throws Exception {
        Object object;
        System.out.println(LocalString.get("OptionHandler: ") + optionHandler.getClass().getName());
        System.out.println("ListOptions:");
        Enumeration enumeration = optionHandler.listOptions();
        while (enumeration.hasMoreElements()) {
            object = (Option)enumeration.nextElement();
            System.out.println(((Option)object).synopsis());
            System.out.println(((Option)object).description());
        }
        object = optionHandler.getOptions();
        System.out.print(LocalString.get("Default options:"));
        System.out.println(CheckOptionHandler.printOptions((String[])object));
        System.out.print(LocalString.get("User options:"));
        System.out.println(CheckOptionHandler.printOptions(stringArray));
        System.out.println(LocalString.get("Setting user options..."));
        optionHandler.setOptions(stringArray);
        System.out.print(LocalString.get("Remaining options:"));
        System.out.println(CheckOptionHandler.printOptions(stringArray));
        System.out.print(LocalString.get("Getting canonical user options:"));
        String[] stringArray2 = optionHandler.getOptions();
        System.out.println(CheckOptionHandler.printOptions(stringArray2));
        System.out.println(LocalString.get("Setting canonical user options..."));
        optionHandler.setOptions((String[])stringArray2.clone());
        System.out.print(LocalString.get("Checking canonical user options..."));
        String[] stringArray3 = optionHandler.getOptions();
        CheckOptionHandler.compareOptions(stringArray2, stringArray3);
        System.out.println("OK");
        System.out.println(LocalString.get("Resetting to default options..."));
        optionHandler.setOptions((String[])object.clone());
        System.out.print(LocalString.get("Checking default options match previous default..."));
        String[] stringArray4 = optionHandler.getOptions();
        CheckOptionHandler.compareOptions((String[])object, stringArray4);
        System.out.println("OK");
    }

    public static void main(String[] stringArray) {
        try {
            OptionHandler optionHandler;
            String string = Utils.getOption('W', stringArray);
            if (string.length() == 0) {
                throw new Exception(LocalString.get("Please give a class name with -W option"));
            }
            try {
                optionHandler = (OptionHandler)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new Exception(LocalString.get("Couldn't find OptionHandler with name ") + string);
            }
            String[] stringArray2 = Utils.partitionOptions(stringArray);
            Utils.checkForRemainingOptions(stringArray);
            CheckOptionHandler.checkOptionHandler(optionHandler, stringArray2);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

