/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.LocalString;
import weka.core.Utils;

public class DatabaseConnection
implements Serializable {
    protected static String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected static Vector DRIVERS = new Vector();
    protected static Properties PROPERTIES;
    protected String m_DatabaseURL = PROPERTIES.getProperty(LocalString.get("jdbcURL"), "jdbc:idb=experiments.prp");
    protected PreparedStatement m_PreparedStatement;
    protected Connection m_Connection;
    protected boolean m_Debug = false;
    protected boolean m_checkForUpperCaseNames = false;
    protected boolean m_setAutoCommit = true;
    protected boolean m_createIndex = false;
    protected String m_userName = "";
    protected String m_password = "";
    public static final int STRING = 0;
    public static final int BOOL = 1;
    public static final int DOUBLE = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DATE = 8;

    public DatabaseConnection() throws Exception {
        String string = PROPERTIES.getProperty(LocalString.get("checkUpperCaseNames"));
        this.m_checkForUpperCaseNames = string.equals(LocalString.get("true"));
        string = PROPERTIES.getProperty(LocalString.get("setAutoCommit"));
        this.m_setAutoCommit = string.equals(LocalString.get("true"));
        string = PROPERTIES.getProperty(LocalString.get("createIndex"));
        this.m_createIndex = string.equals(LocalString.get("true"));
    }

    public void setUsername(String string) {
        this.m_userName = string;
    }

    public String getUsername() {
        return this.m_userName;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String databaseURLTipText() {
        return LocalString.get("Set the URL to the database.");
    }

    public String getDatabaseURL() {
        return this.m_DatabaseURL;
    }

    public void setDatabaseURL(String string) {
        this.m_DatabaseURL = string;
    }

    public boolean getUpperCase() {
        return this.m_checkForUpperCaseNames;
    }

    int translateDBColumnType(String string) {
        return Integer.parseInt(PROPERTIES.getProperty(string));
    }

    public static String arrayToString(Object[] objectArray) {
        String string = "";
        if (objectArray == null) {
            string = LocalString.get("<null>");
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                string = objectArray[i] == null ? string + " ?" : string + " " + objectArray[i];
            }
        }
        return string;
    }

    public static String typeName(int n) {
        switch (n) {
            case -5: {
                return LocalString.get("BIGINT ");
            }
            case -2: {
                return LocalString.get("BINARY");
            }
            case -7: {
                return LocalString.get("BIT");
            }
            case 1: {
                return LocalString.get("CHAR");
            }
            case 91: {
                return LocalString.get("DATE");
            }
            case 3: {
                return LocalString.get("DECIMAL");
            }
            case 8: {
                return LocalString.get("DOUBLE");
            }
            case 6: {
                return LocalString.get("FLOAT");
            }
            case 4: {
                return LocalString.get("INTEGER");
            }
            case -4: {
                return LocalString.get("LONGVARBINARY");
            }
            case -1: {
                return LocalString.get("LONGVARCHAR");
            }
            case 0: {
                return LocalString.get("NULL");
            }
            case 2: {
                return LocalString.get("NUMERIC");
            }
            case 1111: {
                return LocalString.get("OTHER");
            }
            case 7: {
                return LocalString.get("REAL");
            }
            case 5: {
                return LocalString.get("SMALLINT");
            }
            case 92: {
                return LocalString.get("TIME");
            }
            case 93: {
                return LocalString.get("TIMESTAMP");
            }
            case -6: {
                return LocalString.get("TINYINT");
            }
            case -3: {
                return LocalString.get("VARBINARY");
            }
            case 12: {
                return LocalString.get("VARCHAR");
            }
        }
        return LocalString.get("Unknown");
    }

    public void connectToDatabase() throws Exception {
        if (this.m_Debug) {
            System.err.println(LocalString.get("Connecting to ") + this.m_DatabaseURL);
        }
        if (this.m_Connection == null) {
            this.m_Connection = this.m_userName.equals("") ? DriverManager.getConnection(this.m_DatabaseURL) : DriverManager.getConnection(this.m_DatabaseURL, this.m_userName, this.m_password);
        }
        if (this.m_setAutoCommit) {
            this.m_Connection.setAutoCommit(true);
        } else {
            this.m_Connection.setAutoCommit(false);
        }
    }

    public void disconnectFromDatabase() throws Exception {
        if (this.m_Debug) {
            System.err.println(LocalString.get("Disconnecting from ") + this.m_DatabaseURL);
        }
        if (this.m_Connection != null) {
            this.m_Connection.close();
            this.m_Connection = null;
        }
    }

    public DatabaseMetaData getMetaData() throws Exception {
        return this.m_Connection.getMetaData();
    }

    public boolean isConnected() {
        return this.m_Connection != null;
    }

    public boolean execute(String string) throws SQLException {
        this.m_PreparedStatement = this.m_Connection.prepareStatement(string, 1003, 1007);
        return this.m_PreparedStatement.execute();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.m_PreparedStatement.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.m_PreparedStatement.getUpdateCount();
    }

    public boolean tableExists(String string) throws Exception {
        if (this.m_Debug) {
            System.err.println(LocalString.get("Checking if table ") + string + LocalString.get(" exists..."));
        }
        DatabaseMetaData databaseMetaData = this.m_Connection.getMetaData();
        ResultSet resultSet = this.m_checkForUpperCaseNames ? databaseMetaData.getTables(null, null, string.toUpperCase(), null) : databaseMetaData.getTables(null, null, string, null);
        boolean bl = resultSet.next();
        if (resultSet.next()) {
            throw new Exception(LocalString.get("This table seems to exist more than once!"));
        }
        resultSet.close();
        if (this.m_Debug) {
            if (bl) {
                System.err.println("... " + string + LocalString.get(" exists"));
            } else {
                System.err.println("... " + string + LocalString.get(" does not exist"));
            }
        }
        return bl;
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            String string = PROPERTIES.getProperty(LocalString.get("jdbcDriver"), "jdbc.idbDriver");
            if (string == null) {
                throw new Exception(LocalString.get("No jdbc drivers specified"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    DRIVERS.addElement(Class.forName(string2).newInstance());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            System.err.println(LocalString.get("Problem reading properties. Fix before continuing."));
            System.err.println(exception);
        }
    }
}

