/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Queue;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public abstract class AbstractTimeSeries
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    protected Range m_SelectedCols = new Range();
    protected boolean m_FillWithMissing;
    protected int m_InstanceRange = -1;
    protected Queue m_History;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option(LocalString.get("\tSpecify list of columns to translate in time. First and\n") + LocalString.get("\tlast are valid indexes. (default none)"), "R", 1, LocalString.get("-R <index1,index2-index4,...>")));
        vector.addElement(new Option(LocalString.get("\tInvert matching sense (i.e. calculate for all non-specified columns)"), "V", 0, "-V"));
        vector.addElement(new Option(LocalString.get("\tThe number of instances forward to translate values\n") + LocalString.get("\tbetween. A negative number indicates taking values from\n") + LocalString.get("\ta past instance. (default -1)"), "I", 1, LocalString.get("-I <num>")));
        vector.addElement(new Option(LocalString.get("\tFor instances at the beginning or end of the dataset where\n") + LocalString.get("\tthe translated values are not known, use missing values\n") + LocalString.get("\t(default is to remove those instances)."), "M", 0, "-M"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("");
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        this.setFillWithMissing(Utils.getFlag('M', stringArray));
        String string2 = Utils.getOption('I', stringArray);
        if (string2.length() != 0) {
            this.setInstanceRange(Integer.parseInt(string2));
        } else {
            this.setInstanceRange(-1);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getInstanceRange();
        if (this.getFillWithMissing()) {
            stringArray[n++] = "-M";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.resetHistory();
        this.m_SelectedCols.setUpper(instances.numAttributes() - 1);
        return false;
    }

    public boolean input(Instance instance) throws Exception {
        Instance instance2;
        if (this.getInputFormat() == null) {
            throw new NullPointerException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
            this.resetHistory();
        }
        if ((instance2 = this.historyInput(instance)) != null) {
            this.push(instance2);
            return true;
        }
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.getFillWithMissing() && this.m_InstanceRange > 0) {
            while (!this.m_History.empty()) {
                this.push(this.mergeInstances(null, (Instance)this.m_History.pop()));
            }
        }
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public String fillWithMissingTipText() {
        return LocalString.get("For instances at the beginning or end of the dataset where the translated ") + LocalString.get("values are not known, use missing values (default is to remove those ") + LocalString.get("instances)");
    }

    public boolean getFillWithMissing() {
        return this.m_FillWithMissing;
    }

    public void setFillWithMissing(boolean bl) {
        this.m_FillWithMissing = bl;
    }

    public String instanceRangeTipText() {
        return LocalString.get("The number of instances forward/backward to merge values between. ") + LocalString.get("A negative number indicates taking values from a past instance.");
    }

    public int getInstanceRange() {
        return this.m_InstanceRange;
    }

    public void setInstanceRange(int n) {
        this.m_InstanceRange = n;
    }

    public String invertSelectionTipText() {
        return LocalString.get("Invert matching sense. ie calculate for all non-specified columns.");
    }

    public boolean getInvertSelection() {
        return this.m_SelectedCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_SelectedCols.setInvert(bl);
    }

    public String attributeIndicesTipText() {
        return LocalString.get("Specify range of attributes to act on.") + LocalString.get(" This is a comma separated list of attribute indices, with") + LocalString.get(" \"first\" and \"last\" valid values. Specify an inclusive") + LocalString.get(" range with \"-\". E.g: \"first-3,5,6-10,last\".");
    }

    public String getAttributeIndices() {
        return this.m_SelectedCols.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_SelectedCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    protected void resetHistory() {
        if (this.m_History == null) {
            this.m_History = new Queue();
        } else {
            this.m_History.removeAllElements();
        }
    }

    protected Instance historyInput(Instance instance) {
        this.m_History.push(instance);
        if (this.m_History.size() <= Math.abs(this.m_InstanceRange)) {
            if (this.getFillWithMissing() && this.m_InstanceRange < 0) {
                return this.mergeInstances(null, instance);
            }
            return null;
        }
        if (this.m_InstanceRange < 0) {
            return this.mergeInstances((Instance)this.m_History.pop(), instance);
        }
        return this.mergeInstances(instance, (Instance)this.m_History.pop());
    }

    protected abstract Instance mergeInstances(Instance var1, Instance var2);
}

