/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import weka.LocalString;
import weka.gui.LogPanel;
import weka.gui.Logger;

public class SaveBuffer {
    private Logger m_Log;
    private Component m_parentComponent;
    private String m_lastvisitedDirectory = null;

    public SaveBuffer(Logger logger, Component component) {
        this.m_Log = logger;
        this.m_parentComponent = component;
    }

    public boolean save(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            JFileChooser jFileChooser = this.m_lastvisitedDirectory == null ? new JFileChooser(new File(System.getProperty("user.dir"))) : new JFileChooser(this.m_lastvisitedDirectory);
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showSaveDialog(this.m_parentComponent);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.m_lastvisitedDirectory = file.getPath();
                if (file.exists()) {
                    Object[] objectArray = new String[]{LocalString.get("Append"), LocalString.get("Overwrite"), LocalString.get("Choose new name"), LocalString.get("Cancel")};
                    JOptionPane jOptionPane = new JOptionPane(LocalString.get("File exists"), 3, 1, null, objectArray);
                    JDialog jDialog = jOptionPane.createDialog(this.m_parentComponent, LocalString.get("File query"));
                    jDialog.setVisible(true);
                    Object object = jOptionPane.getValue();
                    if (object != null) {
                        for (int i = 0; i < 4; ++i) {
                            if (!objectArray[i].equals(object)) continue;
                            switch (i) {
                                case 0: {
                                    return this.saveOverwriteAppend(stringBuffer, file, true);
                                }
                                case 1: {
                                    return this.saveOverwriteAppend(stringBuffer, file, false);
                                }
                                case 2: {
                                    return this.save(stringBuffer);
                                }
                            }
                        }
                    }
                } else {
                    this.saveOverwriteAppend(stringBuffer, file, false);
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private boolean saveOverwriteAppend(StringBuffer stringBuffer, File file, boolean bl) {
        try {
            String string = file.getPath();
            if (this.m_Log != null) {
                if (bl) {
                    this.m_Log.statusMessage(LocalString.get("Appending to file..."));
                } else {
                    this.m_Log.statusMessage(LocalString.get("Saving to file..."));
                }
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string, bl)));
            printWriter.write(stringBuffer.toString(), 0, stringBuffer.toString().length());
            printWriter.close();
            if (this.m_Log != null) {
                this.m_Log.statusMessage("OK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.m_Log != null) {
                this.m_Log.logMessage(exception.getMessage());
            }
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("SaveBuffer test"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            LogPanel logPanel = new LogPanel();
            JButton jButton = new JButton(LocalString.get("Save"));
            jFrame.getContentPane().add((Component)jButton, "South");
            jFrame.getContentPane().add((Component)logPanel, "Center");
            final SaveBuffer saveBuffer = new SaveBuffer(logPanel, jFrame);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    saveBuffer.save(new StringBuffer(LocalString.get("A bit of test text")));
                }
            });
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

