/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.LocalString;
import weka.core.Instances;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.ClassAssigner;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;

public class ClassAssignerCustomizer
extends JPanel
implements Customizer,
CustomizerClosingListener,
DataFormatListener {
    private boolean m_displayColNames = false;
    private ClassAssigner m_classAssigner;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private PropertySheetPanel m_caEditor = new PropertySheetPanel();
    private JComboBox m_ClassCombo = new JComboBox();
    private JPanel m_holderP = new JPanel();

    public ClassAssignerCustomizer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(LocalString.get("ClassAssignerCustomizer")), "North");
        this.m_holderP.setLayout(new BorderLayout());
        this.m_holderP.setBorder(BorderFactory.createTitledBorder(LocalString.get("Choose class attribute")));
        this.m_holderP.add((Component)this.m_ClassCombo, "Center");
        this.m_ClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassAssignerCustomizer.this.m_classAssigner != null && ClassAssignerCustomizer.this.m_displayColNames) {
                    ClassAssignerCustomizer.this.m_classAssigner.setClassColumn("" + (ClassAssignerCustomizer.this.m_ClassCombo.getSelectedIndex() + 1));
                }
            }
        });
        this.add((Component)this.m_caEditor, "Center");
    }

    private void setUpStandardSelection() {
        if (this.m_displayColNames) {
            this.remove(this.m_holderP);
            this.m_caEditor.setTarget(this.m_classAssigner);
            this.add((Component)this.m_caEditor, "Center");
            this.m_displayColNames = false;
        }
        this.validate();
        this.repaint();
    }

    private void setUpColumnSelection(Instances instances) {
        int n;
        if (!this.m_displayColNames) {
            this.remove(this.m_caEditor);
        }
        if ((n = instances.classIndex()) < 0) {
            n = 0;
        }
        String[] stringArray = new String[instances.numAttributes()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            switch (instances.attribute(i).type()) {
                case 1: {
                    string = LocalString.get("(Nom) ");
                    break;
                }
                case 0: {
                    string = LocalString.get("(Num) ");
                    break;
                }
                case 2: {
                    string = LocalString.get("(Str) ");
                    break;
                }
                default: {
                    string = "(???) ";
                }
            }
            stringArray[i] = string + instances.attribute(i).name();
        }
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (stringArray.length > 0) {
            this.m_ClassCombo.setSelectedIndex(n);
        }
        if (!this.m_displayColNames) {
            this.add((Component)this.m_holderP, "Center");
            this.m_displayColNames = true;
        }
        this.validate();
        this.repaint();
    }

    public void setObject(Object object) {
        if (this.m_classAssigner != (ClassAssigner)object) {
            if (this.m_classAssigner != null) {
                this.m_classAssigner.removeDataFormatListener(this);
            }
            this.m_classAssigner = (ClassAssigner)object;
            this.m_classAssigner.addDataFormatListener(this);
            this.m_caEditor.setTarget(this.m_classAssigner);
            if (this.m_classAssigner.getConnectedFormat() != null) {
                this.setUpColumnSelection(this.m_classAssigner.getConnectedFormat());
            }
        }
    }

    public void customizerClosing() {
        if (this.m_classAssigner != null) {
            System.err.println(LocalString.get("Customizer deregistering with class assigner"));
            this.m_classAssigner.removeDataFormatListener(this);
        }
    }

    public void newDataFormat(DataSetEvent dataSetEvent) {
        if (dataSetEvent.getDataSet() != null) {
            this.setUpColumnSelection(this.m_classAssigner.getConnectedFormat());
        } else {
            this.setUpStandardSelection();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

