# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create for Creates or updates an App Service Plan.
    """

    _aaz_info = {
        "version": "2025-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.web/serverfarms/{}", "2025-03-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the App Service plan.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "AppServicePlan"

        _args_schema = cls._args_schema
        _args_schema.extended_location = AAZObjectArg(
            options=["--extended-location"],
            arg_group="AppServicePlan",
            help="Extended Location.",
        )
        _args_schema.kind = AAZStrArg(
            options=["--kind"],
            arg_group="AppServicePlan",
            help="Kind of resource. If the resource is an app, you can refer to https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference for details supported values for kind.",
        )
        _args_schema.location = AAZResourceLocationArg(
            arg_group="AppServicePlan",
            help="Resource Location.",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.sku = AAZObjectArg(
            options=["--sku"],
            arg_group="AppServicePlan",
            help="Description of a SKU for a scalable resource.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="AppServicePlan",
            help="Resource tags.",
        )

        extended_location = cls._args_schema.extended_location
        extended_location.name = AAZStrArg(
            options=["name"],
            help="Name of extended location.",
        )

        sku = cls._args_schema.sku
        sku.capabilities = AAZListArg(
            options=["capabilities"],
            help="Capabilities of the SKU, e.g., is traffic manager enabled?",
        )
        sku.capacity = AAZIntArg(
            options=["capacity"],
            help="Current number of instances assigned to the resource.",
        )
        sku.family = AAZStrArg(
            options=["family"],
            help="Family code of the resource SKU.",
        )
        sku.locations = AAZListArg(
            options=["locations"],
            help="Locations of the SKU.",
        )
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of the resource SKU.",
        )
        sku.size = AAZStrArg(
            options=["size"],
            help="Size specifier of the resource SKU.",
        )
        sku.sku_capacity = AAZObjectArg(
            options=["sku-capacity"],
            help="Min, max, and default scale values of the SKU.",
        )
        sku.tier = AAZStrArg(
            options=["tier"],
            help="Service tier of the resource SKU.",
        )

        capabilities = cls._args_schema.sku.capabilities
        capabilities.Element = AAZObjectArg()

        _element = cls._args_schema.sku.capabilities.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the SKU capability.",
        )
        _element.reason = AAZStrArg(
            options=["reason"],
            help="Reason of the SKU capability.",
        )
        _element.value = AAZStrArg(
            options=["value"],
            help="Value of the SKU capability.",
        )

        locations = cls._args_schema.sku.locations
        locations.Element = AAZStrArg()

        sku_capacity = cls._args_schema.sku.sku_capacity
        sku_capacity.default = AAZIntArg(
            options=["default"],
            help="Default number of workers for this App Service plan SKU.",
        )
        sku_capacity.elastic_maximum = AAZIntArg(
            options=["elastic-maximum"],
            help="Maximum number of Elastic workers for this App Service plan SKU.",
        )
        sku_capacity.maximum = AAZIntArg(
            options=["maximum"],
            help="Maximum number of workers for this App Service plan SKU.",
        )
        sku_capacity.minimum = AAZIntArg(
            options=["minimum"],
            help="Minimum number of workers for this App Service plan SKU.",
        )
        sku_capacity.scale_type = AAZStrArg(
            options=["scale-type"],
            help="Available scale configurations for an App Service plan.",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Identity"

        _args_schema = cls._args_schema
        _args_schema.mi_system_assigned = AAZStrArg(
            options=["--system-assigned", "--mi-system-assigned"],
            arg_group="Identity",
            help="Set the system managed identity.",
            blank="True",
        )
        _args_schema.mi_user_assigned = AAZListArg(
            options=["--user-assigned", "--mi-user-assigned"],
            arg_group="Identity",
            help="Set the user managed identities.",
            blank=[],
        )

        mi_user_assigned = cls._args_schema.mi_user_assigned
        mi_user_assigned.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.async_scaling_enabled = AAZBoolArg(
            options=["--async-scaling-enabled"],
            arg_group="Properties",
            help="If <code>true</code>, this App Service Plan will attempt to scale asynchronously if there are insufficient workers to scale synchronously. If <code>false</code>, this App Service Plan will only attempt sync scaling.",
        )
        _args_schema.elastic_scale_enabled = AAZBoolArg(
            options=["--elastic-scale-enabled"],
            arg_group="Properties",
            help="ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku",
        )
        _args_schema.free_offer_expiration_time = AAZDateTimeArg(
            options=["--free-offer-expiration-time"],
            arg_group="Properties",
            help="The time when the server farm free offer expires.",
            fmt=AAZDateTimeFormat(
                protocol="iso",
            ),
        )
        _args_schema.hosting_environment_profile = AAZObjectArg(
            options=["--hosting-environment-profile"],
            arg_group="Properties",
            help="Specification for the App Service Environment to use for the App Service plan.",
        )
        _args_schema.hyper_v = AAZBoolArg(
            options=["--hyper-v"],
            arg_group="Properties",
            help="If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.",
            default=False,
        )
        _args_schema.install_scripts = AAZListArg(
            options=["--install-scripts"],
            arg_group="Properties",
            help="Install scripts associated with this App Service plan.",
        )
        _args_schema.is_custom_mode = AAZBoolArg(
            options=["--is-custom-mode"],
            arg_group="Properties",
            help="Whether this server farm is in custom mode.",
        )
        _args_schema.is_spot = AAZBoolArg(
            options=["--is-spot"],
            arg_group="Properties",
            help="If <code>true</code>, this App Service Plan owns spot instances.",
        )
        _args_schema.is_xenon = AAZBoolArg(
            options=["--is-xenon"],
            arg_group="Properties",
            help="Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.",
            default=False,
        )
        _args_schema.kube_environment_profile = AAZObjectArg(
            options=["--kube-environment-profile"],
            arg_group="Properties",
            help="Specification for the Kubernetes Environment to use for the App Service plan.",
        )
        _args_schema.maximum_elastic_worker_count = AAZIntArg(
            options=["--maximum-elastic-worker-count"],
            arg_group="Properties",
            help="Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan",
        )
        _args_schema.network = AAZObjectArg(
            options=["--network"],
            arg_group="Properties",
            help="All network settings for the server farm.",
        )
        _args_schema.per_site_scaling = AAZBoolArg(
            options=["--per-site-scaling"],
            arg_group="Properties",
            help="If <code>true</code>, apps assigned to this App Service plan can be scaled independently. If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.",
            default=False,
        )
        _args_schema.plan_default_identity = AAZObjectArg(
            options=["--plan-default-identity"],
            arg_group="Properties",
            help="Identity to use by platform for various features and integrations using managed identity.",
        )
        _args_schema.rdp_enabled = AAZBoolArg(
            options=["--rdp-enabled"],
            arg_group="Properties",
            help="If <code>true</code>, RDP access is enabled for this App Service plan. Only applicable for IsCustomMode ASPs. If <code>false</code>, RDP access is disabled.",
        )
        _args_schema.registry_adapters = AAZListArg(
            options=["--registry-adapters"],
            arg_group="Properties",
            help="Registry adapters associated with this App Service plan.",
        )
        _args_schema.reserved = AAZBoolArg(
            options=["--reserved"],
            arg_group="Properties",
            help="If Linux app service plan <code>true</code>, <code>false</code> otherwise.",
            default=False,
        )
        _args_schema.spot_expiration_time = AAZDateTimeArg(
            options=["--spot-expiration-time"],
            arg_group="Properties",
            help="The time when the server farm expires. Valid only if it is a spot server farm.",
            fmt=AAZDateTimeFormat(
                protocol="iso",
            ),
        )
        _args_schema.storage_mounts = AAZListArg(
            options=["--storage-mounts"],
            arg_group="Properties",
            help="Storage mounts associated with this App Service plan.",
        )
        _args_schema.target_worker_count = AAZIntArg(
            options=["--target-worker-count"],
            arg_group="Properties",
            help="Scaling worker count.",
        )
        _args_schema.target_worker_size_id = AAZIntArg(
            options=["--target-worker-size-id"],
            arg_group="Properties",
            help="Scaling worker size ID.",
        )
        _args_schema.worker_tier_name = AAZStrArg(
            options=["--worker-tier-name"],
            arg_group="Properties",
            help="Target worker tier assigned to the App Service plan.",
        )
        _args_schema.zone_redundant = AAZBoolArg(
            options=["--zone-redundant"],
            arg_group="Properties",
            help="If <code>true</code>, this App Service Plan will perform availability zone balancing. If <code>false</code>, this App Service Plan will not perform availability zone balancing.",
            default=False,
        )

        hosting_environment_profile = cls._args_schema.hosting_environment_profile
        hosting_environment_profile.id = AAZStrArg(
            options=["id"],
            help="Resource ID of the App Service Environment.",
        )

        install_scripts = cls._args_schema.install_scripts
        install_scripts.Element = AAZObjectArg()

        _element = cls._args_schema.install_scripts.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the install script.",
        )
        _element.source = AAZObjectArg(
            options=["source"],
            help="Source of the install script.",
        )

        source = cls._args_schema.install_scripts.Element.source
        source.source_uri = AAZStrArg(
            options=["source-uri"],
            help="Install script source URI where the install script file will be fetched from.",
        )
        source.type = AAZStrArg(
            options=["type"],
            help="Type of the install script.",
            enum={"PlatformStorage": "PlatformStorage", "RemoteAzureBlob": "RemoteAzureBlob"},
        )

        kube_environment_profile = cls._args_schema.kube_environment_profile
        kube_environment_profile.id = AAZStrArg(
            options=["id"],
            help="Resource ID of the Kubernetes Environment.",
        )

        network = cls._args_schema.network
        network.virtual_network_subnet_id = AAZStrArg(
            options=["virtual-network-subnet-id"],
            help="Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration. This must be of the form /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}",
        )

        plan_default_identity = cls._args_schema.plan_default_identity
        plan_default_identity.identity_type = AAZStrArg(
            options=["identity-type"],
            enum={"None": "None", "SystemAssigned": "SystemAssigned", "UserAssigned": "UserAssigned"},
        )
        plan_default_identity.user_assigned_identity_resource_id = AAZStrArg(
            options=["user-assigned-identity-resource-id"],
        )

        registry_adapters = cls._args_schema.registry_adapters
        registry_adapters.Element = AAZObjectArg()

        _element = cls._args_schema.registry_adapters.Element
        _element.key_vault_secret_reference = AAZObjectArg(
            options=["key-vault-secret-reference"],
            help="Key vault reference to the value that will be placed in the registry location",
        )
        cls._build_args_key_vault_reference_with_status_create(_element.key_vault_secret_reference)
        _element.registry_key = AAZStrArg(
            options=["registry-key"],
            help="Registry key for the adapter.",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="Type of the registry adapter.",
            enum={"Binary": "Binary", "DWord": "DWord", "Expand_String": "Expand_String", "Multi_String": "Multi_String", "QWord": "QWord", "String": "String"},
        )

        storage_mounts = cls._args_schema.storage_mounts
        storage_mounts.Element = AAZObjectArg()

        _element = cls._args_schema.storage_mounts.Element
        _element.credentials_key_vault_reference = AAZObjectArg(
            options=["credentials-key-vault-reference"],
            help="KV reference to the credentials to connect to the share.",
        )
        cls._build_args_key_vault_reference_with_status_create(_element.credentials_key_vault_reference)
        _element.destination_path = AAZStrArg(
            options=["destination-path"],
            help="Path on worker where storage will be mounted.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the storage mount.",
        )
        _element.source = AAZStrArg(
            options=["source"],
            help="Source of the fileshare/storage.",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="Type of the storage mount.",
            enum={"AzureFiles": "AzureFiles", "FileShare": "FileShare", "LocalStorage": "LocalStorage"},
        )
        return cls._args_schema

    _args_key_vault_reference_with_status_create = None

    @classmethod
    def _build_args_key_vault_reference_with_status_create(cls, _schema):
        if cls._args_key_vault_reference_with_status_create is not None:
            _schema.reference_status = cls._args_key_vault_reference_with_status_create.reference_status
            _schema.secret_uri = cls._args_key_vault_reference_with_status_create.secret_uri
            return

        cls._args_key_vault_reference_with_status_create = AAZObjectArg()

        key_vault_reference_with_status_create = cls._args_key_vault_reference_with_status_create
        key_vault_reference_with_status_create.reference_status = AAZStrArg(
            options=["reference-status"],
            help="Reference status of the key vault secret.",
        )
        key_vault_reference_with_status_create.secret_uri = AAZStrArg(
            options=["secret-uri"],
            help="Key vault secret URI.",
        )

        _schema.reference_status = cls._args_key_vault_reference_with_status_create.reference_status
        _schema.secret_uri = cls._args_key_vault_reference_with_status_create.secret_uri

    def _execute_operations(self):
        self.pre_operations()
        yield self.AppServicePlansCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class AppServicePlansCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("extendedLocation", AAZObjectType, ".extended_location")
            _builder.set_prop("identity", AAZIdentityObjectType)
            _builder.set_prop("kind", AAZStrType, ".kind")
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("sku", AAZObjectType, ".sku")
            _builder.set_prop("tags", AAZDictType, ".tags")

            extended_location = _builder.get(".extendedLocation")
            if extended_location is not None:
                extended_location.set_prop("name", AAZStrType, ".name")

            identity = _builder.get(".identity")
            if identity is not None:
                identity.set_prop("userAssigned", AAZListType, ".mi_user_assigned", typ_kwargs={"flags": {"action": "create"}})
                identity.set_prop("systemAssigned", AAZStrType, ".mi_system_assigned", typ_kwargs={"flags": {"action": "create"}})

            user_assigned = _builder.get(".identity.userAssigned")
            if user_assigned is not None:
                user_assigned.set_elements(AAZStrType, ".")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("asyncScalingEnabled", AAZBoolType, ".async_scaling_enabled")
                properties.set_prop("elasticScaleEnabled", AAZBoolType, ".elastic_scale_enabled")
                properties.set_prop("freeOfferExpirationTime", AAZStrType, ".free_offer_expiration_time")
                properties.set_prop("hostingEnvironmentProfile", AAZObjectType, ".hosting_environment_profile")
                properties.set_prop("hyperV", AAZBoolType, ".hyper_v")
                properties.set_prop("installScripts", AAZListType, ".install_scripts")
                properties.set_prop("isCustomMode", AAZBoolType, ".is_custom_mode")
                properties.set_prop("isSpot", AAZBoolType, ".is_spot")
                properties.set_prop("isXenon", AAZBoolType, ".is_xenon")
                properties.set_prop("kubeEnvironmentProfile", AAZObjectType, ".kube_environment_profile")
                properties.set_prop("maximumElasticWorkerCount", AAZIntType, ".maximum_elastic_worker_count")
                properties.set_prop("network", AAZObjectType, ".network")
                properties.set_prop("perSiteScaling", AAZBoolType, ".per_site_scaling")
                properties.set_prop("planDefaultIdentity", AAZObjectType, ".plan_default_identity")
                properties.set_prop("rdpEnabled", AAZBoolType, ".rdp_enabled")
                properties.set_prop("registryAdapters", AAZListType, ".registry_adapters")
                properties.set_prop("reserved", AAZBoolType, ".reserved")
                properties.set_prop("spotExpirationTime", AAZStrType, ".spot_expiration_time")
                properties.set_prop("storageMounts", AAZListType, ".storage_mounts")
                properties.set_prop("targetWorkerCount", AAZIntType, ".target_worker_count")
                properties.set_prop("targetWorkerSizeId", AAZIntType, ".target_worker_size_id")
                properties.set_prop("workerTierName", AAZStrType, ".worker_tier_name")
                properties.set_prop("zoneRedundant", AAZBoolType, ".zone_redundant")

            hosting_environment_profile = _builder.get(".properties.hostingEnvironmentProfile")
            if hosting_environment_profile is not None:
                hosting_environment_profile.set_prop("id", AAZStrType, ".id")

            install_scripts = _builder.get(".properties.installScripts")
            if install_scripts is not None:
                install_scripts.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.installScripts[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("source", AAZObjectType, ".source")

            source = _builder.get(".properties.installScripts[].source")
            if source is not None:
                source.set_prop("sourceUri", AAZStrType, ".source_uri")
                source.set_prop("type", AAZStrType, ".type")

            kube_environment_profile = _builder.get(".properties.kubeEnvironmentProfile")
            if kube_environment_profile is not None:
                kube_environment_profile.set_prop("id", AAZStrType, ".id")

            network = _builder.get(".properties.network")
            if network is not None:
                network.set_prop("virtualNetworkSubnetId", AAZStrType, ".virtual_network_subnet_id")

            plan_default_identity = _builder.get(".properties.planDefaultIdentity")
            if plan_default_identity is not None:
                plan_default_identity.set_prop("identityType", AAZStrType, ".identity_type")
                plan_default_identity.set_prop("userAssignedIdentityResourceId", AAZStrType, ".user_assigned_identity_resource_id")

            registry_adapters = _builder.get(".properties.registryAdapters")
            if registry_adapters is not None:
                registry_adapters.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.registryAdapters[]")
            if _elements is not None:
                _CreateHelper._build_schema_key_vault_reference_with_status_create(_elements.set_prop("keyVaultSecretReference", AAZObjectType, ".key_vault_secret_reference"))
                _elements.set_prop("registryKey", AAZStrType, ".registry_key")
                _elements.set_prop("type", AAZStrType, ".type")

            storage_mounts = _builder.get(".properties.storageMounts")
            if storage_mounts is not None:
                storage_mounts.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.storageMounts[]")
            if _elements is not None:
                _CreateHelper._build_schema_key_vault_reference_with_status_create(_elements.set_prop("credentialsKeyVaultReference", AAZObjectType, ".credentials_key_vault_reference"))
                _elements.set_prop("destinationPath", AAZStrType, ".destination_path")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("source", AAZStrType, ".source")
                _elements.set_prop("type", AAZStrType, ".type")

            sku = _builder.get(".sku")
            if sku is not None:
                sku.set_prop("capabilities", AAZListType, ".capabilities")
                sku.set_prop("capacity", AAZIntType, ".capacity")
                sku.set_prop("family", AAZStrType, ".family")
                sku.set_prop("locations", AAZListType, ".locations")
                sku.set_prop("name", AAZStrType, ".name")
                sku.set_prop("size", AAZStrType, ".size")
                sku.set_prop("skuCapacity", AAZObjectType, ".sku_capacity")
                sku.set_prop("tier", AAZStrType, ".tier")

            capabilities = _builder.get(".sku.capabilities")
            if capabilities is not None:
                capabilities.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".sku.capabilities[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("reason", AAZStrType, ".reason")
                _elements.set_prop("value", AAZStrType, ".value")

            locations = _builder.get(".sku.locations")
            if locations is not None:
                locations.set_elements(AAZStrType, ".")

            sku_capacity = _builder.get(".sku.skuCapacity")
            if sku_capacity is not None:
                sku_capacity.set_prop("default", AAZIntType, ".default")
                sku_capacity.set_prop("elasticMaximum", AAZIntType, ".elastic_maximum")
                sku_capacity.set_prop("maximum", AAZIntType, ".maximum")
                sku_capacity.set_prop("minimum", AAZIntType, ".minimum")
                sku_capacity.set_prop("scaleType", AAZStrType, ".scale_type")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _CreateHelper._build_schema_app_service_plan_read(cls._schema_on_200)

            return cls._schema_on_200


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_key_vault_reference_with_status_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("referenceStatus", AAZStrType, ".reference_status")
        _builder.set_prop("secretUri", AAZStrType, ".secret_uri")

    _schema_app_service_plan_read = None

    @classmethod
    def _build_schema_app_service_plan_read(cls, _schema):
        if cls._schema_app_service_plan_read is not None:
            _schema.extended_location = cls._schema_app_service_plan_read.extended_location
            _schema.id = cls._schema_app_service_plan_read.id
            _schema.identity = cls._schema_app_service_plan_read.identity
            _schema.kind = cls._schema_app_service_plan_read.kind
            _schema.location = cls._schema_app_service_plan_read.location
            _schema.name = cls._schema_app_service_plan_read.name
            _schema.properties = cls._schema_app_service_plan_read.properties
            _schema.sku = cls._schema_app_service_plan_read.sku
            _schema.tags = cls._schema_app_service_plan_read.tags
            _schema.type = cls._schema_app_service_plan_read.type
            return

        cls._schema_app_service_plan_read = _schema_app_service_plan_read = AAZObjectType()

        app_service_plan_read = _schema_app_service_plan_read
        app_service_plan_read.extended_location = AAZObjectType(
            serialized_name="extendedLocation",
        )
        app_service_plan_read.id = AAZStrType(
            flags={"read_only": True},
        )
        app_service_plan_read.identity = AAZIdentityObjectType()
        app_service_plan_read.kind = AAZStrType()
        app_service_plan_read.location = AAZStrType(
            flags={"required": True},
        )
        app_service_plan_read.name = AAZStrType(
            flags={"read_only": True},
        )
        app_service_plan_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        app_service_plan_read.sku = AAZObjectType()
        app_service_plan_read.tags = AAZDictType()
        app_service_plan_read.type = AAZStrType(
            flags={"read_only": True},
        )

        extended_location = _schema_app_service_plan_read.extended_location
        extended_location.name = AAZStrType()
        extended_location.type = AAZStrType(
            flags={"read_only": True},
        )

        identity = _schema_app_service_plan_read.identity
        identity.principal_id = AAZStrType(
            serialized_name="principalId",
            flags={"read_only": True},
        )
        identity.tenant_id = AAZStrType(
            serialized_name="tenantId",
            flags={"read_only": True},
        )
        identity.type = AAZStrType()
        identity.user_assigned_identities = AAZDictType(
            serialized_name="userAssignedIdentities",
        )

        user_assigned_identities = _schema_app_service_plan_read.identity.user_assigned_identities
        user_assigned_identities.Element = AAZObjectType()

        _element = _schema_app_service_plan_read.identity.user_assigned_identities.Element
        _element.client_id = AAZStrType(
            serialized_name="clientId",
            flags={"read_only": True},
        )
        _element.principal_id = AAZStrType(
            serialized_name="principalId",
            flags={"read_only": True},
        )

        properties = _schema_app_service_plan_read.properties
        properties.async_scaling_enabled = AAZBoolType(
            serialized_name="asyncScalingEnabled",
        )
        properties.elastic_scale_enabled = AAZBoolType(
            serialized_name="elasticScaleEnabled",
        )
        properties.free_offer_expiration_time = AAZStrType(
            serialized_name="freeOfferExpirationTime",
        )
        properties.geo_region = AAZStrType(
            serialized_name="geoRegion",
            flags={"read_only": True},
        )
        properties.hosting_environment_profile = AAZObjectType(
            serialized_name="hostingEnvironmentProfile",
        )
        properties.hyper_v = AAZBoolType(
            serialized_name="hyperV",
        )
        properties.install_scripts = AAZListType(
            serialized_name="installScripts",
        )
        properties.is_custom_mode = AAZBoolType(
            serialized_name="isCustomMode",
        )
        properties.is_spot = AAZBoolType(
            serialized_name="isSpot",
        )
        properties.is_xenon = AAZBoolType(
            serialized_name="isXenon",
        )
        properties.kube_environment_profile = AAZObjectType(
            serialized_name="kubeEnvironmentProfile",
        )
        properties.maximum_elastic_worker_count = AAZIntType(
            serialized_name="maximumElasticWorkerCount",
        )
        properties.maximum_number_of_workers = AAZIntType(
            serialized_name="maximumNumberOfWorkers",
            flags={"read_only": True},
        )
        properties.network = AAZObjectType()
        properties.number_of_sites = AAZIntType(
            serialized_name="numberOfSites",
            flags={"read_only": True},
        )
        properties.number_of_workers = AAZIntType(
            serialized_name="numberOfWorkers",
            flags={"read_only": True},
        )
        properties.per_site_scaling = AAZBoolType(
            serialized_name="perSiteScaling",
        )
        properties.plan_default_identity = AAZObjectType(
            serialized_name="planDefaultIdentity",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.rdp_enabled = AAZBoolType(
            serialized_name="rdpEnabled",
        )
        properties.registry_adapters = AAZListType(
            serialized_name="registryAdapters",
        )
        properties.reserved = AAZBoolType()
        properties.resource_group = AAZStrType(
            serialized_name="resourceGroup",
            flags={"read_only": True},
        )
        properties.spot_expiration_time = AAZStrType(
            serialized_name="spotExpirationTime",
        )
        properties.status = AAZStrType(
            flags={"read_only": True},
        )
        properties.storage_mounts = AAZListType(
            serialized_name="storageMounts",
        )
        properties.subscription = AAZStrType(
            flags={"read_only": True},
        )
        properties.target_worker_count = AAZIntType(
            serialized_name="targetWorkerCount",
        )
        properties.target_worker_size_id = AAZIntType(
            serialized_name="targetWorkerSizeId",
        )
        properties.worker_tier_name = AAZStrType(
            serialized_name="workerTierName",
        )
        properties.zone_redundant = AAZBoolType(
            serialized_name="zoneRedundant",
        )

        hosting_environment_profile = _schema_app_service_plan_read.properties.hosting_environment_profile
        hosting_environment_profile.id = AAZStrType()
        hosting_environment_profile.name = AAZStrType(
            flags={"read_only": True},
        )
        hosting_environment_profile.type = AAZStrType(
            flags={"read_only": True},
        )

        install_scripts = _schema_app_service_plan_read.properties.install_scripts
        install_scripts.Element = AAZObjectType()

        _element = _schema_app_service_plan_read.properties.install_scripts.Element
        _element.name = AAZStrType()
        _element.source = AAZObjectType()

        source = _schema_app_service_plan_read.properties.install_scripts.Element.source
        source.source_uri = AAZStrType(
            serialized_name="sourceUri",
        )
        source.type = AAZStrType()

        kube_environment_profile = _schema_app_service_plan_read.properties.kube_environment_profile
        kube_environment_profile.id = AAZStrType()
        kube_environment_profile.name = AAZStrType(
            flags={"read_only": True},
        )
        kube_environment_profile.type = AAZStrType(
            flags={"read_only": True},
        )

        network = _schema_app_service_plan_read.properties.network
        network.virtual_network_subnet_id = AAZStrType(
            serialized_name="virtualNetworkSubnetId",
        )

        plan_default_identity = _schema_app_service_plan_read.properties.plan_default_identity
        plan_default_identity.identity_type = AAZStrType(
            serialized_name="identityType",
        )
        plan_default_identity.user_assigned_identity_resource_id = AAZStrType(
            serialized_name="userAssignedIdentityResourceId",
        )

        registry_adapters = _schema_app_service_plan_read.properties.registry_adapters
        registry_adapters.Element = AAZObjectType()

        _element = _schema_app_service_plan_read.properties.registry_adapters.Element
        _element.key_vault_secret_reference = AAZObjectType(
            serialized_name="keyVaultSecretReference",
        )
        cls._build_schema_key_vault_reference_with_status_read(_element.key_vault_secret_reference)
        _element.registry_key = AAZStrType(
            serialized_name="registryKey",
        )
        _element.type = AAZStrType()

        storage_mounts = _schema_app_service_plan_read.properties.storage_mounts
        storage_mounts.Element = AAZObjectType()

        _element = _schema_app_service_plan_read.properties.storage_mounts.Element
        _element.credentials_key_vault_reference = AAZObjectType(
            serialized_name="credentialsKeyVaultReference",
        )
        cls._build_schema_key_vault_reference_with_status_read(_element.credentials_key_vault_reference)
        _element.destination_path = AAZStrType(
            serialized_name="destinationPath",
        )
        _element.name = AAZStrType()
        _element.source = AAZStrType()
        _element.type = AAZStrType()

        sku = _schema_app_service_plan_read.sku
        sku.capabilities = AAZListType()
        sku.capacity = AAZIntType()
        sku.family = AAZStrType()
        sku.locations = AAZListType()
        sku.name = AAZStrType()
        sku.size = AAZStrType()
        sku.sku_capacity = AAZObjectType(
            serialized_name="skuCapacity",
        )
        sku.tier = AAZStrType()

        capabilities = _schema_app_service_plan_read.sku.capabilities
        capabilities.Element = AAZObjectType()

        _element = _schema_app_service_plan_read.sku.capabilities.Element
        _element.name = AAZStrType()
        _element.reason = AAZStrType()
        _element.value = AAZStrType()

        locations = _schema_app_service_plan_read.sku.locations
        locations.Element = AAZStrType()

        sku_capacity = _schema_app_service_plan_read.sku.sku_capacity
        sku_capacity.default = AAZIntType()
        sku_capacity.elastic_maximum = AAZIntType(
            serialized_name="elasticMaximum",
        )
        sku_capacity.maximum = AAZIntType()
        sku_capacity.minimum = AAZIntType()
        sku_capacity.scale_type = AAZStrType(
            serialized_name="scaleType",
        )

        tags = _schema_app_service_plan_read.tags
        tags.Element = AAZStrType()

        _schema.extended_location = cls._schema_app_service_plan_read.extended_location
        _schema.id = cls._schema_app_service_plan_read.id
        _schema.identity = cls._schema_app_service_plan_read.identity
        _schema.kind = cls._schema_app_service_plan_read.kind
        _schema.location = cls._schema_app_service_plan_read.location
        _schema.name = cls._schema_app_service_plan_read.name
        _schema.properties = cls._schema_app_service_plan_read.properties
        _schema.sku = cls._schema_app_service_plan_read.sku
        _schema.tags = cls._schema_app_service_plan_read.tags
        _schema.type = cls._schema_app_service_plan_read.type

    _schema_key_vault_reference_with_status_read = None

    @classmethod
    def _build_schema_key_vault_reference_with_status_read(cls, _schema):
        if cls._schema_key_vault_reference_with_status_read is not None:
            _schema.reference_status = cls._schema_key_vault_reference_with_status_read.reference_status
            _schema.secret_uri = cls._schema_key_vault_reference_with_status_read.secret_uri
            return

        cls._schema_key_vault_reference_with_status_read = _schema_key_vault_reference_with_status_read = AAZObjectType()

        key_vault_reference_with_status_read = _schema_key_vault_reference_with_status_read
        key_vault_reference_with_status_read.reference_status = AAZStrType(
            serialized_name="referenceStatus",
        )
        key_vault_reference_with_status_read.secret_uri = AAZStrType(
            serialized_name="secretUri",
        )

        _schema.reference_status = cls._schema_key_vault_reference_with_status_read.reference_status
        _schema.secret_uri = cls._schema_key_vault_reference_with_status_read.secret_uri


__all__ = ["Create"]
