/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.model;

import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import java.util.Collection;

public class AveragedPerceptron
extends LinearModel {
    public AveragedPerceptron(FeatureMap featureMap, float[] parameter) {
        super(featureMap, parameter);
    }

    public AveragedPerceptron(FeatureMap featureMap) {
        super(featureMap);
    }

    public void update(int[] goldIndex, int[] predictIndex, double[] total, int[] timestamp, int current) {
        for (int i = 0; i < goldIndex.length; ++i) {
            if (goldIndex[i] == predictIndex[i]) continue;
            this.update(goldIndex[i], 1.0f, total, timestamp, current);
            if (predictIndex[i] >= 0 && predictIndex[i] < this.parameter.length) {
                this.update(predictIndex[i], -1.0f, total, timestamp, current);
                continue;
            }
            throw new IllegalArgumentException("\u66f4\u65b0\u53c2\u6570\u65f6\u4f20\u5165\u4e86\u975e\u6cd5\u7684\u4e0b\u6807");
        }
    }

    public void update(Collection<Integer> featureVector, float value, double[] total, int[] timestamp, int current) {
        for (Integer i : featureVector) {
            this.update(i, value, total, timestamp, current);
        }
    }

    private void update(int index, float value, double[] total, int[] timestamp, int current) {
        int passed = current - timestamp[index];
        int n = index;
        total[n] = total[n] + (double)((float)passed * this.parameter[index]);
        int n2 = index;
        this.parameter[n2] = this.parameter[n2] + value;
        timestamp[index] = current;
    }

    public void average(double[] total, int[] timestamp, int current) {
        for (int i = 0; i < this.parameter.length; ++i) {
            this.parameter[i] = (float)((total[i] + (double)((float)(current - timestamp[i]) * this.parameter[i])) / (double)current);
        }
    }
}

