'' FreeBASIC binding for mingw-w64-v4.0.4
''
'' based on the C header files:
''   This Software is provided under the Zope Public License (ZPL) Version 2.1.
''
''   Copyright (c) 2009, 2010 by the mingw-w64 project
''
''   See the AUTHORS file for the list of contributors to the mingw-w64 project.
''
''   This license has been certified as open source. It has also been designated
''   as GPL compatible by the Free Software Foundation (FSF).
''
''   Redistribution and use in source and binary forms, with or without
''   modification, are permitted provided that the following conditions are met:
''
''     1. Redistributions in source code must retain the accompanying copyright
''        notice, this list of conditions, and the following disclaimer.
''     2. Redistributions in binary form must reproduce the accompanying
''        copyright notice, this list of conditions, and the following disclaimer
''        in the documentation and/or other materials provided with the
''        distribution.
''     3. Names of the copyright holders must not be used to endorse or promote
''        products derived from this software without prior written permission
''        from the copyright holders.
''     4. The right to distribute this software or to use it for any purpose does
''        not give you the right to use Servicemarks (sm) or Trademarks (tm) of
''        the copyright holders.  Use of them is covered by separate agreement
''        with the copyright holders.
''     5. If any files are modified, you must cause the modified files to carry
''        prominent notices stating that you changed the files and the date of
''        any change.
''
''   Disclaimer
''
''   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESSED
''   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
''   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
''   EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
''   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
''   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
''   OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
''   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
''   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
''   EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
''
'' translated to FreeBASIC by:
''   FreeBASIC development team

#pragma once

#define _KTMTYPES_
type CRM_PROTOCOL_ID as GUID
type PCRM_PROTOCOL_ID as GUID ptr
const TRANSACTION_MANAGER_VOLATILE = &h00000001
const TRANSACTION_MANAGER_COMMIT_DEFAULT = &h00000000
const TRANSACTION_MANAGER_COMMIT_SYSTEM_VOLUME = &h00000002
const TRANSACTION_MANAGER_COMMIT_SYSTEM_HIVES = &h00000004
const TRANSACTION_MANAGER_COMMIT_LOWEST = &h00000008
const TRANSACTION_MANAGER_CORRUPT_FOR_RECOVERY = &h00000010
const TRANSACTION_MANAGER_CORRUPT_FOR_PROGRESS = &h00000020
const TRANSACTION_MANAGER_MAXIMUM_OPTION = &h0000003f
const TRANSACTION_DO_NOT_PROMOTE = &h00000001
const TRANSACTION_MAXIMUM_OPTION = &h00000001
const RESOURCE_MANAGER_VOLATILE = &h00000001
const RESOURCE_MANAGER_COMMUNICATION = &h00000002
const RESOURCE_MANAGER_MAXIMUM_OPTION = &h00000003
const CRM_PROTOCOL_EXPLICIT_MARSHAL_ONLY = &h00000001
const CRM_PROTOCOL_DYNAMIC_MARSHAL_INFO = &h00000002
const CRM_PROTOCOL_MAXIMUM_OPTION = &h00000003
const ENLISTMENT_SUPERIOR = &h00000001
const ENLISTMENT_MAXIMUM_OPTION = &h00000001
type NOTIFICATION_MASK as ULONG
const TRANSACTION_NOTIFY_MASK = &h3fffffff
const TRANSACTION_NOTIFY_PREPREPARE = &h00000001
const TRANSACTION_NOTIFY_PREPARE = &h00000002
const TRANSACTION_NOTIFY_COMMIT = &h00000004
const TRANSACTION_NOTIFY_ROLLBACK = &h00000008
const TRANSACTION_NOTIFY_PREPREPARE_COMPLETE = &h00000010
const TRANSACTION_NOTIFY_PREPARE_COMPLETE = &h00000020
const TRANSACTION_NOTIFY_COMMIT_COMPLETE = &h00000040
const TRANSACTION_NOTIFY_ROLLBACK_COMPLETE = &h00000080
const TRANSACTION_NOTIFY_RECOVER = &h00000100
const TRANSACTION_NOTIFY_SINGLE_PHASE_COMMIT = &h00000200
const TRANSACTION_NOTIFY_DELEGATE_COMMIT = &h00000400
const TRANSACTION_NOTIFY_RECOVER_QUERY = &h00000800
const TRANSACTION_NOTIFY_ENLIST_PREPREPARE = &h00001000
const TRANSACTION_NOTIFY_LAST_RECOVER = &h00002000
const TRANSACTION_NOTIFY_INDOUBT = &h00004000
const TRANSACTION_NOTIFY_PROPAGATE_PULL = &h00008000
const TRANSACTION_NOTIFY_PROPAGATE_PUSH = &h00010000
const TRANSACTION_NOTIFY_MARSHAL = &h00020000
const TRANSACTION_NOTIFY_ENLIST_MASK = &h00040000
const TRANSACTION_NOTIFY_RM_DISCONNECTED = &h01000000
const TRANSACTION_NOTIFY_TM_ONLINE = &h02000000
const TRANSACTION_NOTIFY_COMMIT_REQUEST = &h04000000
const TRANSACTION_NOTIFY_PROMOTE = &h08000000
const TRANSACTION_NOTIFY_PROMOTE_NEW = &h10000000
const TRANSACTION_NOTIFY_REQUEST_OUTCOME = &h20000000
const TRANSACTION_NOTIFY_COMMIT_FINALIZE = &h40000000
#define TRANSACTIONMANAGER_OBJECT_PATH wstr(!"\\TransactionManager\\")
#define TRANSACTION_OBJECT_PATH wstr(!"\\Transaction\\")
#define ENLISTMENT_OBJECT_PATH wstr(!"\\Enlistment\\")
#define RESOURCE_MANAGER_OBJECT_PATH wstr(!"\\ResourceManager\\")
#define TRANSACTIONMANAGER_OBJECT_NAME_LENGTH_IN_BYTES (sizeof(TRANSACTIONMANAGER_OBJECT_PATH) + (38 * sizeof(WCHAR)))
#define TRANSACTION_OBJECT_NAME_LENGTH_IN_BYTES (sizeof(TRANSACTION_OBJECT_PATH) + (38 * sizeof(WCHAR)))
#define ENLISTMENT_OBJECT_NAME_LENGTH_IN_BYTES (sizeof(ENLISTMENT_OBJECT_PATH) + (38 * sizeof(WCHAR)))
#define RESOURCE_MANAGER_OBJECT_NAME_LENGTH_IN_BYTES (sizeof(RESOURCE_MANAGER_OBJECT_PATH) + (38 * sizeof(WCHAR)))

type _TRANSACTION_NOTIFICATION
	TransactionKey as PVOID
	TransactionNotification as ULONG
	TmVirtualClock as LARGE_INTEGER
	ArgumentLength as ULONG
end type

type TRANSACTION_NOTIFICATION as _TRANSACTION_NOTIFICATION
type PTRANSACTION_NOTIFICATION as _TRANSACTION_NOTIFICATION ptr

type _TRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT
	EnlistmentId as GUID
	UOW as GUID
end type

type TRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT as _TRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT
type PTRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT as _TRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT ptr
const TRANSACTION_NOTIFICATION_TM_ONLINE_FLAG_IS_CLUSTERED = &h1

type _TRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT
	TmIdentity as GUID
	Flags as ULONG
end type

type TRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT as _TRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT
type PTRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT as _TRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT ptr
type SAVEPOINT_ID as ULONG
type PSAVEPOINT_ID as ULONG ptr

type _TRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT
	SavepointId as SAVEPOINT_ID
end type

type TRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT as _TRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT
type PTRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT as _TRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT ptr

type _TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT
	PropagationCookie as ULONG
	UOW as GUID
	TmIdentity as GUID
	BufferLength as ULONG
end type

type TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT as _TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT
type PTRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT as _TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT ptr

type _TRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT
	MarshalCookie as ULONG
	UOW as GUID
end type

type TRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT as _TRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT
type PTRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT as _TRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT ptr
type TRANSACTION_NOTIFICATION_PROMOTE_ARGUMENT as TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT
type PTRANSACTION_NOTIFICATION_PROMOTE_ARGUMENT as TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT ptr

const KTM_MARSHAL_BLOB_VERSION_MAJOR = 1
const KTM_MARSHAL_BLOB_VERSION_MINOR = 1
const MAX_TRANSACTION_DESCRIPTION_LENGTH = 64
const MAX_RESOURCEMANAGER_DESCRIPTION_LENGTH = 64

type _KCRM_MARSHAL_HEADER
	VersionMajor as ULONG
	VersionMinor as ULONG
	NumProtocols as ULONG
	Unused as ULONG
end type

type KCRM_MARSHAL_HEADER as _KCRM_MARSHAL_HEADER
type PKCRM_MARSHAL_HEADER as _KCRM_MARSHAL_HEADER ptr
type PRKCRM_MARSHAL_HEADER as _KCRM_MARSHAL_HEADER ptr

type _KCRM_TRANSACTION_BLOB
	UOW as GUID
	TmIdentity as GUID
	IsolationLevel as ULONG
	IsolationFlags as ULONG
	Timeout as ULONG
	Description as wstring * 64
end type

type KCRM_TRANSACTION_BLOB as _KCRM_TRANSACTION_BLOB
type PKCRM_TRANSACTION_BLOB as _KCRM_TRANSACTION_BLOB ptr
type PRKCRM_TRANSACTION_BLOB as _KCRM_TRANSACTION_BLOB ptr

type _KCRM_PROTOCOL_BLOB
	ProtocolId as CRM_PROTOCOL_ID
	StaticInfoLength as ULONG
	TransactionIdInfoLength as ULONG
	Unused1 as ULONG
	Unused2 as ULONG
end type

type KCRM_PROTOCOL_BLOB as _KCRM_PROTOCOL_BLOB
type PKCRM_PROTOCOL_BLOB as _KCRM_PROTOCOL_BLOB ptr
type PRKCRM_PROTOCOL_BLOB as _KCRM_PROTOCOL_BLOB ptr
