/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.compare.ParametersDiffResult;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredBuilder;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;

public class ParametersDiff {
    private static final RefPointer<Parameter> refPointer = new RefPointer(RefType.PARAMETERS);
    private final Components leftComponents;
    private final Components rightComponents;
    private final OpenApiDiff openApiDiff;

    public ParametersDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public static Optional<Parameter> contains(Components components, List<Parameter> parameters, Parameter parameter) {
        return parameters.stream().filter(param -> ParametersDiff.same(refPointer.resolveRef(components, (Parameter)param, param.get$ref()), parameter)).findFirst();
    }

    public static boolean same(Parameter left, Parameter right) {
        return Objects.equals(left.getName(), right.getName()) && Objects.equals(left.getIn(), right.getIn());
    }

    public ParametersDiffResult diff(List<Parameter> left, List<Parameter> right, DiffContext context) {
        DeferredBuilder builder = new DeferredBuilder();
        List wLeft = Optional.ofNullable(left).orElseGet(Collections::emptyList);
        List wRight = Optional.ofNullable(right).map(ArrayList::new).orElseGet(ArrayList::new);
        ChangedParameters changedParameters = new ChangedParameters(wLeft, wRight, context);
        for (Parameter leftParam : wLeft) {
            Optional<Parameter> rightParamOpt = ParametersDiff.contains(this.rightComponents, wRight, leftParam = refPointer.resolveRef(this.leftComponents, leftParam, leftParam.get$ref()));
            if (!rightParamOpt.isPresent()) {
                changedParameters.getMissing().add(leftParam);
                continue;
            }
            Parameter rightParam = rightParamOpt.get();
            wRight.remove(rightParam);
            builder.with(this.openApiDiff.getParameterDiff().diff(leftParam, rightParam, context)).ifPresent(changedParameters.getChanged()::add);
        }
        changedParameters.getIncreased().addAll(wRight);
        return new ParametersDiffResult(builder.buildIsChanged(changedParameters), this.pathUnchangedParametersChanged(changedParameters, context));
    }

    public boolean pathUnchangedParametersChanged(ChangedParameters changedParameters, DiffContext context) {
        if (!this.pathUnchanged(changedParameters, context)) {
            return false;
        }
        if (changedParameters.getMissing().size() != changedParameters.getIncreased().size()) {
            return false;
        }
        for (Parameter parameter : changedParameters.getMissing()) {
            String newParameterName = context.getParameters().get(parameter.getName());
            if (StringUtils.isBlank(newParameterName)) {
                return false;
            }
            Optional<Parameter> newParameter = changedParameters.getIncreased().stream().filter(p -> p.getName().equals(newParameterName)).findFirst();
            if (!newParameter.isPresent()) {
                return false;
            }
            Parameter newParameterRealized = newParameter.get();
            newParameterRealized.setName(parameter.getName());
            boolean samePathDifferentParameter = !newParameterRealized.equals(parameter);
            newParameterRealized.setName(newParameterName);
            if (!samePathDifferentParameter) continue;
            return true;
        }
        return false;
    }

    public boolean pathUnchanged(ChangedParameters changedParameters, DiffContext context) {
        String REGEX_PATH = "\\{([^/]+)}";
        String oldUrl = context.getLeftUrl();
        String newUrl = context.getRightUrl();
        ArrayList<String> oldUrlPathParams = this.matchedItems(oldUrl, "\\{([^/]+)}");
        ArrayList<String> newUrlPathParams = this.matchedItems(newUrl, "\\{([^/]+)}");
        return oldUrlPathParams.size() == newUrlPathParams.size() && changedParameters.getChanged().isEmpty() && oldUrl.replaceAll("\\{([^/]+)}", "").equals(newUrl.replaceAll("\\{([^/]+)}", ""));
    }

    public ArrayList<String> matchedItems(String string, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(string);
        ArrayList<String> matchedItems = new ArrayList<String>();
        while (matcher.find()) {
            String item = matcher.group();
            matchedItems.add(item.substring(0, matcher.group().length() - 1).replaceFirst("\\{", ""));
        }
        return matchedItems;
    }
}

