# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the ios_acls module
"""


class AclsArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_acls module"""

    argument_spec = {
        "config": {
            "elements": "dict",
            "options": {
                "acls": {
                    "elements": "dict",
                    "options": {
                        "aces": {
                            "elements": "dict",
                            "options": {
                                "destination": {
                                    "options": {
                                        "address": {"type": "str"},
                                        "any": {"type": "bool"},
                                        "host": {"type": "str"},
                                        "object_group": {"type": "str"},
                                        "port_protocol": {
                                            "options": {
                                                "eq": {"type": "str"},
                                                "gt": {"type": "str"},
                                                "lt": {"type": "str"},
                                                "neq": {"type": "str"},
                                                "range": {
                                                    "options": {
                                                        "end": {"type": "int"},
                                                        "start": {"type": "int"},
                                                    },
                                                    "type": "dict",
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "wildcard_bits": {"type": "str"},
                                    },
                                    "type": "dict",
                                },
                                "dscp": {"type": "str"},
                                "evaluate": {"type": "str"},
                                "fragments": {"type": "str"},
                                "enable_fragments": {"type": "bool"},
                                "grant": {"choices": ["permit", "deny"], "type": "str"},
                                "log": {
                                    "options": {
                                        "set": {"type": "bool"},
                                        "user_cookie": {"type": "str"},
                                    },
                                    "type": "dict",
                                },
                                "log_input": {
                                    "options": {
                                        "set": {"type": "bool"},
                                        "user_cookie": {"type": "str"},
                                    },
                                    "type": "dict",
                                },
                                "option": {
                                    "options": {
                                        "add_ext": {"type": "bool"},
                                        "any_options": {"type": "bool"},
                                        "com_security": {"type": "bool"},
                                        "dps": {"type": "bool"},
                                        "encode": {"type": "bool"},
                                        "eool": {"type": "bool"},
                                        "ext_ip": {"type": "bool"},
                                        "ext_security": {"type": "bool"},
                                        "finn": {"type": "bool"},
                                        "imitd": {"type": "bool"},
                                        "lsr": {"type": "bool"},
                                        "mtup": {"type": "bool"},
                                        "mtur": {"type": "bool"},
                                        "no_op": {"type": "bool"},
                                        "nsapa": {"type": "bool"},
                                        "record_route": {"type": "bool"},
                                        "router_alert": {"type": "bool"},
                                        "sdb": {"type": "bool"},
                                        "security": {"type": "bool"},
                                        "ssr": {"type": "bool"},
                                        "stream_id": {"type": "bool"},
                                        "timestamp": {"type": "bool"},
                                        "traceroute": {"type": "bool"},
                                        "ump": {"type": "bool"},
                                        "visa": {"type": "bool"},
                                        "zsu": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "precedence": {"type": "str"},
                                "protocol": {"type": "str"},
                                "protocol_options": {
                                    "options": {
                                        "ahp": {"type": "bool"},
                                        "eigrp": {"type": "bool"},
                                        "esp": {"type": "bool"},
                                        "gre": {"type": "bool"},
                                        "hbh": {"type": "bool"},
                                        "icmp": {
                                            "options": {
                                                "administratively_prohibited": {"type": "bool"},
                                                "alternate_address": {"type": "bool"},
                                                "conversion_error": {"type": "bool"},
                                                "dod_host_prohibited": {"type": "bool"},
                                                "dod_net_prohibited": {"type": "bool"},
                                                "echo": {"type": "bool"},
                                                "echo_reply": {"type": "bool"},
                                                "general_parameter_problem": {"type": "bool"},
                                                "host_isolated": {"type": "bool"},
                                                "host_precedence_unreachable": {"type": "bool"},
                                                "host_redirect": {"type": "bool"},
                                                "host_tos_redirect": {"type": "bool"},
                                                "host_tos_unreachable": {"type": "bool"},
                                                "host_unknown": {"type": "bool"},
                                                "host_unreachable": {"type": "bool"},
                                                "information_reply": {"type": "bool"},
                                                "information_request": {"type": "bool"},
                                                "mask_reply": {"type": "bool"},
                                                "mask_request": {"type": "bool"},
                                                "mobile_redirect": {"type": "bool"},
                                                "net_redirect": {"type": "bool"},
                                                "net_tos_redirect": {"type": "bool"},
                                                "net_tos_unreachable": {"type": "bool"},
                                                "net_unreachable": {"type": "bool"},
                                                "network_unknown": {"type": "bool"},
                                                "no_room_for_option": {"type": "bool"},
                                                "option_missing": {"type": "bool"},
                                                "packet_too_big": {"type": "bool"},
                                                "parameter_problem": {"type": "bool"},
                                                "port_unreachable": {"type": "bool"},
                                                "precedence_unreachable": {"type": "bool"},
                                                "protocol_unreachable": {"type": "bool"},
                                                "reassembly_timeout": {"type": "bool"},
                                                "redirect": {"type": "bool"},
                                                "router_advertisement": {"type": "bool"},
                                                "router_solicitation": {"type": "bool"},
                                                "source_quench": {"type": "bool"},
                                                "source_route_failed": {"type": "bool"},
                                                "time_exceeded": {"type": "bool"},
                                                "timestamp_reply": {"type": "bool"},
                                                "timestamp_request": {"type": "bool"},
                                                "traceroute": {"type": "bool"},
                                                "ttl_exceeded": {"type": "bool"},
                                                "unreachable": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "igmp": {
                                            "options": {
                                                "dvmrp": {"type": "bool"},
                                                "host_query": {"type": "bool"},
                                                "mtrace_resp": {"type": "bool"},
                                                "mtrace_route": {"type": "bool"},
                                                "pim": {"type": "bool"},
                                                "trace": {"type": "bool"},
                                                "v1host_report": {"type": "bool"},
                                                "v2host_report": {"type": "bool"},
                                                "v2leave_group": {"type": "bool"},
                                                "v3host_report": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "ip": {"type": "bool"},
                                        "ipinip": {"type": "bool"},
                                        "ipv6": {"type": "bool"},
                                        "nos": {"type": "bool"},
                                        "ospf": {"type": "bool"},
                                        "pcp": {"type": "bool"},
                                        "pim": {"type": "bool"},
                                        "protocol_number": {"type": "int"},
                                        "sctp": {"type": "bool"},
                                        "tcp": {
                                            "options": {
                                                "ack": {"type": "bool"},
                                                "established": {"type": "bool"},
                                                "fin": {"type": "bool"},
                                                "psh": {"type": "bool"},
                                                "rst": {"type": "bool"},
                                                "syn": {"type": "bool"},
                                                "urg": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "udp": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "remarks": {"elements": "str", "type": "list"},
                                "sequence": {"type": "int"},
                                "source": {
                                    "options": {
                                        "address": {"type": "str"},
                                        "any": {"type": "bool"},
                                        "host": {"type": "str"},
                                        "object_group": {"type": "str"},
                                        "port_protocol": {
                                            "options": {
                                                "eq": {"type": "str"},
                                                "gt": {"type": "str"},
                                                "lt": {"type": "str"},
                                                "neq": {"type": "str"},
                                                "range": {
                                                    "options": {
                                                        "end": {"type": "int"},
                                                        "start": {"type": "int"},
                                                    },
                                                    "type": "dict",
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "wildcard_bits": {"type": "str"},
                                    },
                                    "type": "dict",
                                },
                                "time_range": {"type": "str"},
                                "tos": {
                                    "options": {
                                        "max_reliability": {"type": "bool"},
                                        "max_throughput": {"type": "bool"},
                                        "min_delay": {"type": "bool"},
                                        "min_monetary_cost": {"type": "bool"},
                                        "normal": {"type": "bool"},
                                        "service_value": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "ttl": {
                                    "options": {
                                        "eq": {"type": "int"},
                                        "gt": {"type": "int"},
                                        "lt": {"type": "int"},
                                        "neq": {"type": "int"},
                                        "range": {
                                            "options": {
                                                "end": {"type": "int"},
                                                "start": {"type": "int"},
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "list",
                        },
                        "acl_type": {"choices": ["extended", "standard"], "type": "str"},
                        "name": {"required": True, "type": "str"},
                    },
                    "type": "list",
                },
                "afi": {"choices": ["ipv4", "ipv6"], "required": True, "type": "str"},
            },
            "type": "list",
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
