/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.objectweb.asm.commons.Method;

public final class SFunction
extends AStatement {
    private final String rtnTypeStr;
    public final String name;
    private final List<String> paramTypeStrs;
    private final List<String> paramNameStrs;
    private final SBlock block;
    public final boolean synthetic;
    private int maxLoopCounter;
    Class<?> returnType;
    List<Class<?>> typeParameters;
    MethodType methodType;
    Method method;
    List<Locals.Parameter> parameters = new ArrayList<Locals.Parameter>();
    private Locals.Variable loop = null;

    public SFunction(Location location, String rtnType, String name, List<String> paramTypes, List<String> paramNames, SBlock block, boolean synthetic) {
        super(location);
        this.rtnTypeStr = Objects.requireNonNull(rtnType);
        this.name = Objects.requireNonNull(name);
        this.paramTypeStrs = Collections.unmodifiableList(paramTypes);
        this.paramNameStrs = Collections.unmodifiableList(paramNames);
        this.block = Objects.requireNonNull(block);
        this.synthetic = synthetic;
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.block.extractVariables(new HashSet<String>());
    }

    void generateSignature(PainlessLookup painlessLookup) {
        this.returnType = painlessLookup.canonicalTypeNameToType(this.rtnTypeStr);
        if (this.returnType == null) {
            throw this.createError(new IllegalArgumentException("Illegal return type [" + this.rtnTypeStr + "] for function [" + this.name + "]."));
        }
        if (this.paramTypeStrs.size() != this.paramNameStrs.size()) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        Class[] paramClasses = new Class[this.paramTypeStrs.size()];
        ArrayList paramTypes = new ArrayList();
        for (int param = 0; param < this.paramTypeStrs.size(); ++param) {
            Class<?> paramType = painlessLookup.canonicalTypeNameToType(this.paramTypeStrs.get(param));
            if (paramType == null) {
                throw this.createError(new IllegalArgumentException("Illegal parameter type [" + this.paramTypeStrs.get(param) + "] for function [" + this.name + "]."));
            }
            paramClasses[param] = PainlessLookupUtility.typeToJavaType(paramType);
            paramTypes.add(paramType);
            this.parameters.add(new Locals.Parameter(this.location, this.paramNameStrs.get(param), paramType));
        }
        this.typeParameters = paramTypes;
        this.methodType = MethodType.methodType(PainlessLookupUtility.typeToJavaType(this.returnType), paramClasses);
        this.method = new Method(this.name, MethodType.methodType(PainlessLookupUtility.typeToJavaType(this.returnType), paramClasses).toMethodDescriptorString());
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.maxLoopCounter = scriptRoot.getCompilerSettings().getMaxLoopCounter();
        if (this.block.statements.isEmpty()) {
            throw this.createError(new IllegalArgumentException("Cannot generate an empty function [" + this.name + "]."));
        }
        locals = Locals.newLocalScope(locals);
        this.block.lastSource = true;
        this.block.analyze(scriptRoot, locals);
        this.methodEscape = this.block.methodEscape;
        if (!this.methodEscape && this.returnType != Void.TYPE) {
            throw this.createError(new IllegalArgumentException("Not all paths provide a return value for method [" + this.name + "]."));
        }
        if (this.maxLoopCounter > 0) {
            this.loop = locals.getVariable(null, "#loop");
        }
    }

    void write(ClassWriter classWriter, Globals globals) {
        int access = 9;
        if (this.synthetic) {
            access |= 0x1000;
        }
        MethodWriter methodWriter = classWriter.newMethodWriter(access, this.method);
        methodWriter.visitCode();
        this.write(classWriter, methodWriter, globals);
        methodWriter.endMethod();
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        if (this.maxLoopCounter > 0) {
            methodWriter.push(this.maxLoopCounter);
            methodWriter.visitVarInsn(54, this.loop.getSlot());
        }
        this.block.write(classWriter, methodWriter, globals);
        if (!this.methodEscape) {
            if (this.returnType == Void.TYPE) {
                methodWriter.returnValue();
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    @Override
    public String toString() {
        ArrayList<String> description = new ArrayList<String>();
        description.add(this.rtnTypeStr);
        description.add(this.name);
        if (!(this.paramTypeStrs.isEmpty() && this.paramNameStrs.isEmpty())) {
            description.add(this.joinWithName("Args", this.pairwiseToString(this.paramTypeStrs, this.paramNameStrs), Collections.emptyList()));
        }
        return this.multilineToString(description, this.block.statements);
    }
}

