/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.sf.freecol.common.util.CachingFunction;
import net.sf.freecol.common.util.Utils;

public class CollectionUtils {
    private static final int MAX_DEFAULT = Integer.MIN_VALUE;
    private static final int MIN_DEFAULT = Integer.MAX_VALUE;
    private static final int SUM_DEFAULT = 0;
    private static final double SUM_DOUBLE_DEFAULT = 0.0;
    private static final double PRODUCT_DEFAULT = 1.0;
    public static final BinaryOperator<Integer> integerAccumulator = (i1, i2) -> i1 + i2;
    public static final BinaryOperator<Double> doubleAccumulator = (d1, d2) -> d1 + d2;
    public static final Comparator<Integer> ascendingIntegerComparator = Comparator.comparingInt(Integer::intValue);
    public static final Comparator<Integer> descendingIntegerComparator = ascendingIntegerComparator.reversed();
    public static final Comparator<Double> ascendingDoubleComparator = Comparator.comparingDouble(Double::doubleValue);
    public static final Comparator<Double> descendingDoubleComparator = ascendingDoubleComparator.reversed();
    public static final Comparator<List<?>> ascendingListLengthComparator = Comparator.comparingInt(List::size);
    public static final Comparator<List<?>> descendingListLengthComparator = ascendingListLengthComparator.reversed();

    @SafeVarargs
    public static <T> Set<T> makeUnmodifiableSet(T ... members) {
        HashSet<T> tmp = new HashSet<T>(members.length);
        for (T t : members) {
            tmp.add(t);
        }
        return Collections.unmodifiableSet(tmp);
    }

    @SafeVarargs
    public static <T> List<T> makeUnmodifiableList(T ... members) {
        ArrayList<T> tmp = new ArrayList<T>(members.length);
        for (T t : members) {
            tmp.add(t);
        }
        return Collections.unmodifiableList(tmp);
    }

    public static <K, V> Map<K, V> makeUnmodifiableMap(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new RuntimeException("Length mismatch: " + keys.length + " != " + values.length);
        }
        HashMap<K, V> tmp = new HashMap<K, V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            tmp.put(keys[i], values[i]);
        }
        return Collections.unmodifiableMap(tmp);
    }

    @SafeVarargs
    public static <T> Map<T, T> asMap(T ... values) {
        HashMap<T, T> ret = new HashMap<T, T>(values.length / 2);
        for (int i = 0; i < values.length - 1; i += 2) {
            ret.put(values[i], values[i + 1]);
        }
        return ret;
    }

    public static <T, K> void appendToMapList(Map<K, List<T>> map, K key, T value) {
        List<T> l = map.get(key);
        if (l == null) {
            l = new ArrayList<T>();
            l.add(value);
            map.put(key, l);
        } else if (!l.contains(value)) {
            l.add(value);
        }
    }

    public static <K, V> void accumulateToMap(Map<K, V> map, K key, V value, BinaryOperator<V> accumulator) {
        V val = map.get(key);
        if (val == null) {
            map.put(key, value);
        } else {
            map.put(key, accumulator.apply(val, value));
        }
    }

    public static <K, V> void accumulateMap(Map<K, V> map1, Map<K, V> map2, BinaryOperator<V> accumulator) {
        CollectionUtils.forEachMapEntry(map2, e -> CollectionUtils.accumulateToMap(map1, e.getKey(), e.getValue(), accumulator));
    }

    public static <K> int incrementMapCount(Map<K, Integer> map, K key) {
        Integer val = map.get(key);
        val = val == null ? Integer.valueOf(1) : Integer.valueOf(val + 1);
        map.put(key, val);
        return val;
    }

    public static <T> Iterable<List<T>> getPermutations(final List<T> l) {
        if (l == null) {
            return null;
        }
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new Iterator<List<T>>(){
                    private final List<T> original;
                    private final int n;
                    private final int np;
                    private int index;
                    {
                        this.original = new ArrayList(l);
                        this.n = l.size();
                        this.np = this.factorial(this.n);
                        this.index = 0;
                    }

                    private int factorial(int n) {
                        int total = n;
                        while (--n > 1) {
                            total *= n;
                        }
                        return total;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.np;
                    }

                    @Override
                    public List<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("Permutations exhausted: " + this.n);
                        }
                        ArrayList pick = new ArrayList(this.original);
                        ArrayList result = new ArrayList(this.n);
                        int current = this.index++;
                        int divisor = this.np;
                        for (int i = this.n; i > 0; --i) {
                            int j = current / (divisor /= i);
                            result.add(pick.remove(j));
                            current -= j * divisor;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("remove() not implemented: " + this);
                    }
                };
            }
        };
    }

    public static <T> boolean allSame(Collection<T> c) {
        Object datum = null;
        boolean first = true;
        for (T t : c) {
            if (first) {
                datum = t;
            } else if (t != datum) {
                return false;
            }
            first = false;
        }
        return true;
    }

    public static <T> void rotate(List<T> list, int n) {
        int len = list.size();
        if (len <= 0 || n == 0) {
            return;
        }
        if ((n %= len) > 0) {
            while (n > 0) {
                T t = list.remove(0);
                list.add(t);
                --n;
            }
        } else {
            while (n < 0) {
                T t = list.remove(n - 1);
                list.add(0, t);
                ++n;
            }
        }
    }

    public static <T> void reverse(List<T> list) {
        int len = list.size();
        if (len <= 0) {
            return;
        }
        int i = 0;
        for (int j = len - 1; i < j; ++i, --j) {
            T t = list.get(i);
            list.set(i, list.get(j));
            list.set(j, t);
        }
    }

    public static <T> boolean listEquals(List<T> one, List<T> two) {
        block3: {
            if (one == null) {
                return two == null;
            }
            if (two == null) {
                return false;
            }
            Iterator<T> oneI = one.iterator();
            Iterator<T> twoI = two.iterator();
            while (oneI.hasNext()) {
                if (twoI.hasNext() && Utils.equals(oneI.next(), twoI.next())) continue;
                break block3;
            }
            return !twoI.hasNext();
        }
        return false;
    }

    public static <K extends Comparable<? super K>, V> List<Map.Entry<K, V>> mapEntriesByKey(Map<K, V> map) {
        return CollectionUtils.sort(map.entrySet(), Comparator.comparing(Map.Entry::getKey));
    }

    public static <K, V> List<Map.Entry<K, V>> mapEntriesByKey(Map<K, V> map, Comparator<K> comparator) {
        return CollectionUtils.sort(map.entrySet(), Comparator.comparing(Map.Entry::getKey, comparator));
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> mapEntriesByValue(Map<K, V> map) {
        return CollectionUtils.sort(map.entrySet(), Comparator.comparing(Map.Entry::getValue));
    }

    public static <K, V> List<Map.Entry<K, V>> mapEntriesByValue(Map<K, V> map, Comparator<V> comparator) {
        return CollectionUtils.sort(map.entrySet(), Comparator.comparing(Map.Entry::getValue, comparator));
    }

    public static <T> boolean all(T[] array, Predicate<? super T> predicate) {
        return array == null ? true : CollectionUtils.all_internal(Arrays.stream(array), predicate);
    }

    public static <T> boolean all(Collection<T> c, Predicate<? super T> predicate) {
        return c == null ? true : CollectionUtils.all_internal(c.stream(), predicate);
    }

    public static <T> boolean all(Stream<T> stream, Predicate<? super T> predicate) {
        return stream == null ? true : CollectionUtils.all_internal(stream, predicate);
    }

    private static <T> boolean all_internal(Stream<T> stream, Predicate<? super T> predicate) {
        return stream.allMatch(predicate);
    }

    public static <T> Predicate<T> alwaysTrue() {
        return t -> true;
    }

    public static <T> boolean any(T[] array) {
        return array != null && array.length > 0;
    }

    public static <T> boolean any(T[] array, Predicate<? super T> predicate) {
        return CollectionUtils.any_internal(Arrays.stream(array), predicate);
    }

    public static <T> boolean any(Collection<T> c) {
        return c != null && !c.isEmpty();
    }

    public static <T> boolean any(Collection<T> c, Predicate<? super T> predicate) {
        return c == null ? false : CollectionUtils.any_internal(c.stream(), predicate);
    }

    public static <T> boolean any(Stream<T> stream) {
        return stream != null && stream.findFirst().isPresent();
    }

    public static <T> boolean any(Stream<T> stream, Predicate<? super T> predicate) {
        return stream == null ? false : CollectionUtils.any_internal(stream, predicate);
    }

    private static <T> boolean any_internal(Stream<T> stream, Predicate<? super T> predicate) {
        return stream.anyMatch(predicate);
    }

    public static <T> ToIntFunction<T> cacheInt(Function<T, Integer> f) {
        return t -> (Integer)new CachingFunction(f).apply(t);
    }

    public static <T> Comparator<T> cachingIntComparator(Function<T, Integer> f) {
        return Comparator.comparingInt(CollectionUtils.cacheInt(f));
    }

    public static <T> ToDoubleFunction<T> cacheDouble(Function<T, Double> f) {
        return t -> (Double)new CachingFunction(f).apply(t);
    }

    public static <T> Comparator<T> cachingDoubleComparator(Function<T, Double> f) {
        return Comparator.comparingDouble(CollectionUtils.cacheDouble(f));
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<T> s0, Stream<T> ... streams) {
        Stream<T>[] sts = streams;
        Stream ret = s0 == null ? Stream.empty() : s0;
        for (int i = 0; i < sts.length; ++i) {
            if (sts[i] == null) continue;
            ret = Stream.concat(ret, sts[i]);
        }
        return ret;
    }

    public static <T> int count(T[] array) {
        return array == null ? 0 : array.length;
    }

    public static <T> int count(T[] array, Predicate<? super T> predicate) {
        return CollectionUtils.count_internal(Arrays.stream(array), predicate);
    }

    public static <T> int count(Collection<T> c) {
        return c == null ? 0 : c.size();
    }

    public static <T> int count(Collection<T> c, Predicate<? super T> predicate) {
        return CollectionUtils.count_internal(c.stream(), predicate);
    }

    public static <T> int count(Stream<T> stream) {
        return stream == null ? 0 : CollectionUtils.count_internal(stream, CollectionUtils.alwaysTrue());
    }

    public static <T> int count(Stream<T> stream, Predicate<? super T> predicate) {
        return stream == null ? 0 : CollectionUtils.count_internal(stream, predicate);
    }

    private static <T> int count_internal(Stream<T> stream, Predicate<? super T> predicate) {
        return (int)stream.filter(predicate).count();
    }

    public static <T> void dump(String header, T[] array) {
        CollectionUtils.dump_internal(header, Arrays.stream(array));
    }

    public static void dump(String header, Collection<?> c) {
        CollectionUtils.dump_internal(header, c.stream());
    }

    public static void dump(String header, Stream<?> stream) {
        CollectionUtils.dump_internal(header, stream);
    }

    private static void dump_internal(String header, Stream<?> stream) {
        if (header != null) {
            System.err.print(header);
        }
        System.err.print("[ ");
        CollectionUtils.forEach(stream, (? super T v) -> {
            System.err.print(v);
            System.err.print(' ');
        });
        System.err.println(']');
    }

    public static void dump(String header, Map<?, ?> map) {
        if (header != null) {
            System.err.print(header);
        }
        System.err.print("[ ");
        CollectionUtils.forEachMapEntry(map, e -> {
            System.err.print(e.getKey());
            System.err.print(',');
            System.err.print(e.getValue());
            System.err.print(' ');
        });
        System.err.println(']');
    }

    public static Stream<File> fileStream(File dir) {
        File[] files;
        return dir == null || !dir.isDirectory() || (files = dir.listFiles()) == null ? Stream.empty() : Arrays.stream(files);
    }

    public static Stream<File> fileStream(File dir, Predicate<? super File> predicate) {
        return CollectionUtils.fileStream(dir).filter(predicate);
    }

    public static <T> T find(T[] array, Predicate<? super T> predicate) {
        return CollectionUtils.find_internal(Arrays.stream(array), predicate, null);
    }

    public static <T> T find(T[] array, Predicate<? super T> predicate, T fail) {
        return CollectionUtils.find_internal(Arrays.stream(array), predicate, fail);
    }

    public static <T> T find(Collection<T> c, Predicate<? super T> predicate) {
        return CollectionUtils.find_internal(c.stream(), predicate, null);
    }

    public static <T> T find(Collection<T> c, Predicate<? super T> predicate, T fail) {
        return CollectionUtils.find_internal(c.stream(), predicate, fail);
    }

    public static <T> T find(Stream<T> stream, Predicate<? super T> predicate) {
        return stream == null ? null : CollectionUtils.find_internal(stream, predicate, null);
    }

    public static <T> T find(Stream<T> stream, Predicate<? super T> predicate, T fail) {
        return stream == null ? fail : CollectionUtils.find_internal(stream, predicate, fail);
    }

    private static <T> T find_internal(Stream<T> stream, Predicate<? super T> predicate, T fail) {
        return CollectionUtils.first_internal(stream.filter(predicate), fail);
    }

    public static <T> T first(T[] array) {
        return array == null || array.length == 0 ? null : CollectionUtils.first_internal(Arrays.stream(array), null);
    }

    public static <T> T first(Collection<T> c) {
        return c == null || c.isEmpty() ? null : CollectionUtils.first_internal(c.stream(), null);
    }

    public static <T> T first(Stream<T> stream) {
        return stream == null ? null : CollectionUtils.first_internal(stream, null);
    }

    private static <T> T first_internal(Stream<T> stream, T fail) {
        return stream.findFirst().orElse(fail);
    }

    public static <T, R> Stream<R> flatten(T[] array, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return CollectionUtils.flatten_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), mapper);
    }

    public static <T, R> Stream<R> flatten(T[] array, Predicate<? super T> predicate, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return CollectionUtils.flatten_internal(Arrays.stream(array), predicate, mapper);
    }

    public static <T, R> Stream<R> flatten(Collection<T> c, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return CollectionUtils.flatten_internal(c.stream(), CollectionUtils.alwaysTrue(), mapper);
    }

    public static <T, R> Stream<R> flatten(Collection<T> c, Predicate<? super T> predicate, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return CollectionUtils.flatten_internal(c.stream(), predicate, mapper);
    }

    public static <T, R> Stream<R> flatten(Stream<T> stream, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return stream == null ? Stream.empty() : CollectionUtils.flatten_internal(stream, CollectionUtils.alwaysTrue(), mapper);
    }

    public static <T, R> Stream<R> flatten(Stream<T> stream, Predicate<? super T> predicate, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return stream == null ? Stream.empty() : CollectionUtils.flatten_internal(stream, predicate, mapper);
    }

    private static <T, R> Stream<R> flatten_internal(Stream<T> stream, Predicate<? super T> predicate, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return stream.filter(predicate).flatMap(mapper);
    }

    public static <K, V> void forEachMapEntry(Map<K, V> map, Consumer<Map.Entry<K, V>> consumer) {
        if (consumer != null && map != null && !map.isEmpty()) {
            CollectionUtils.forEach_internal(map.entrySet().stream(), CollectionUtils.alwaysTrue(), consumer);
        }
    }

    public static <K, V> void forEachMapEntry(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate, Consumer<Map.Entry<K, V>> consumer) {
        if (consumer != null && map != null && !map.isEmpty()) {
            CollectionUtils.forEach_internal(map.entrySet().stream(), predicate, consumer);
        }
    }

    public static <T> void forEach(T[] array, Consumer<? super T> consumer) {
        if (array != null && consumer != null) {
            CollectionUtils.forEach_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), consumer);
        }
    }

    public static <T> void forEach(T[] array, Predicate<? super T> predicate, Consumer<? super T> consumer) {
        if (array != null && consumer != null) {
            CollectionUtils.forEach_internal(Arrays.stream(array), predicate, consumer);
        }
    }

    public static <T> void forEach(Collection<T> c, Consumer<? super T> consumer) {
        if (c != null && !c.isEmpty() && consumer != null) {
            CollectionUtils.forEach_internal(c.stream(), CollectionUtils.alwaysTrue(), consumer);
        }
    }

    public static <T> void forEach(Collection<T> c, Predicate<? super T> predicate, Consumer<? super T> consumer) {
        if (c != null && !c.isEmpty() && consumer != null) {
            CollectionUtils.forEach_internal(c.stream(), predicate, consumer);
        }
    }

    public static <T> void forEach(Stream<T> stream, Consumer<? super T> consumer) {
        if (stream != null && consumer != null) {
            CollectionUtils.forEach_internal(stream, CollectionUtils.alwaysTrue(), consumer);
        }
    }

    public static <T> void forEach(Stream<T> stream, Predicate<? super T> predicate, Consumer<? super T> consumer) {
        if (stream != null && consumer != null) {
            CollectionUtils.forEach_internal(stream, predicate, consumer);
        }
    }

    private static <T> void forEach_internal(Stream<T> stream, Predicate<? super T> predicate, Consumer<? super T> consumer) {
        stream.filter(predicate).forEach(consumer);
    }

    public static <T> Predicate<T> isNotNull() {
        return t -> t != null;
    }

    public static <T, V> Predicate<T> isNotNull(Function<? super T, V> mapper) {
        return t -> mapper.apply(t) != null;
    }

    public static <T> Predicate<T> isNull() {
        return t -> t == null;
    }

    public static <T, V> Predicate<T> isNull(Function<? super T, V> mapper) {
        return t -> mapper.apply(t) == null;
    }

    public static <T> Iterable<T> iterable(final Stream<T> stream) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return stream.iterator();
            }
        };
    }

    public static <T, R> Stream<R> map(T[] array, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.map_internal(Arrays.stream(array), mapper);
    }

    public static <T, R> Stream<R> map(Collection<T> c, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.map_internal(c.stream(), mapper);
    }

    public static <T, R> Stream<R> map(Stream<T> stream, Function<? super T, ? extends R> mapper) {
        return stream == null ? Stream.empty() : CollectionUtils.map_internal(stream, mapper);
    }

    private static <T, R> Stream<R> map_internal(Stream<T> stream, Function<? super T, ? extends R> mapper) {
        return stream.map(mapper);
    }

    public static <T> Predicate<T> matchKey(T key) {
        return t -> t == key;
    }

    public static <T> Predicate<T> matchKeyEquals(T key) {
        return t -> Utils.equals(t, key);
    }

    public static <T, K> Predicate<T> matchKey(K key, Function<T, K> mapper) {
        return t -> mapper.apply(t) == key;
    }

    public static <T, K> Predicate<T> matchKeyEquals(K key, Function<T, K> mapper) {
        return t -> Utils.equals(mapper.apply(t), key);
    }

    public static <T> int max(T[] array, ToIntFunction<T> tif) {
        return CollectionUtils.max_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int max(T[] array, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return CollectionUtils.max_internal(Arrays.stream(array), predicate, tif);
    }

    public static <T> int max(Collection<T> c, ToIntFunction<T> tif) {
        return CollectionUtils.max_internal(c.stream(), CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int max(Collection<T> c, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return CollectionUtils.max(c.stream(), predicate, tif);
    }

    public static <T> int max(Stream<T> stream, ToIntFunction<T> tif) {
        return stream == null ? Integer.MIN_VALUE : CollectionUtils.max_internal(stream, CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int max(Stream<T> stream, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return stream == null ? Integer.MIN_VALUE : CollectionUtils.max_internal(stream, predicate, tif);
    }

    private static <T> int max_internal(Stream<T> stream, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return stream.filter(predicate).mapToInt(tif).max().orElse(Integer.MIN_VALUE);
    }

    public static <T> T maximize(T[] array, Comparator<? super T> comparator) {
        return CollectionUtils.maximize_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), comparator);
    }

    public static <T> T maximize(T[] array, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return CollectionUtils.maximize_internal(Arrays.stream(array), predicate, comparator);
    }

    public static <T> T maximize(Collection<T> c, Comparator<? super T> comparator) {
        return CollectionUtils.maximize_internal(c.stream(), CollectionUtils.alwaysTrue(), comparator);
    }

    public static <T> T maximize(Collection<T> c, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return CollectionUtils.maximize_internal(c.stream(), predicate, comparator);
    }

    public static <T> T maximize(Stream<T> stream, Comparator<? super T> comparator) {
        return stream == null ? null : (T)CollectionUtils.maximize_internal(stream, CollectionUtils.alwaysTrue(), comparator);
    }

    public static <T> T maximize(Stream<T> stream, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return stream == null ? null : (T)CollectionUtils.maximize_internal(stream, predicate, comparator);
    }

    private static <T> T maximize_internal(Stream<T> stream, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return stream.filter(predicate).collect(Collectors.maxBy(comparator)).orElse(null);
    }

    public static <T> int min(T[] array, ToIntFunction<T> tif) {
        return CollectionUtils.min_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int min(T[] array, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return CollectionUtils.min_internal(Arrays.stream(array), predicate, tif);
    }

    public static <T> int min(Collection<T> c, ToIntFunction<T> tif) {
        return CollectionUtils.min_internal(c.stream(), CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int min(Collection<T> c, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return CollectionUtils.min_internal(c.stream(), predicate, tif);
    }

    public static <T> int min(Stream<T> stream, ToIntFunction<T> tif) {
        return stream == null ? Integer.MAX_VALUE : CollectionUtils.min_internal(stream, CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int min(Stream<T> stream, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return stream == null ? Integer.MAX_VALUE : CollectionUtils.min_internal(stream, predicate, tif);
    }

    private static <T> int min_internal(Stream<T> stream, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return stream.filter(predicate).mapToInt(tif).min().orElse(Integer.MAX_VALUE);
    }

    public static <T> T minimize(T[] array, Comparator<? super T> comparator) {
        return CollectionUtils.minimize_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), comparator);
    }

    public static <T> T minimize(T[] array, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return CollectionUtils.minimize_internal(Arrays.stream(array), predicate, comparator);
    }

    public static <T> T minimize(Collection<T> c, Comparator<? super T> comparator) {
        return CollectionUtils.minimize_internal(c.stream(), CollectionUtils.alwaysTrue(), comparator);
    }

    public static <T> T minimize(Collection<T> c, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return CollectionUtils.minimize_internal(c.stream(), predicate, comparator);
    }

    public static <T> T minimize(Stream<T> stream, Comparator<? super T> comparator) {
        return stream == null ? null : (T)CollectionUtils.minimize_internal(stream, CollectionUtils.alwaysTrue(), comparator);
    }

    public static <T> T minimize(Stream<T> stream, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return stream == null ? null : (T)CollectionUtils.minimize_internal(stream, predicate, comparator);
    }

    private static <T> T minimize_internal(Stream<T> stream, Predicate<? super T> predicate, Comparator<? super T> comparator) {
        return stream.filter(predicate).collect(Collectors.minBy(comparator)).orElse(null);
    }

    public static <T> boolean none(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean none(T[] array, Predicate<? super T> predicate) {
        return CollectionUtils.none_internal(Arrays.stream(array), predicate);
    }

    public static <T> boolean none(Collection<T> c) {
        return c == null || c.isEmpty();
    }

    public static <T> boolean none(Collection<T> c, Predicate<? super T> predicate) {
        return CollectionUtils.none_internal(c.stream(), predicate);
    }

    public static <T> boolean none(Stream<T> stream) {
        return stream == null || !stream.findFirst().isPresent();
    }

    public static <T> boolean none(Stream<T> stream, Predicate<? super T> predicate) {
        return stream == null ? true : CollectionUtils.none_internal(stream, predicate);
    }

    private static <T> boolean none_internal(Stream<T> stream, Predicate<? super T> predicate) {
        return stream.noneMatch(predicate);
    }

    public static <T> double product(T[] array, ToDoubleFunction<T> tdf) {
        return CollectionUtils.product_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), tdf);
    }

    public static <T> double product(T[] array, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        return CollectionUtils.product_internal(Arrays.stream(array), predicate, tdf);
    }

    public static <T> double product(Collection<T> c, ToDoubleFunction<T> tdf) {
        return CollectionUtils.product_internal(c.stream(), CollectionUtils.alwaysTrue(), tdf);
    }

    public static <T> double product(Collection<T> c, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        return CollectionUtils.product_internal(c.stream(), predicate, tdf);
    }

    public static <T> double product(Stream<T> stream, ToDoubleFunction<T> tdf) {
        return stream == null ? 1.0 : CollectionUtils.product_internal(stream, CollectionUtils.alwaysTrue(), tdf);
    }

    public static <T> double product(Stream<T> stream, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        return stream == null ? 1.0 : CollectionUtils.product_internal(stream, predicate, tdf);
    }

    private static <T> double product_internal(Stream<T> stream, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        DoubleBinaryOperator mult = (d1, d2) -> d1 * d2;
        return stream.filter(predicate).mapToDouble(tdf).reduce(1.0, mult);
    }

    public static <T> boolean removeInPlace(Collection<T> c, Predicate<? super T> predicate) {
        boolean ret = false;
        Iterator<T> iterator = c.iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
            ret = true;
        }
        return ret;
    }

    public static <K, V> boolean removeInPlace(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        boolean ret = false;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
            ret = true;
        }
        return ret;
    }

    public static <T extends Comparable<? super T>> List<T> sort(T[] array) {
        Comparator comparator = Comparator.naturalOrder();
        return CollectionUtils.sort_internal(Arrays.stream(array), comparator);
    }

    public static <T> List<T> sort(T[] array, Comparator<? super T> comparator) {
        return CollectionUtils.sort_internal(Arrays.stream(array), comparator);
    }

    public static <T extends Comparable<? super T>> List<T> sort(Collection<T> c) {
        Comparator comparator = Comparator.naturalOrder();
        return CollectionUtils.sort_internal(c.stream(), comparator);
    }

    public static <T> List<T> sort(Collection<T> c, Comparator<? super T> comparator) {
        return CollectionUtils.sort_internal(c.stream(), comparator);
    }

    public static <T extends Comparable<? super T>> List<T> sort(Stream<T> stream) {
        Comparator comparator = Comparator.naturalOrder();
        return stream == null ? Collections.emptyList() : CollectionUtils.sort_internal(stream, comparator);
    }

    public static <T> List<T> sort(Stream<T> stream, Comparator<? super T> comparator) {
        return stream == null ? Collections.emptyList() : CollectionUtils.sort_internal(stream, comparator);
    }

    private static <T> List<T> sort_internal(Stream<T> stream, Comparator<? super T> comparator) {
        return stream.sorted(comparator).collect(Collectors.toList());
    }

    public static <T> int sum(T[] array, ToIntFunction<T> tif) {
        return CollectionUtils.sum_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int sum(T[] array, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return CollectionUtils.sum_internal(Arrays.stream(array), predicate, tif);
    }

    public static <T> int sum(Collection<T> c, ToIntFunction<T> tif) {
        return CollectionUtils.sum_internal(c.stream(), CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int sum(Collection<T> c, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return CollectionUtils.sum_internal(c.stream(), predicate, tif);
    }

    public static <T> int sum(Stream<T> stream, ToIntFunction<T> tif) {
        return stream == null ? 0 : CollectionUtils.sum_internal(stream, CollectionUtils.alwaysTrue(), tif);
    }

    public static <T> int sum(Stream<T> stream, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return stream == null ? 0 : CollectionUtils.sum_internal(stream, predicate, tif);
    }

    private static <T> int sum_internal(Stream<T> stream, Predicate<? super T> predicate, ToIntFunction<T> tif) {
        return stream.filter(predicate).mapToInt(tif).sum();
    }

    public static <T> double sumDouble(T[] array, ToDoubleFunction<T> tdf) {
        return CollectionUtils.sumDouble_internal(Arrays.stream(array), CollectionUtils.alwaysTrue(), tdf);
    }

    public static <T> double sumDouble(T[] array, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        return CollectionUtils.sumDouble_internal(Arrays.stream(array), predicate, tdf);
    }

    public static <T> double sumDouble(Collection<T> c, ToDoubleFunction<T> tdf) {
        return CollectionUtils.sumDouble_internal(c.stream(), CollectionUtils.alwaysTrue(), tdf);
    }

    public static <T> double sumDouble(Collection<T> c, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        return CollectionUtils.sumDouble_internal(c.stream(), predicate, tdf);
    }

    public static <T> double sumDouble(Stream<T> stream, ToDoubleFunction<T> tdf) {
        return stream == null ? 0.0 : CollectionUtils.sumDouble_internal(stream, CollectionUtils.alwaysTrue(), tdf);
    }

    public static <T> double sumDouble(Stream<T> stream, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        return stream == null ? 0.0 : CollectionUtils.sumDouble_internal(stream, predicate, tdf);
    }

    private static <T> double sumDouble_internal(Stream<T> stream, Predicate<? super T> predicate, ToDoubleFunction<T> tdf) {
        return stream.filter(predicate).mapToDouble(tdf).sum();
    }

    public static <T> Collector<List<T>, ?, List<T>> toAppendedList() {
        BinaryOperator squash = (l1, l2) -> l1.isEmpty() ? l2 : (l1.addAll(l2) ? l1 : l1);
        return Collectors.reducing(Collections.emptyList(), squash);
    }

    public static <T> List<T> toList(T[] array) {
        return CollectionUtils.toList_internal(Arrays.stream(array));
    }

    public static <T> List<T> toList(Collection<T> c) {
        return CollectionUtils.toList_internal(c.stream());
    }

    public static <T> List<T> toList(Stream<T> stream) {
        return stream == null ? Collections.emptyList() : CollectionUtils.toList_internal(stream);
    }

    private static <T> List<T> toList_internal(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static <T> Collector<T, ?, List<T>> toListNoNulls() {
        return Collector.of(ArrayList::new, (left, right) -> {
            if (right != null) {
                left.add(right);
            }
        }, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return CollectionUtils.toStream(() -> iterator);
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> List<T> transform(T[] array, Predicate<? super T> predicate) {
        return CollectionUtils.transform_internal(Arrays.stream(array), predicate, Function.identity(), null, Collectors.toList());
    }

    public static <T, R> List<R> transform(T[] array, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.transform_internal(Arrays.stream(array), predicate, mapper, null, Collectors.toList());
    }

    public static <T, R, C> C transform(T[] array, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, Collector<R, ?, C> collector) {
        return CollectionUtils.transform_internal(Arrays.stream(array), predicate, mapper, null, collector);
    }

    public static <T, R> List<R> transform(T[] array, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, Comparator<? super R> comparator) {
        return CollectionUtils.transform_internal(Arrays.stream(array), predicate, mapper, comparator, Collectors.toList());
    }

    public static <T> List<T> transform(Collection<T> c, Predicate<? super T> predicate) {
        return CollectionUtils.transform_internal(c.stream(), predicate, Function.identity(), null, Collectors.toList());
    }

    public static <T, R> List<R> transform(Collection<T> c, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper) {
        return CollectionUtils.transform_internal(c.stream(), predicate, mapper, null, Collectors.toList());
    }

    public static <T, R> List<R> transform(Collection<T> c, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, Comparator<? super R> comparator) {
        return CollectionUtils.transform_internal(c.stream(), predicate, mapper, comparator, Collectors.toList());
    }

    public static <T, R, C> C transform(Collection<T> c, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, Collector<R, ?, C> collector) {
        return CollectionUtils.transform_internal(c.stream(), predicate, mapper, null, collector);
    }

    public static <T> List<T> transform(Stream<T> stream, Predicate<? super T> predicate) {
        Stream s = stream == null ? Stream.empty() : stream;
        return CollectionUtils.transform_internal(s, predicate, Function.identity(), null, Collectors.toList());
    }

    public static <T, R> List<R> transform(Stream<T> stream, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper) {
        Stream s = stream == null ? Stream.empty() : stream;
        return CollectionUtils.transform_internal(s, predicate, mapper, null, Collectors.toList());
    }

    public static <T, R> List<R> transform(Stream<T> stream, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, Comparator<? super R> comparator) {
        Stream s = stream == null ? Stream.empty() : stream;
        return CollectionUtils.transform_internal(s, predicate, mapper, comparator, Collectors.toList());
    }

    public static <T, R, C> C transform(Stream<T> stream, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, Collector<R, ?, C> collector) {
        Stream s = stream == null ? Stream.empty() : stream;
        return CollectionUtils.transform_internal(s, predicate, mapper, null, collector);
    }

    private static <T, R, C> C transform_internal(Stream<T> stream, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, Comparator<? super R> comparator, Collector<R, ?, C> collector) {
        return comparator == null ? stream.filter(predicate).map(mapper).collect(collector) : stream.filter(predicate).map(mapper).sorted(comparator).collect(collector);
    }
}

