/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.AltitudeRange;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.RangeStats;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;

public class RangeStatsWithGradients
extends RangeStats {
    private final AltitudeRange _gentleAltitudeRange;
    private final AltitudeRange _steepAltitudeRange;
    private Altitude _prevAltitude = null;
    private double _radsSinceLastAltitude = 0.0;
    private static final double STEEP_ANGLE = 0.15;

    public RangeStatsWithGradients(int n) {
        super(n);
        this._gentleAltitudeRange = new AltitudeRange(n);
        this._steepAltitudeRange = new AltitudeRange(n);
    }

    public RangeStatsWithGradients(Track track, int n, int n2, int n3) {
        this(n3);
        this.populateFromTrack(track, n, n2);
    }

    @Override
    protected void doFurtherCalculations(DataPoint dataPoint) {
        if (this._prevPoint != null) {
            double d = DataPoint.calculateRadiansBetween(this._prevPoint, dataPoint);
            this._radsSinceLastAltitude += d;
        }
        if (dataPoint.hasAltitude()) {
            Altitude altitude = dataPoint.getAltitude();
            if (!dataPoint.getSegmentStart() && this._prevAltitude != null) {
                boolean bl;
                double d = altitude.getMetricValue() - this._prevAltitude.getMetricValue();
                double d2 = Distance.convertRadiansToDistance(this._radsSinceLastAltitude, UnitSetLibrary.UNITS_METRES);
                boolean bl2 = bl = d2 < 0.001 || Math.abs(d / d2) > 0.15;
                if (bl) {
                    this._steepAltitudeRange.ignoreValue(this._prevAltitude);
                    this._steepAltitudeRange.addValue(altitude);
                } else {
                    this._gentleAltitudeRange.ignoreValue(this._prevAltitude);
                    this._gentleAltitudeRange.addValue(altitude);
                }
            }
            this._prevAltitude = altitude;
            this._radsSinceLastAltitude = 0.0;
        }
    }

    public AltitudeRange getGentleAltitudeRange() {
        return this._gentleAltitudeRange;
    }

    public AltitudeRange getSteepAltitudeRange() {
        return this._steepAltitudeRange;
    }

    public double getTotalGradient() {
        double d = Distance.convertRadiansToDistance(this._totalDistanceRads, UnitSetLibrary.UNITS_METRES);
        if (d > 0.0 && this._totalAltitudeRange.hasRange()) {
            return this._totalAltitudeRange.getMetricHeightDiff() / d * 100.0;
        }
        return 0.0;
    }

    public double getMovingGradient() {
        double d = Distance.convertRadiansToDistance(this._movingDistanceRads, UnitSetLibrary.UNITS_METRES);
        if (d > 0.0 && this._movingAltitudeRange.hasRange()) {
            return this._movingAltitudeRange.getMetricHeightDiff() / d * 100.0;
        }
        return 0.0;
    }
}

