#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 binary-tagged
version:              0.3
visibility:           public
id:                   binary-tagged-0.3-Jt0SXMTCpMfB4PPiUbzRAo
key:                  binary-tagged-0.3-Jt0SXMTCpMfB4PPiUbzRAo
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
synopsis:             Tagged binary serialisation.
description:
    Structurally tag binary serialisation stream.

    Say you have:

    Say you have a data type

    @
    data Record = Record
    \  { _recordFields  :: HM.HashMap Text (Integer, ByteString)
    \  , _recordEnabled :: Bool
    \  }
    \  deriving (Eq, Show, Generic)

    instance @Binary@ Record
    instance '\''Structured'\'' Record
    @

    then you can serialise and deserialise @Record@ values with a structure tag by simply

    @
    '\''structuredEncode'\'' record :: LBS.ByteString
    '\''structuredDecode'\'' lbs    :: IO Record
    @

    If structure of @Record@ changes in between, deserialisation will fail early.

    The overhead is next to non-observable.

    @
    benchmarking encode/Binary
    time                 352.8 μs   (349.5 μs .. 355.9 μs)

    benchmarking encode/Tagged
    time                 350.8 μs   (349.0 μs .. 353.1 μs)

    benchmarking decode/Binary
    time                 346.8 μs   (344.7 μs .. 349.9 μs)

    benchmarking decode/Tagged
    time                 353.8 μs   (352.0 μs .. 355.8 μs)
    @

category:             Data
abi:                  afbdd273ff87346277b1805d8fd18dfc
exposed:              True
exposed-modules:      Data.Binary.Tagged
import-dirs:          /usr/lib/ghc-8.10.5/site-local/binary-tagged-0.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/binary-tagged-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/binary-tagged-0.3
hs-libraries:         HSbinary-tagged-0.3-Jt0SXMTCpMfB4PPiUbzRAo
depends:
    array-0.5.4.0 base-4.14.2.0
    base16-bytestring-1.0.1.0-L8MYVxGxjrHE5OI1p1aFGq binary-0.8.8.0
    bytestring-0.10.12.0 containers-0.6.4.1
    structured-0.1.0.1-1KPEVTyoQ0X88D2JZNH6hu
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV

haddock-interfaces:
    /usr/share/doc/haskell-binary-tagged/html/binary-tagged.haddock

haddock-html:         /usr/share/doc/haskell-binary-tagged/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

