#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cassava
version:              0.5.2.0
visibility:           public
id:                   cassava-0.5.2.0-DEdUjMttIof4W7I5xu88R4
key:                  cassava-0.5.2.0-DEdUjMttIof4W7I5xu88R4
license:              BSD-3-Clause
copyright:
    (c) 2012 Johan Tibell
    (c) 2012 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           hvr@gnu.org
author:               Johan Tibell
homepage:             https://github.com/hvr/cassava
synopsis:             A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.

    @cassava@'\''s API includes support for

    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")

    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:

    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"

    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.

category:             Text, Web, CSV
abi:                  79e9e8d9af19e49bae6f51d2b4f1b16d
exposed:              True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming

hidden-modules:
    Data.Csv.Conversion Data.Csv.Conversion.Internal Data.Csv.Encoding
    Data.Csv.Types Data.Csv.Util

import-dirs:          /usr/lib/ghc-8.10.5/site-local/cassava-0.5.2.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/cassava-0.5.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/cassava-0.5.2.0
hs-libraries:         HScassava-0.5.2.0-DEdUjMttIof4W7I5xu88R4
depends:
    Only-0.1-FUCJUAPDXF54dPZ4SnGX6G array-0.5.4.0
    attoparsec-0.14.1-IwUGXYiDhQIB5nUHrI5Wg8 base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1 deepseq-1.4.4.0
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    scientific-0.3.7.0-Ea1GK6jx8XDEEsfAKxwFym text-1.2.4.1
    text-short-0.1.3-FAse0tIN3l6IW6VG60hCOn transformers-0.5.6.2
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html:         /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

