#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.2.0.0
visibility:           public
id:                   lsp-1.2.0.0-JvdnOl8fBaOCNo7yvMmzMz
key:                  lsp-1.2.0.0-JvdnOl8fBaOCNo7yvMmzMz
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell IDE
    Engine, at https://github.com/haskell/haskell-ide-engine

category:             Development
abi:                  a041fdede6ef6edcc169fc040fe79407
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-8.10.5/site-local/lsp-1.2.0.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/lsp-1.2.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/lsp-1.2.0.0
hs-libraries:         HSlsp-1.2.0.0-JvdnOl8fBaOCNo7yvMmzMz
depends:
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs
    async-2.2.3-6QbaQgrhqs02Gm74dJYuzp
    attoparsec-0.14.1-IwUGXYiDhQIB5nUHrI5Wg8 base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1
    data-default-0.7.1.1-FiQ1o71Il6AF4wrr19xinj
    dependent-map-0.4.0.0-5OPXLfk46QQAGRjDLPVaam directory-1.3.6.0
    filepath-1.4.2.1 hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    hslogger-1.3.1.0-Lh3ETJdSJLMBHJimIxSUpu
    lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
    lsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1 mtl-2.2.2
    network-uri-2.6.4.1-FvgDgWAahTMJnOZjiFXR50
    random-1.2.0-BSVdQCE475yEKcUUPfL4ub
    scientific-0.3.7.0-Ea1GK6jx8XDEEsfAKxwFym
    sorted-list-0.2.1.0-9nmT4tHEEdz1Ro1gJtKttX stm-2.5.0.1 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    unliftio-core-0.2.0.1-1ibY1oF6Hkc5ZYjZ4yW3Lp
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    uuid-1.3.15-1ImEMMQejSB2yr2jhy0kUX

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

