#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mwc-random
version:              0.15.0.1
visibility:           public
id:                   mwc-random-0.15.0.1-Lu34VS2dGNU7K4wW2NiHiE
key:                  mwc-random-0.15.0.1-Lu34VS2dGNU7K4wW2NiHiE
license:              BSD-3-Clause
copyright:            2009, 2010, 2011 Bryan O'\''Sullivan
maintainer:           Bryan O'\''Sullivan <bos@serpentine.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/bos/mwc-random
synopsis:             Fast, high quality pseudo random number generation
description:
    This package contains code for generating high quality random
    numbers that follow either a uniform or normal distribution.  The
    generated numbers are suitable for use in statistical applications.

    The uniform PRNG uses Marsaglia'\''s MWC256 (also known as MWC8222)
    multiply-with-carry generator, which has a period of 2^8222 and
    fares well in tests of randomness.  It is also extremely fast,
    between 2 and 3 times faster than the Mersenne Twister.

    Compared to the mersenne-random package, this package has a more
    convenient API, is faster, and supports more statistical
    distributions.

category:             Math, Statistics
abi:                  efb4d65cc3268029bda7bd00cffc27b5
exposed:              True
exposed-modules:
    System.Random.MWC System.Random.MWC.CondensedTable
    System.Random.MWC.Distributions System.Random.MWC.SeedSource

import-dirs:          /usr/lib/ghc-8.10.5/site-local/mwc-random-0.15.0.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/mwc-random-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/mwc-random-0.15.0.1
hs-libraries:         HSmwc-random-0.15.0.1-Lu34VS2dGNU7K4wW2NiHiE
depends:
    base-4.14.2.0 math-functions-0.3.4.2-IJhAMriziU16J2oMLHgysC
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    random-1.2.0-BSVdQCE475yEKcUUPfL4ub time-1.9.3
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-mwc-random/html/mwc-random.haddock
haddock-html:         /usr/share/doc/haskell-mwc-random/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

