#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 SafeSemaphore
version:              0.10.1
visibility:           public
id:                   SafeSemaphore-0.10.1-BqccMWHdYEyKBEO9GeHCdv
key:                  SafeSemaphore-0.10.1-BqccMWHdYEyKBEO9GeHCdv
license:              BSD-3-Clause
maintainer:           Chris Kuklewicz <haskell@list.mightyreason.com>
author:               Chris Kuklewicz <haskell@list.mightyreason.com>
homepage:             https://github.com/ChrisKuklewicz/SafeSemaphore
synopsis:             Much safer replacement for QSemN, QSem, and SampleVar
description:
    This provides a much safer semaphore than the QSem, QSemN, SampleVar in base.
    Those base modules are not exception safe and can be broken by killThread.
    See <https://github.com/ChrisKuklewicz/SafeSemaphore> for more details.

category:             Concurrency
abi:                  1c6f93c48af6f6d5d59d16496b152c0f
exposed:              True
exposed-modules:
    Control.Concurrent.FairRWLock Control.Concurrent.MSampleVar
    Control.Concurrent.MSem Control.Concurrent.MSemN
    Control.Concurrent.MSemN2 Control.Concurrent.SSem
    Control.Concurrent.STM.SSem

hidden-modules:       Control.Concurrent.STM.SSemInternals
import-dirs:          /usr/lib/ghc-8.10.5/site-local/SafeSemaphore-0.10.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/SafeSemaphore-0.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/SafeSemaphore-0.10.1
hs-libraries:         HSSafeSemaphore-0.10.1-BqccMWHdYEyKBEO9GeHCdv
depends:              base-4.14.2.0 containers-0.6.4.1 stm-2.5.0.1
haddock-interfaces:
    /usr/share/doc/haskell-safesemaphore/html/SafeSemaphore.haddock

haddock-html:         /usr/share/doc/haskell-safesemaphore/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

