#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 timezone-olson
version:              0.2.0
visibility:           public
id:                   timezone-olson-0.2.0-GzaPING4jDX6dNV7trRKlc
key:                  timezone-olson-0.2.0-GzaPING4jDX6dNV7trRKlc
license:              BSD-3-Clause
copyright:            Copyright (c) 2010-2018 Yitzchak Gale. All rights reserved.
maintainer:           yitz@sefer.org
author:               Yitzchak Gale
homepage:             http://projects.haskell.org/time-ng/
synopsis:
    A pure Haskell parser and renderer for binary Olson timezone files

description:
    A parser and renderer for binary Olson timezone
    files whose format is specified by the tzfile(5)
    man page on Unix-like systems. For more
    information about this format, see
    <http://www.iana.org/time-zones/repository/tz-link.html>.
    Functions are provided for converting the parsed data into
    '\''TimeZoneSeries'\'' objects from the timezone-series
    package. On many platforms, binary Olson timezone
    files suitable for use with this package are
    available in the directory /usr/share/zoneinfo
    and its subdirectories on your computer.
    For a way to read binary Olson timezone files at compile
    time, see the timezone-olson-th package
    (<http://hackage.haskell.org/package/timezone-olson-th>).

category:             Data
abi:                  50fb2f8a46ce3a4c48d332f79e52e7d8
exposed:              True
exposed-modules:
    Data.Time.LocalTime.TimeZone.Olson
    Data.Time.LocalTime.TimeZone.Olson.Parse
    Data.Time.LocalTime.TimeZone.Olson.Render
    Data.Time.LocalTime.TimeZone.Olson.Types

import-dirs:          /usr/lib/ghc-8.10.5/site-local/timezone-olson-0.2.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/timezone-olson-0.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/timezone-olson-0.2.0
hs-libraries:         HStimezone-olson-0.2.0-GzaPING4jDX6dNV7trRKlc
depends:
    base-4.14.2.0 binary-0.8.8.0 bytestring-0.10.12.0
    extensible-exceptions-0.1.1.4-9nRdO96RVgFCedKm18TbaI time-1.9.3
    timezone-series-0.1.9-B4SpoD8WeBZF5k3MGSL530

haddock-interfaces:
    /usr/share/doc/haskell-timezone-olson/html/timezone-olson.haddock

haddock-html:         /usr/share/doc/haskell-timezone-olson/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

