/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.SegmentMemory;

public class SegmentPropagator {
    public static void propagate(SegmentMemory sourceSegment, TupleSets<LeftTuple> leftTuples, InternalWorkingMemory wm) {
        if (leftTuples.isEmpty()) {
            return;
        }
        LeftTupleSource source = (LeftTupleSource)sourceSegment.getTipNode();
        if (sourceSegment.isEmpty()) {
            SegmentUtilities.createChildSegments(wm, sourceSegment, source.getSinkPropagator());
        }
        SegmentPropagator.processPeers(sourceSegment, leftTuples, wm);
    }

    private static void processPeers(SegmentMemory sourceSegment, TupleSets<LeftTuple> leftTuples, InternalWorkingMemory wm) {
        LeftTuple peer;
        SegmentMemory smem;
        LeftTuple leftTuple;
        SegmentMemory firstSmem = (SegmentMemory)sourceSegment.getFirst();
        SegmentPropagator.processPeerDeletes(leftTuples, leftTuples.getDeleteFirst(), firstSmem, wm);
        SegmentPropagator.processPeerDeletes(leftTuples, leftTuples.getNormalizedDeleteFirst(), firstSmem, wm);
        for (leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            smem = firstSmem.getNext();
            if (smem == null) continue;
            for (peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                if (peer.getStagedType() == 0) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    smem.getStagedLeftTuples().addUpdate(peer);
                }
                smem = smem.getNext();
            }
        }
        for (leftTuple = leftTuples.getInsertFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            smem = firstSmem.getNext();
            if (smem == null) continue;
            peer = leftTuple;
            while (smem != null) {
                if (peer.getPeer() != null) {
                    peer = peer.getPeer();
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    PhreakJoinNode.updateChildLeftTuple(peer, smem.getStagedLeftTuples(), smem.getStagedLeftTuples());
                } else {
                    peer = ((LeftTupleSink)smem.getRootNode()).createPeer(peer);
                    smem.getStagedLeftTuples().addInsert(peer);
                    if (smem.hasDataDrivenPathMemories()) {
                        for (PathMemory dataDrivenPmem : smem.getDataDrivenPathMemories()) {
                            if (!dataDrivenPmem.isRuleLinked()) continue;
                            AddRemoveRule.forceFlushLeftTuple(dataDrivenPmem, smem, wm, smem.getStagedLeftTuples());
                            break;
                        }
                    }
                }
                smem = smem.getNext();
            }
        }
        firstSmem.getStagedLeftTuples().addAll(leftTuples);
        leftTuples.resetAll();
    }

    private static void processPeerDeletes(TupleSets<LeftTuple> leftTuples, LeftTuple leftTuple, SegmentMemory firstSmem, InternalWorkingMemory wm) {
        while (leftTuple != null) {
            SegmentMemory smem = firstSmem.getNext();
            if (smem != null) {
                for (LeftTuple peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    peer.setPropagationContext(leftTuple.getPropagationContext());
                    TupleSets<LeftTuple> stagedLeftTuples = smem.getStagedLeftTuples();
                    stagedLeftTuples.addDelete(peer);
                    if (smem.hasDataDrivenPathMemories()) {
                        AddRemoveRule.forceFlushLeftTuple(smem.getFirstDataDrivenPathMemory(), smem, wm, smem.getStagedLeftTuples());
                    }
                    smem = smem.getNext();
                }
            }
            leftTuple = (LeftTuple)leftTuple.getStagedNext();
        }
    }
}

