/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.servlet.ServletContext;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

@Listener(sync=false)
public class FineSessionAttributesFactory<V>
implements SessionAttributesFactory<Map<String, UUID>> {
    private final Cache<SessionAttributeNamesKey, Map<String, UUID>> namesCache;
    private final Cache<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final MutatorFactory<SessionAttributeKey, V> mutatorFactory;

    public FineSessionAttributesFactory(InfinispanSessionAttributesFactoryConfiguration<Object, V> configuration) {
        this.namesCache = configuration.getCache();
        this.attributeCache = configuration.getCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = configuration.getCacheProperties();
        this.mutatorFactory = new InfinispanMutatorFactory(this.attributeCache, this.properties);
    }

    public Map<String, UUID> createValue(String id, Void context) {
        return Collections.emptyMap();
    }

    public Map<String, UUID> findValue(String id) {
        return this.getValue(id, true);
    }

    public Map<String, UUID> tryValue(String id) {
        return this.getValue(id, false);
    }

    private Map<String, UUID> getValue(String id, boolean purgeIfInvalid) {
        Map names = (Map)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            for (Map.Entry nameEntry : names.entrySet()) {
                Object value = this.attributeCache.get((Object)new SessionAttributeKey(id, (UUID)nameEntry.getValue()));
                if (value != null) {
                    try {
                        this.marshaller.read(value);
                        continue;
                    }
                    catch (InvalidSerializedFormException e) {
                        InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, (String)nameEntry.getKey());
                    }
                } else {
                    InfinispanWebLogger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id, (String)nameEntry.getKey());
                }
                if (purgeIfInvalid) {
                    this.purge(id);
                }
                return null;
            }
            return names;
        }
        return Collections.emptyMap();
    }

    public boolean remove(String id) {
        return this.delete(id, new Flag[0]);
    }

    public boolean purge(String id) {
        return this.delete(id, Flag.SKIP_LISTENER_NOTIFICATION);
    }

    private boolean delete(String id, Flag ... flags) {
        Map names = (Map)this.namesCache.getAdvancedCache().withFlags(EnumSet.of(Flag.FORCE_SYNCHRONOUS, flags)).remove((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            for (UUID attributeId : names.values()) {
                this.attributeCache.getAdvancedCache().withFlags(EnumSet.of(Flag.IGNORE_RETURN_VALUES, flags)).remove((Object)new SessionAttributeKey(id, attributeId));
            }
        }
        return true;
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, UUID> names, ImmutableSessionMetaData metaData, ServletContext context) {
        ImmutableSessionAttributes attributes = this.createImmutableSessionAttributes(id, names);
        ImmutableSessionAttributeActivationNotifier notifier = new ImmutableSessionAttributeActivationNotifier((ImmutableSession)new CompositeImmutableSession(id, metaData, attributes), context);
        return new FineSessionAttributes((Object)new SessionAttributeNamesKey(id), names, this.namesCache, FineSessionAttributesFactory.getKeyFactory(id), (Map)this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}), this.marshaller, this.mutatorFactory, this.immutability, this.properties, (SessionAttributeActivationNotifier)notifier);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map<String, UUID> names) {
        return new FineImmutableSessionAttributes(names, FineSessionAttributesFactory.getKeyFactory(id), this.attributeCache, this.marshaller);
    }

    private static Function<UUID, SessionAttributeKey> getKeyFactory(final String id) {
        return new Function<UUID, SessionAttributeKey>(){

            @Override
            public SessionAttributeKey apply(UUID attributeId) {
                return new SessionAttributeKey(id, attributeId);
            }
        };
    }

    @CacheEntriesEvicted
    public void evicted(CacheEntriesEvictedEvent<Key<String>, ?> event) {
        if (!event.isPre()) {
            HashSet<SessionAttributeNamesKey> keys = new HashSet<SessionAttributeNamesKey>();
            for (Key key : event.getEntries().keySet()) {
                if (!(key instanceof SessionCreationMetaDataKey)) continue;
                keys.add(new SessionAttributeNamesKey((String)key.getValue()));
            }
            if (!keys.isEmpty()) {
                AdvancedCache cache = this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
                for (Map.Entry entry : this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).getAll(keys).entrySet()) {
                    Map names = (Map)entry.getValue();
                    if (names != null) {
                        String sessionId = (String)((SessionAttributeNamesKey)((Object)entry.getKey())).getValue();
                        for (UUID attributeId : names.values()) {
                            cache.evict((Object)new SessionAttributeKey(sessionId, attributeId));
                        }
                    }
                    this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).evict(entry.getKey());
                }
            }
        }
    }
}

