/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import org.keycloak.Config;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ImpersonationConstants {
    public static String IMPERSONATION_ROLE = "impersonation";

    public static void setupMasterRealmRole(RealmProvider model, RealmModel realm) {
        RoleModel adminRole;
        RealmModel adminRealm;
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRealm = realm;
            adminRole = realm.getRole(AdminRoles.ADMIN);
        } else {
            adminRealm = model.getRealm(Config.getAdminRealm());
            adminRole = adminRealm.getRole(AdminRoles.ADMIN);
        }
        ClientModel realmAdminApp = adminRealm.getClientByClientId(KeycloakModelUtils.getMasterRealmAdminApplicationClientId(realm.getName()));
        if (realmAdminApp.getRole(IMPERSONATION_ROLE) != null) {
            return;
        }
        RoleModel impersonationRole = realmAdminApp.addRole(IMPERSONATION_ROLE);
        impersonationRole.setDescription("${role_" + IMPERSONATION_ROLE + "}");
        adminRole.addCompositeRole(impersonationRole);
    }

    public static void setupRealmRole(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        String realmAdminApplicationClientId = "realm-management";
        ClientModel realmAdminApp = realm.getClientByClientId(realmAdminApplicationClientId);
        if (realmAdminApp.getRole(IMPERSONATION_ROLE) != null) {
            return;
        }
        RoleModel impersonationRole = realmAdminApp.addRole(IMPERSONATION_ROLE);
        impersonationRole.setDescription("${role_" + IMPERSONATION_ROLE + "}");
        RoleModel adminRole = realmAdminApp.getRole(AdminRoles.REALM_ADMIN);
        adminRole.addCompositeRole(impersonationRole);
    }

    public static void setupImpersonationService(KeycloakSession session, RealmModel realm) {
        ImpersonationConstants.setupMasterRealmRole(session.realms(), realm);
        ImpersonationConstants.setupRealmRole(realm);
    }
}

