/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.ntlm.encoding;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.security.negotiation.ntlm.encoding.DecoderData;
import org.jboss.security.negotiation.ntlm.encoding.NegotiateFlags;

class NegotiateFlagsDecoder {
    NegotiateFlagsDecoder() {
    }

    static void readNegotiateFlags(InputStream is, DecoderData data) throws IOException {
        byte[] dataRead = new byte[4];
        NegotiateFlags flags = new NegotiateFlags();
        is.read(dataRead);
        NegotiateFlagsDecoder.readAtoG(flags, dataRead[0]);
        NegotiateFlagsDecoder.readHtoL(flags, dataRead[1]);
        NegotiateFlagsDecoder.readMtoS(flags, dataRead[2]);
        NegotiateFlagsDecoder.readTtoX(flags, dataRead[3]);
        data.message.setNegotiateFlags(flags);
        data.read += dataRead.length;
    }

    private static void readAtoG(NegotiateFlags flags, byte b) {
        flags.setUnicode((b & 1) == 1);
        flags.setOem((b & 2) == 2);
        flags.setRequestTarget((b & 4) == 4);
        flags.setSign((b & 0x10) == 16);
        flags.setSeal((b & 0x20) == 32);
        flags.setDatagram((b & 0x40) == 64);
        flags.setLmKey((b & 0x80) == 128);
    }

    private static void readHtoL(NegotiateFlags flags, byte b) {
        flags.setNtlm((b & 2) == 2);
        flags.setNtOnly((b & 4) == 4);
        flags.setOemDomainSupplied((b & 0x10) == 16);
        flags.setOemWorkstationSupplied((b & 0x20) == 32);
        flags.setAlwaysSign((b & 0x80) == 128);
    }

    private static void readMtoS(NegotiateFlags flags, byte b) {
        flags.setTargetTypeDomain((b & 1) == 1);
        flags.setTargetTypeServer((b & 2) == 2);
        flags.setTargetTypeShare((b & 4) == 4);
        flags.setNtlm2((b & 8) == 8);
        flags.setIdentify((b & 0x10) == 16);
        flags.setRequestNonNTSessionKey((b & 0x40) == 64);
        flags.setTargetInfo((b & 0x80) == 128);
    }

    private static void readTtoX(NegotiateFlags flags, byte b) {
        flags.setNegotiateVersion((b & 2) == 2);
        flags.setSessionKeyExchange128Bit((b & 0x20) == 32);
        flags.setExplicitKeyExchange((b & 0x40) == 64);
        flags.setEncryption56Bit((b & 0x80) == 128);
    }
}

