/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.dv;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.tools.xjc.util.NamespaceContextAdapter;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XmlString;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;

public class DefaultValuePlugin {
    private static final Logger LOG = Logger.getLogger(DefaultValuePlugin.class.getName());
    private boolean complexTypes;
    private boolean active;

    public String getOptionName() {
        return "Xdv";
    }

    public String getUsage() {
        return "  -Xdv                 : Initialize fields mapped from elements with their default values\n  -Xdv:optional        : Initialize fields mapped from elements with their default values\n                         for elements with minOccurs=0 but with complexTypes containing \n                         fields with default values.";
    }

    public int parseArgument(Options opt, String[] args, int index, Plugin plugin) throws BadCommandLineException, IOException {
        int ret = 0;
        if (args[index].startsWith("-Xdv")) {
            ret = 1;
            if (args[index].indexOf(":optional") != -1) {
                this.complexTypes = true;
            }
            if (!opt.activePlugins.contains(plugin)) {
                opt.activePlugins.add(plugin);
            }
            this.active = true;
        }
        return ret;
    }

    private boolean isAbstract(Outline outline, FieldOutline field) {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (classOutline.implClass != field.getRawType() || !classOutline.implClass.isAbstract()) continue;
            return true;
        }
        return false;
    }

    private boolean containsDefaultValue(Outline outline, FieldOutline field) {
        ClassOutline fClass = null;
        for (ClassOutline classOutline : outline.getClasses()) {
            if (classOutline.implClass != field.getRawType() || classOutline.implClass.isAbstract()) continue;
            fClass = classOutline;
            break;
        }
        if (fClass == null) {
            return false;
        }
        for (FieldOutline f : fClass.getDeclaredFields()) {
            XSParticle particle;
            XSTerm term;
            if (!(f.getPropertyInfo().getSchemaComponent() instanceof XSParticle) || !(term = (particle = (XSParticle)f.getPropertyInfo().getSchemaComponent()).getTerm()).isElementDecl() || term.asElementDecl().getDefaultValue() == null) continue;
            return true;
        }
        return false;
    }

    private boolean isElementRequired(XSParticle particle) {
        return particle != null && this.getMinOccurs(particle) != 0 && this.getMaxOccurs(particle) == 1;
    }

    private int getMinOccurs(XSParticle particle) {
        try {
            Number o = (Number)particle.getClass().getMethod("getMinOccurs", new Class[0]).invoke((Object)particle, new Object[0]);
            return o.intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getMaxOccurs(XSParticle particle) {
        try {
            Number o = (Number)particle.getClass().getMethod("getMaxOccurs", new Class[0]).invoke((Object)particle, new Object[0]);
            return o.intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        if (!this.active) {
            return true;
        }
        LOG.fine("Running default value plugin.");
        for (ClassOutline co : outline.getClasses()) {
            for (FieldOutline f : co.getDeclaredFields()) {
                String typeName;
                JType type;
                XmlString xmlDefaultValue = null;
                XSSimpleType xsType = null;
                boolean isElement = false;
                boolean isRequiredAttr = true;
                XSParticle particle = null;
                if (f.getPropertyInfo().getSchemaComponent() instanceof XSParticle) {
                    particle = (XSParticle)f.getPropertyInfo().getSchemaComponent();
                    XSTerm term = particle.getTerm();
                    XSElementDecl element = null;
                    if (term.isElementDecl()) {
                        element = particle.getTerm().asElementDecl();
                        xmlDefaultValue = element.getDefaultValue();
                        xsType = element.getType();
                        isElement = true;
                    }
                } else if (f.getPropertyInfo().getSchemaComponent() instanceof XSAttributeUse) {
                    XSAttributeUse attributeUse = (XSAttributeUse)f.getPropertyInfo().getSchemaComponent();
                    XSAttributeDecl decl = attributeUse.getDecl();
                    xmlDefaultValue = decl.getDefaultValue();
                    xsType = decl.getType();
                    isRequiredAttr = attributeUse.isRequired();
                }
                if (xsType != null && xsType.isComplexType() && !this.isAbstract(outline, f) && (this.complexTypes && this.containsDefaultValue(outline, f) || this.isElementRequired(particle))) {
                    String varName = f.getPropertyInfo().getName(false);
                    JFieldVar var = (JFieldVar)co.implClass.fields().get(varName);
                    if (var != null && !"javax.xml.ws.wsaddressing.W3CEndpointReference".equals(f.getRawType().fullName())) {
                        var.init((JExpression)JExpr._new((JType)f.getRawType()));
                    }
                }
                JExpression dvExpr = null;
                if (null != xmlDefaultValue && null != xmlDefaultValue.value) {
                    dvExpr = this.getDefaultValueExpression(f, co, outline, (XSType)xsType, isElement, xmlDefaultValue, false);
                }
                if (null == dvExpr && !isElement && !isRequiredAttr && xsType != null && xsType.getOwnerSchema() != null) {
                    dvExpr = this.getDefaultValueExpression(f, co, outline, (XSType)xsType, false, xmlDefaultValue, true);
                    if (dvExpr != null) {
                        this.updateSetter(co, f, co.implClass);
                        this.updateGetter(co, f, co.implClass, dvExpr, true);
                        continue;
                    }
                    type = f.getRawType();
                    typeName = type.fullName();
                    if (!"javax.xml.datatype.Duration".equals(typeName)) continue;
                    this.updateDurationGetter(co, f, co.implClass, xmlDefaultValue, outline);
                    continue;
                }
                if (null == dvExpr) {
                    type = f.getRawType();
                    typeName = type.fullName();
                    if (!"javax.xml.datatype.Duration".equals(typeName)) continue;
                    this.updateDurationGetter(co, f, co.implClass, xmlDefaultValue, outline);
                    continue;
                }
                this.updateGetter(co, f, co.implClass, dvExpr, false);
            }
        }
        for (PackageOutline po : outline.getAllPackageContexts()) {
            JDefinedClass cls = po.objectFactoryGenerator().getObjectFactory();
            for (JMethod m : cls.methods()) {
                String tn = m.type().fullName();
                if (!tn.startsWith("javax.xml.bind.JAXBElement<java.util.List<") && !tn.startsWith("javax.xml.bind.JAXBElement<byte[]>")) continue;
                JBlock b = m.body();
                for (Object o : b.getContents()) {
                    try {
                        Field f = o.getClass().getDeclaredField("expr");
                        f.setAccessible(true);
                        JInvocation ji = (JInvocation)f.get(o);
                        f = JInvocation.class.getDeclaredField("args");
                        f.setAccessible(true);
                        List args = (List)f.get(ji);
                        JExpression cast = (JExpression)args.get(args.size() - 1);
                        if (!cast.getClass().getSimpleName().equals("JCast")) continue;
                        f = cast.getClass().getDeclaredField("object");
                        f.setAccessible(true);
                        JExpression exp = (JExpression)f.get(cast);
                        args.remove(args.size() - 1);
                        args.add(exp);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return true;
    }

    private void updateDurationGetter(ClassOutline co, FieldOutline fo, JDefinedClass dc, XmlString xmlDefaultValue, Outline outline) {
        String fieldName = fo.getPropertyInfo().getName(false);
        String getterName = "get" + fo.getPropertyInfo().getName(true);
        JMethod method = dc.getMethod(getterName, new JType[0]);
        JDocComment doc = method.javadoc();
        int mods = method.mods().getValue();
        JType mtype = method.type();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating getter: " + getterName);
        }
        dc.methods().remove(method);
        method = dc.method(mods, mtype, getterName);
        method.javadoc().append((Object)doc);
        JFieldRef fr = JExpr.ref((String)fieldName);
        if (xmlDefaultValue != null) {
            JExpression test = JOp.eq((JExpression)JExpr._null(), (JExpression)fr);
            JConditional jc = method.body()._if(test);
            JTryBlock b = jc._then()._try();
            b.body()._return((JExpression)outline.getCodeModel().ref(DatatypeFactory.class).staticInvoke("newInstance").invoke("newDuration").arg(JExpr.lit((String)xmlDefaultValue.value)));
            b._catch(outline.getCodeModel().ref(DatatypeConfigurationException.class));
            method.body()._return((JExpression)fr);
        } else {
            method.body()._return((JExpression)fr);
        }
    }

    JExpression getDefaultValueExpression(FieldOutline f, ClassOutline co, Outline outline, XSType xsType, boolean isElement, XmlString xmlDefaultValue, boolean unbox) {
        String defaultValue;
        JType type = f.getRawType();
        String typeName = type.fullName();
        String string = defaultValue = xmlDefaultValue == null ? null : xmlDefaultValue.value;
        if (defaultValue == null) {
            return null;
        }
        JExpression dv = null;
        if ("java.lang.Boolean".equals(typeName) && isElement) {
            dv = JExpr.direct((String)(Boolean.valueOf(defaultValue) != false ? "Boolean.TRUE" : "Boolean.FALSE"));
        } else if ("java.lang.Byte".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg((JExpression)JExpr.cast((JType)type.unboxify(), (JExpression)JExpr.lit((int)new Byte(Short.valueOf(defaultValue).byteValue()).byteValue())));
        } else if ("java.lang.Double".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((double)new Double(Double.valueOf(defaultValue))));
        } else if ("java.lang.Float".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((float)new Float(Float.valueOf(defaultValue).floatValue()).floatValue()));
        } else if ("java.lang.Integer".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((int)new Integer(Integer.valueOf(defaultValue))));
        } else if ("java.lang.Long".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((long)new Long(Long.valueOf(defaultValue))));
        } else if ("java.lang.Short".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg((JExpression)JExpr.cast((JType)type.unboxify(), (JExpression)JExpr.lit((int)new Short(Short.valueOf(defaultValue)).shortValue())));
        } else if ("java.lang.String".equals(type.fullName()) && isElement) {
            dv = JExpr.lit((String)defaultValue);
        } else if ("java.math.BigInteger".equals(type.fullName()) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((String)defaultValue));
        } else if ("java.math.BigDecimal".equals(type.fullName()) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((String)defaultValue));
        } else if ("byte[]".equals(type.fullName()) && xsType.isSimpleType() && isElement) {
            while (!"anySimpleType".equals(xsType.getBaseType().getName())) {
                xsType = xsType.getBaseType();
            }
            if ("base64Binary".equals(xsType.getName())) {
                dv = outline.getCodeModel().ref(DatatypeConverter.class).staticInvoke("parseBase64Binary").arg(defaultValue);
            } else if ("hexBinary".equals(xsType.getName())) {
                dv = JExpr._new((JClass)outline.getCodeModel().ref(HexBinaryAdapter.class)).invoke("unmarshal").arg(defaultValue);
            }
        } else if ("javax.xml.namespace.QName".equals(typeName)) {
            NamespaceContextAdapter nsc = new NamespaceContextAdapter(xmlDefaultValue);
            QName qn = DatatypeConverter.parseQName((String)xmlDefaultValue.value, (NamespaceContext)nsc);
            dv = JExpr._new((JClass)outline.getCodeModel().ref(QName.class)).arg(qn.getNamespaceURI()).arg(qn.getLocalPart()).arg(qn.getPrefix());
        } else if ("javax.xml.datatype.Duration".equals(typeName)) {
            dv = null;
        } else if (type instanceof JDefinedClass) {
            JDefinedClass cls = (JDefinedClass)type;
            if (cls.getClassType() == ClassType.ENUM) {
                dv = cls.staticInvoke("fromValue").arg(defaultValue);
            }
        } else if (unbox) {
            typeName = type.unboxify().fullName();
            dv = "int".equals(typeName) ? JExpr.lit((int)Integer.valueOf(defaultValue)) : ("long".equals(typeName) ? JExpr.lit((long)Long.valueOf(defaultValue)) : ("short".equals(typeName) ? JExpr.lit((int)Short.valueOf(defaultValue).shortValue()) : ("boolean".equals(typeName) ? JExpr.lit((boolean)Boolean.valueOf(defaultValue)) : ("double".equals(typeName) ? JExpr.lit((double)Double.valueOf(defaultValue)) : ("float".equals(typeName) ? JExpr.lit((float)Float.valueOf(defaultValue).floatValue()) : ("byte".equals(typeName) ? JExpr.lit((int)Byte.valueOf(defaultValue).byteValue()) : this.getDefaultValueExpression(f, co, outline, xsType, true, xmlDefaultValue, false)))))));
        }
        return dv;
    }

    private void updateGetter(ClassOutline co, FieldOutline fo, JDefinedClass dc, JExpression dvExpr, boolean remapRet) {
        String fieldName = fo.getPropertyInfo().getName(false);
        JType type = fo.getRawType();
        String typeName = type.fullName();
        String getterName = ("java.lang.Boolean".equals(typeName) ? "is" : "get") + fo.getPropertyInfo().getName(true);
        JMethod method = dc.getMethod(getterName, new JType[0]);
        JDocComment doc = method.javadoc();
        int mods = method.mods().getValue();
        JType mtype = method.type();
        if (remapRet) {
            mtype = mtype.unboxify();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating getter: " + getterName);
        }
        dc.methods().remove(method);
        method = dc.method(mods, mtype, getterName);
        method.javadoc().append((Object)doc);
        JFieldRef fr = JExpr.ref((String)fieldName);
        if (dvExpr != null) {
            JExpression test = JOp.eq((JExpression)JExpr._null(), (JExpression)fr);
            JConditional jc = method.body()._if(test);
            jc._then()._return(dvExpr);
        }
        method.body()._return((JExpression)fr);
    }

    private void updateSetter(ClassOutline co, FieldOutline fo, JDefinedClass dc) {
        String fieldName = fo.getPropertyInfo().getName(false);
        JType type = fo.getRawType();
        String typeName = type.fullName();
        String getterName = ("java.lang.Boolean".equals(typeName) ? "is" : "get") + fo.getPropertyInfo().getName(true);
        JMethod method = dc.getMethod(getterName, new JType[0]);
        JType mtype = method.type();
        String setterName = "set" + fo.getPropertyInfo().getName(true);
        method = dc.getMethod(setterName, new JType[]{mtype});
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating setter: " + setterName);
        }
        if (method == null) {
            return;
        }
        JDocComment doc = method.javadoc();
        dc.methods().remove(method);
        int mods = method.mods().getValue();
        mtype = mtype.unboxify();
        method = dc.method(mods, method.type(), setterName);
        method.javadoc().append((Object)doc);
        JVar var = method.param(mtype, "value");
        JFieldRef fr = JExpr.ref((String)fieldName);
        method.body().assign((JAssignmentTarget)fr, (JExpression)var);
        JMethod oldMethod = dc.getMethod("unset" + fo.getPropertyInfo().getName(true), new JType[0]);
        if (oldMethod != null) {
            dc.methods().remove(oldMethod);
        }
        method = dc.method(mods, method.type(), "unset" + fo.getPropertyInfo().getName(true));
        method.body().assign((JAssignmentTarget)fr, JExpr._null());
        method = dc.getMethod("isSet" + fo.getPropertyInfo().getName(true), new JType[0]);
        if (method != null) {
            dc.methods().remove(method);
            dc.methods().add(method);
        }
    }

    public void onActivated(Options opts) {
        this.active = true;
    }
}

