/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.keycloak.metrics;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.exporter.PushGateway;
import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;

public final class PrometheusExporter {
    private static final String USER_EVENT_PREFIX = "keycloak_user_event_";
    private static final String ADMIN_EVENT_PREFIX = "keycloak_admin_event_";
    private static final String PROVIDER_KEYCLOAK_OPENID = "keycloak";
    private static final String PROMETHEUS_PUSHGATEWAY_GROUPINGKEY_INSTANCE = "PROMETHEUS_GROUPING_KEY_INSTANCE";
    private static final Pattern PROMETHEUS_PUSHGATEWAY_GROUPINGKEY_INSTANCE_ENVVALUE_PATTERN = Pattern.compile("ENVVALUE:(.+?)");
    private static final String PROMETHEUS_PUSHGATEWAY_JOB = "PROMETHEUS_PUSHGATEWAY_JOB";
    private static PrometheusExporter INSTANCE;
    private static final Logger logger;
    final Map<String, Counter> counters = new HashMap<String, Counter>();
    final Counter totalLogins;
    final Counter totalLoginAttempts;
    final Counter totalFailedLoginAttempts;
    final Counter totalRegistrations;
    final Counter totalRegistrationsErrors;
    final Counter totalRefreshTokens;
    final Counter totalRefreshTokensErrors;
    final Counter totalClientLogins;
    final Counter totalFailedClientLoginAttempts;
    final Counter totalCodeToTokens;
    final Counter totalCodeToTokensErrors;
    final Counter responseTotal;
    final Counter responseErrors;
    final Histogram requestDuration;
    final PushGateway PUSH_GATEWAY = this.buildPushGateWay();

    private PrometheusExporter() {
        String counterName;
        this.totalLoginAttempts = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_login_attempts")).help("Total number of login attempts")).labelNames("realm", "provider", "client_id")).register();
        this.totalLogins = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_logins")).help("Total successful logins")).labelNames("realm", "provider", "client_id")).register();
        this.totalFailedLoginAttempts = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_failed_login_attempts")).help("Total failed login attempts")).labelNames("realm", "provider", "error", "client_id")).register();
        this.totalRegistrations = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_registrations")).help("Total registered users")).labelNames("realm", "provider", "client_id")).register();
        this.totalRegistrationsErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_registrations_errors")).help("Total errors on registrations")).labelNames("realm", "provider", "error", "client_id")).register();
        this.totalRefreshTokens = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_refresh_tokens")).help("Total number of successful token refreshes")).labelNames("realm", "provider", "client_id")).register();
        this.totalRefreshTokensErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_refresh_tokens_errors")).help("Total number of failed token refreshes")).labelNames("realm", "provider", "error", "client_id")).register();
        this.totalClientLogins = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_client_logins")).help("Total successful client logins")).labelNames("realm", "provider", "client_id")).register();
        this.totalFailedClientLoginAttempts = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_failed_client_login_attempts")).help("Total failed client login attempts")).labelNames("realm", "provider", "error", "client_id")).register();
        this.totalCodeToTokens = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_code_to_tokens")).help("Total number of successful code to token")).labelNames("realm", "provider", "client_id")).register();
        this.totalCodeToTokensErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_code_to_tokens_errors")).help("Total number of failed code to token")).labelNames("realm", "provider", "error", "client_id")).register();
        boolean URI_METRICS_ENABLED = Boolean.parseBoolean(System.getenv("URI_METRICS_ENABLED"));
        if (URI_METRICS_ENABLED) {
            this.responseTotal = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_response")).help("Total number of responses")).labelNames("code", "method", "resource", "uri")).register();
            this.responseErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_response_errors")).help("Total number of error responses")).labelNames("code", "method", "resource", "uri")).register();
            this.requestDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("keycloak_request_duration")).help("Request duration")).buckets(50.0, 100.0, 250.0, 500.0, 1000.0, 2000.0, 10000.0, 30000.0).labelNames("code", "method", "resource", "uri")).register();
        } else {
            this.responseTotal = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_response")).help("Total number of responses")).labelNames("code", "method", "resource")).register();
            this.responseErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_response_errors")).help("Total number of error responses")).labelNames("code", "method", "resource")).register();
            this.requestDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("keycloak_request_duration")).help("Request duration")).buckets(50.0, 100.0, 250.0, 500.0, 1000.0, 2000.0, 10000.0, 30000.0).labelNames("code", "method", "resource")).register();
        }
        for (EventType eventType : EventType.values()) {
            if (eventType.equals((Object)EventType.LOGIN) || eventType.equals((Object)EventType.LOGIN_ERROR) || eventType.equals((Object)EventType.REGISTER)) continue;
            counterName = this.buildCounterName(eventType);
            this.counters.put(counterName, PrometheusExporter.createCounter(counterName, false));
        }
        for (EventType eventType : OperationType.values()) {
            counterName = this.buildCounterName((OperationType)eventType);
            this.counters.put(counterName, PrometheusExporter.createCounter(counterName, true));
        }
        DefaultExports.initialize();
    }

    public static synchronized PrometheusExporter instance() {
        if (INSTANCE == null) {
            INSTANCE = new PrometheusExporter();
        }
        return INSTANCE;
    }

    private static Counter createCounter(String name, boolean isAdmin) {
        Counter.Builder counter = (Counter.Builder)Counter.build().name(name);
        if (isAdmin) {
            ((Counter.Builder)counter.labelNames("realm", "resource")).help("Generic KeyCloak Admin event");
        } else {
            ((Counter.Builder)counter.labelNames("realm")).help("Generic KeyCloak User event");
        }
        return (Counter)counter.register();
    }

    public void recordGenericEvent(Event event, RealmProvider realmProvider) {
        String counterName = this.buildCounterName(event.getType());
        if (this.counters.get(counterName) == null) {
            logger.warnf("Counter for event type %s does not exist. Realm: %s", (Object)event.getType().name(), (Object)this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)));
            return;
        }
        ((Counter.Child)this.counters.get(counterName).labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)))).inc();
        this.pushAsync();
    }

    public void recordGenericAdminEvent(AdminEvent event, RealmProvider realmProvider) {
        String counterName = this.buildCounterName(event.getOperationType());
        if (this.counters.get(counterName) == null) {
            logger.warnf("Counter for admin event operation type %s does not exist. Resource type: %s, realm: %s", (Object)event.getOperationType().name(), (Object)event.getResourceType().name(), (Object)event.getRealmId());
            return;
        }
        ((Counter.Child)this.counters.get(counterName).labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), event.getResourceType().name())).inc();
        this.pushAsync();
    }

    public void recordLogin(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalLoginAttempts.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getClientId()))).inc();
        ((Counter.Child)this.totalLogins.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRegistration(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalRegistrations.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRegistrationError(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalRegistrationsErrors.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getError()), this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordLoginError(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalLoginAttempts.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getClientId()))).inc();
        ((Counter.Child)this.totalFailedLoginAttempts.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getError()), this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordClientLogin(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalClientLogins.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordClientLoginError(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalFailedClientLoginAttempts.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getError()), this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRefreshToken(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalRefreshTokens.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRefreshTokenError(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalRefreshTokensErrors.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getError()), this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordCodeToToken(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalCodeToTokens.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordCodeToTokenError(Event event, RealmProvider realmProvider) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalCodeToTokensErrors.labels(this.nullToEmpty(this.getRealmName(event.getRealmId(), realmProvider)), provider, this.nullToEmpty(event.getError()), this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRequestDuration(int code, double amt, String method, String resource, String uri) {
        ((Histogram.Child)this.requestDuration.labels(Integer.toString(code), method, resource, uri)).observe(amt);
        this.pushAsync();
    }

    public void recordRequestDuration(int code, double amt, String method, String resource) {
        ((Histogram.Child)this.requestDuration.labels(Integer.toString(code), method, resource)).observe(amt);
        this.pushAsync();
    }

    public void recordResponseTotal(int code, String method, String resource, String uri) {
        ((Counter.Child)this.responseTotal.labels(Integer.toString(code), method, resource, uri)).inc();
        this.pushAsync();
    }

    public void recordResponseTotal(int code, String method, String resource) {
        ((Counter.Child)this.responseTotal.labels(Integer.toString(code), method, resource)).inc();
        this.pushAsync();
    }

    public void recordResponseError(int code, String method, String resource, String uri) {
        ((Counter.Child)this.responseErrors.labels(Integer.toString(code), method, resource, uri)).inc();
        this.pushAsync();
    }

    public void recordResponseError(int code, String method, String resource) {
        ((Counter.Child)this.responseErrors.labels(Integer.toString(code), method, resource)).inc();
        this.pushAsync();
    }

    private String getIdentityProvider(Event event) {
        String identityProvider = null;
        if (event.getDetails() != null) {
            identityProvider = (String)event.getDetails().get("identity_provider");
        }
        if (identityProvider == null) {
            identityProvider = PROVIDER_KEYCLOAK_OPENID;
        }
        return identityProvider;
    }

    private String getRealmName(String realmId, RealmProvider realmProvider) {
        RealmModel realm = null;
        if (realmId != null) {
            realm = realmProvider.getRealm(realmId);
        }
        if (realm != null) {
            return realm.getName();
        }
        return null;
    }

    public void export(OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        TextFormat.write004(writer, CollectorRegistry.defaultRegistry.metricFamilySamples());
        ((Writer)writer).flush();
    }

    private PushGateway buildPushGateWay() {
        PushGateway pg = null;
        Object host = System.getenv("PROMETHEUS_PUSHGATEWAY_ADDRESS");
        if (host != null) {
            if (!((String)host).toLowerCase().startsWith("http://") && !((String)host).startsWith("https://")) {
                host = "http://" + (String)host;
            }
            try {
                pg = new PushGateway(new URL((String)host));
                logger.info((Object)("Pushgateway created with url " + (String)host + "."));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return pg;
    }

    public void pushAsync() {
        CompletableFuture.runAsync(() -> this.push());
    }

    private static String instanceIp() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    private static String groupingKey() throws UnknownHostException {
        return Optional.ofNullable(System.getenv(PROMETHEUS_PUSHGATEWAY_GROUPINGKEY_INSTANCE)).map(envValue -> {
            Matcher matcher = PROMETHEUS_PUSHGATEWAY_GROUPINGKEY_INSTANCE_ENVVALUE_PATTERN.matcher((CharSequence)envValue);
            if (matcher.matches()) {
                return System.getenv(matcher.group(1));
            }
            return envValue;
        }).orElse(PrometheusExporter.instanceIp());
    }

    private void push() {
        if (this.PUSH_GATEWAY != null) {
            try {
                String job = Optional.ofNullable(System.getenv(PROMETHEUS_PUSHGATEWAY_JOB)).orElse(PROVIDER_KEYCLOAK_OPENID);
                Map<String, String> groupingKey = Collections.singletonMap("instance", PrometheusExporter.groupingKey());
                this.PUSH_GATEWAY.pushAdd(CollectorRegistry.defaultRegistry, job, groupingKey);
            }
            catch (IOException e) {
                logger.error((Object)"Unable to send to prometheus PushGateway", (Throwable)e);
            }
        }
    }

    private String buildCounterName(OperationType type) {
        return ADMIN_EVENT_PREFIX + type.name();
    }

    private String buildCounterName(EventType type) {
        return USER_EVENT_PREFIX + type.name();
    }

    private String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    static {
        logger = Logger.getLogger(PrometheusExporter.class);
    }
}

