"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var theme_1 = require("../../../../../utils/themes/theme");
var spec_1 = require("../../../state/utils/spec");
var specs_1 = require("../../../utils/specs");
var lines_1 = require("./lines");
var rect_1 = require("./rect");
function renderAnnotations(ctx, props, renderOnBackground) {
    if (renderOnBackground === void 0) { renderOnBackground = true; }
    var annotationDimensions = props.annotationDimensions, annotationSpecs = props.annotationSpecs;
    annotationDimensions.forEach(function (annotation, id) {
        var spec = spec_1.getSpecsById(annotationSpecs, id);
        if (!spec) {
            return null;
        }
        var isBackground = !spec.zIndex || (spec.zIndex && spec.zIndex <= 0);
        if ((isBackground && renderOnBackground) || (!isBackground && !renderOnBackground)) {
            if (specs_1.isLineAnnotation(spec)) {
                var lineStyle = theme_1.mergeWithDefaultAnnotationLine(spec.style);
                lines_1.renderLineAnnotations(ctx, annotation, lineStyle);
            }
            else if (specs_1.isRectAnnotation(spec)) {
                var rectStyle = theme_1.mergeWithDefaultAnnotationRect(spec.style);
                rect_1.renderRectAnnotations(ctx, annotation, rectStyle);
            }
        }
    });
}
exports.renderAnnotations = renderAnnotations;
//# sourceMappingURL=index.js.map