"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../renderers/canvas");
var color_library_wrappers_1 = require("../../../partition_chart/layout/utils/color_library_wrappers");
var annotations_1 = require("./annotations");
var areas_1 = require("./areas");
var axes_1 = require("./axes");
var bars_1 = require("./bars");
var bubbles_1 = require("./bubbles");
var grids_1 = require("./grids");
var lines_1 = require("./lines");
var debug_1 = require("./utils/debug");
var bar_1 = require("./values/bar");
function renderXYChartCanvas2d(ctx, dpr, clippings, props) {
    canvas_1.withContext(ctx, function (ctx) {
        ctx.scale(dpr, dpr);
        var chartDimensions = props.chartDimensions, chartTransform = props.chartTransform, chartRotation = props.chartRotation, geometries = props.geometries, geometriesIndex = props.geometriesIndex, theme = props.theme, highlightedLegendItem = props.highlightedLegendItem, annotationDimensions = props.annotationDimensions, annotationSpecs = props.annotationSpecs, axisTickPositions = props.axisTickPositions, axesSpecs = props.axesSpecs, axesTicksDimensions = props.axesTicksDimensions, axesStyles = props.axesStyles, axesGridLinesPositions = props.axesGridLinesPositions, debug = props.debug;
        var transform = {
            x: chartDimensions.left + chartTransform.x,
            y: chartDimensions.top + chartTransform.y,
        };
        canvas_1.renderLayers(ctx, [
            function (ctx) { return canvas_1.clearCanvas(ctx, 200000, 200000); },
            function (ctx) {
                axes_1.renderAxes(ctx, {
                    axesPositions: axisTickPositions.axisPositions,
                    axesSpecs: axesSpecs,
                    axesTicksDimensions: axesTicksDimensions,
                    axesVisibleTicks: axisTickPositions.axisVisibleTicks,
                    chartDimensions: chartDimensions,
                    debug: debug,
                    axesStyles: axesStyles,
                    sharedAxesStyle: theme.axes,
                });
            },
            function (ctx) {
                grids_1.renderGrids(ctx, {
                    axesSpecs: axesSpecs,
                    chartDimensions: chartDimensions,
                    axesGridLinesPositions: axesGridLinesPositions,
                    axesStyles: axesStyles,
                    sharedAxesStyle: theme.axes,
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    ctx.translate(transform.x, transform.y);
                    ctx.rotate((chartRotation * Math.PI) / 180);
                    annotations_1.renderAnnotations(ctx, {
                        annotationDimensions: annotationDimensions,
                        annotationSpecs: annotationSpecs,
                    }, true);
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    ctx.translate(transform.x, transform.y);
                    ctx.rotate((chartRotation * Math.PI) / 180);
                    bars_1.renderBars(ctx, geometries.bars, theme.sharedStyle, clippings, highlightedLegendItem);
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    ctx.translate(transform.x, transform.y);
                    ctx.rotate((chartRotation * Math.PI) / 180);
                    areas_1.renderAreas(ctx, {
                        areas: geometries.areas,
                        clippings: clippings,
                        highlightedLegendItem: highlightedLegendItem || null,
                        sharedStyle: theme.sharedStyle,
                    });
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    ctx.translate(transform.x, transform.y);
                    ctx.rotate((chartRotation * Math.PI) / 180);
                    lines_1.renderLines(ctx, {
                        lines: geometries.lines,
                        clippings: clippings,
                        highlightedLegendItem: highlightedLegendItem || null,
                        sharedStyle: theme.sharedStyle,
                    });
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    ctx.translate(transform.x, transform.y);
                    ctx.rotate((chartRotation * Math.PI) / 180);
                    bubbles_1.renderBubbles(ctx, {
                        bubbles: geometries.bubbles,
                        clippings: clippings,
                        highlightedLegendItem: highlightedLegendItem || null,
                        sharedStyle: theme.sharedStyle,
                    });
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    ctx.translate(transform.x, transform.y);
                    ctx.rotate((chartRotation * Math.PI) / 180);
                    bar_1.renderBarValues(ctx, {
                        bars: geometries.bars,
                        chartDimensions: chartDimensions,
                        chartRotation: chartRotation,
                        debug: debug,
                        theme: theme,
                    });
                });
            },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    ctx.translate(transform.x, transform.y);
                    ctx.rotate((chartRotation * Math.PI) / 180);
                    annotations_1.renderAnnotations(ctx, {
                        annotationDimensions: annotationDimensions,
                        annotationSpecs: annotationSpecs,
                    }, false);
                });
            },
            function (ctx) {
                if (!debug) {
                    return;
                }
                canvas_1.withContext(ctx, function (ctx) {
                    var left = chartDimensions.left, top = chartDimensions.top, width = chartDimensions.width, height = chartDimensions.height;
                    debug_1.renderDebugRect(ctx, {
                        x: left,
                        y: top,
                        width: width,
                        height: height,
                    }, {
                        color: color_library_wrappers_1.stringToRGB('transparent'),
                    }, {
                        color: color_library_wrappers_1.stringToRGB('red'),
                        width: 4,
                        dash: [4, 4],
                    });
                    var triangulation = geometriesIndex.triangulation([0, 0, width, height]);
                    if (triangulation) {
                        ctx.beginPath();
                        ctx.translate(left, top);
                        ctx.setLineDash([5, 5]);
                        triangulation.render(ctx);
                        ctx.lineWidth = 1;
                        ctx.strokeStyle = 'blue';
                        ctx.stroke();
                    }
                });
            },
        ]);
    });
}
exports.renderXYChartCanvas2d = renderXYChartCanvas2d;
//# sourceMappingURL=renderers.js.map