/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.graphic.XGraphic;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import org.openoffice.da.comp.w2lcommon.filter.ByteArrayXStream;
import org.openoffice.da.comp.w2lcommon.filter.EPSCleaner;
import writer2latex.api.GraphicConverter;

public class GraphicConverterImpl1
implements GraphicConverter {
    private XGraphicProvider xGraphicProvider;
    private EPSCleaner epsCleaner;

    public GraphicConverterImpl1(XComponentContext xComponentContext) {
        try {
            XMultiComponentFactory xMCF = xComponentContext.getServiceManager();
            Object graphicProviderObject = xMCF.createInstanceWithContext("com.sun.star.graphic.GraphicProvider", xComponentContext);
            this.xGraphicProvider = (XGraphicProvider)UnoRuntime.queryInterface(XGraphicProvider.class, (Object)graphicProviderObject);
        }
        catch (Exception ex) {
            System.err.println("Failed to get XGraphicProvider object");
            this.xGraphicProvider = null;
        }
        this.epsCleaner = new EPSCleaner();
    }

    @Override
    public boolean supportsConversion(String sSourceMime, String sTargetMime, boolean bCrop, boolean bResize) {
        if (bCrop || bResize) {
            return false;
        }
        if (("image/x-eps".equals(sTargetMime) || "image/svg+xml".equals(sTargetMime)) && ("image/x-emf".equals(sSourceMime) || "image/x-wmf".equals(sSourceMime) || "application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(sSourceMime))) {
            return true;
        }
        boolean bSupportsSource = "image/png".equals(sSourceMime) || "image/jpeg".equals(sSourceMime) || "image/gif".equals(sSourceMime) || "image/tiff".equals(sSourceMime) || "image/bmp".equals(sSourceMime) || "image/x-emf".equals(sSourceMime) || "image/x-wmf".equals(sSourceMime) || "application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(sSourceMime);
        boolean bSupportsTarget = "image/png".equals(sTargetMime) || "image/jpeg".equals(sTargetMime) || "image/gif".equals(sTargetMime) || "image/tiff".equals(sTargetMime) || "image/bmp".equals(sTargetMime);
        return bSupportsSource && bSupportsTarget;
    }

    @Override
    public byte[] convert(byte[] source, String sSourceMime, String sTargetMime) {
        if ("image/x-eps".equals(sTargetMime) && !"image/x-emf".equals(sSourceMime) && !"image/x-wmf".equals(sSourceMime) && !"application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(sSourceMime)) {
            return null;
        }
        ByteArrayToXInputStreamAdapter xSource = new ByteArrayToXInputStreamAdapter(source);
        ByteArrayXStream xTarget = new ByteArrayXStream();
        try {
            PropertyValue[] sourceProps = new PropertyValue[]{new PropertyValue()};
            sourceProps[0].Name = "InputStream";
            sourceProps[0].Value = xSource;
            XGraphic result = this.xGraphicProvider.queryGraphic(sourceProps);
            PropertyValue[] targetProps = new PropertyValue[2];
            targetProps[0] = new PropertyValue();
            targetProps[0].Name = "MimeType";
            targetProps[0].Value = sTargetMime;
            targetProps[1] = new PropertyValue();
            targetProps[1].Name = "OutputStream";
            targetProps[1].Value = xTarget;
            this.xGraphicProvider.storeGraphic(result, targetProps);
            xTarget.flush();
            xTarget.closeOutput();
            if ("image/x-eps".equals(sTargetMime)) {
                return this.epsCleaner.cleanEps(xTarget.getBuffer());
            }
            byte[] converted = xTarget.getBuffer();
            if (converted.length > 0) {
                return converted;
            }
            return null;
        }
        catch (IOException e) {}
        catch (IllegalArgumentException e) {}
        catch (WrappedTargetException e) {}
        finally {
            return null;
        }
    }
}

