/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.NokogiriService;
import nokogiri.XmlSaxParserContext;
import nokogiri.internals.NokogiriHandler;
import nokogiri.internals.NokogiriHelpers;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.cyberneko.html.parsers.SAXParser;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.xml.sax.SAXException;

@JRubyClass(name={"Nokogiri::HTML::SAX::ParserContext"}, parent="Nokogiri::XML::SAX::ParserContext")
public class HtmlSaxParserContext
extends XmlSaxParserContext {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset(()|\\s)=(()|\\s)([a-z]|-|_|\\d)+");

    public HtmlSaxParserContext(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @Override
    protected AbstractSAXParser createParser() throws SAXException {
        SAXParser sAXParser = new SAXParser();
        try {
            sAXParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            sAXParser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
            return sAXParser;
        }
        catch (SAXException sAXException) {
            throw new SAXException("Problem while creating HTML SAX Parser: " + sAXException.toString());
        }
    }

    @JRubyMethod(name={"memory"}, meta=true)
    public static IRubyObject parse_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlSaxParserContext.initialize(threadContext.getRuntime());
        String string = HtmlSaxParserContext.findEncoding(threadContext, iRubyObject3);
        if (string != null) {
            String string2 = HtmlSaxParserContext.applyEncoding(NokogiriHelpers.rubyStringToString(iRubyObject2), string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            htmlSaxParserContext.setInputSource(byteArrayInputStream);
            htmlSaxParserContext.getInputSource().setEncoding(string);
        }
        return htmlSaxParserContext;
    }

    private static String findName(int n) {
        for (EncodingType encodingType : EncodingType.values()) {
            if (encodingType.getValue() != n) continue;
            return encodingType.toString();
        }
        return null;
    }

    private static String findEncoding(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string = null;
        if (iRubyObject instanceof RubyString) {
            string = NokogiriHelpers.rubyStringToString(iRubyObject);
        } else if (iRubyObject instanceof RubyFixnum) {
            int n = RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)iRubyObject));
            string = HtmlSaxParserContext.findName(n);
        }
        if (string == null) {
            return null;
        }
        try {
            return Charset.forName(string).displayName();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw threadContext.getRuntime().newEncodingCompatibilityError(string + "is not supported");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw threadContext.getRuntime().newInvalidEncoding(illegalCharsetNameException.getMessage());
        }
    }

    private static String applyEncoding(String string, String string2) {
        Object object;
        String string3 = string.toLowerCase();
        int n = 0;
        int n2 = 0;
        if (string.contains("meta") && string.contains("charset")) {
            object = CHARSET_PATTERN.matcher(string3);
            while (((Matcher)object).find()) {
                n = ((Matcher)object).start();
                n2 = ((Matcher)object).end();
            }
        }
        if (n != n2) {
            object = string.substring(n, n2);
            string = string.replace((CharSequence)object, "charset=" + string2);
        }
        return string;
    }

    @JRubyMethod(name={"file"}, meta=true)
    public static IRubyObject parse_file(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlSaxParserContext.initialize(threadContext.getRuntime());
        htmlSaxParserContext.setInputSourceFile(threadContext, iRubyObject2);
        String string = HtmlSaxParserContext.findEncoding(threadContext, iRubyObject3);
        if (string != null) {
            htmlSaxParserContext.getInputSource().setEncoding(string);
        }
        return htmlSaxParserContext;
    }

    @JRubyMethod(name={"io"}, meta=true)
    public static IRubyObject parse_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlSaxParserContext.initialize(threadContext.getRuntime());
        htmlSaxParserContext.setInputSource(threadContext, iRubyObject2, threadContext.getRuntime().getNil());
        String string = HtmlSaxParserContext.findEncoding(threadContext, iRubyObject3);
        if (string != null) {
            htmlSaxParserContext.getInputSource().setEncoding(string);
        }
        return htmlSaxParserContext;
    }

    static HtmlSaxParserContext parse_stream(Ruby ruby, RubyClass rubyClass, InputStream inputStream) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(ruby, rubyClass);
        htmlSaxParserContext.initialize(ruby);
        htmlSaxParserContext.setInputSource(inputStream);
        return htmlSaxParserContext;
    }

    @Override
    protected void preParse(Ruby ruby, IRubyObject iRubyObject, NokogiriHandler nokogiriHandler) {
    }

    public static enum EncodingType {
        NONE(0, "NONE"),
        UTF_8(1, "UTF-8"),
        UTF16LE(2, "UTF16LE"),
        UTF16BE(3, "UTF16BE"),
        UCS4LE(4, "UCS4LE"),
        UCS4BE(5, "UCS4BE"),
        EBCDIC(6, "EBCDIC"),
        UCS4_2143(7, "ICS4-2143"),
        UCS4_3412(8, "UCS4-3412"),
        UCS2(9, "UCS2"),
        ISO_8859_1(10, "ISO-8859-1"),
        ISO_8859_2(11, "ISO-8859-2"),
        ISO_8859_3(12, "ISO-8859-3"),
        ISO_8859_4(13, "ISO-8859-4"),
        ISO_8859_5(14, "ISO-8859-5"),
        ISO_8859_6(15, "ISO-8859-6"),
        ISO_8859_7(16, "ISO-8859-7"),
        ISO_8859_8(17, "ISO-8859-8"),
        ISO_8859_9(18, "ISO-8859-9"),
        ISO_2022_JP(19, "ISO-2022-JP"),
        SHIFT_JIS(20, "SHIFT-JIS"),
        EUC_JP(21, "EUC-JP"),
        ASCII(22, "ASCII");

        private final int value;
        private final String name;

        private EncodingType(int n2, String string2) {
            this.value = n2;
            this.name = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }
}

