/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.MapJavaProxy;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

public final class RubyJavaIntegration {
    private RubyJavaIntegration() {
    }

    public static void setupRubyJavaIntegration(Ruby ruby) {
        ruby.getArray().defineAnnotatedMethods(RubyArrayOverride.class);
        ruby.getHash().defineAnnotatedMethods(RubyHashOverride.class);
        Stream.of(LinkedHashMap.class, HashMap.class).forEach(cls -> JavaClass.get((Ruby)ruby, (Class)cls).getProxyModule().defineAnnotatedMethods(RubyMapProxyOverride.class));
        JavaClass.get((Ruby)ruby, Map.class).getProxyModule().defineAnnotatedMethods(JavaMapOverride.class);
        JavaClass.get((Ruby)ruby, Collection.class).getProxyModule().defineAnnotatedMethods(JavaCollectionOverride.class);
    }

    public static final class RubyArrayOverride {
        private RubyArrayOverride() {
        }

        @JRubyMethod(name={"==="}, meta=true)
        public static IRubyObject opEqq(ThreadContext context, IRubyObject rcvd, IRubyObject obj) {
            if (obj instanceof JavaProxy && Collection.class.isAssignableFrom(obj.getJavaClass())) {
                return context.tru;
            }
            return rcvd.op_eqq(context, obj);
        }
    }

    public static final class RubyHashOverride {
        private RubyHashOverride() {
        }

        @JRubyMethod(name={"==="}, meta=true)
        public static IRubyObject opEqq(ThreadContext context, IRubyObject rcvd, IRubyObject obj) {
            if (obj instanceof JavaProxy && Map.class.isAssignableFrom(obj.getJavaClass())) {
                return context.tru;
            }
            return rcvd.op_eqq(context, obj);
        }
    }

    public static final class JavaMapOverride {
        private JavaMapOverride() {
        }

        @JRubyMethod(name={"is_a?"})
        public static IRubyObject isA(ThreadContext context, IRubyObject self, IRubyObject clazz) {
            if (context.runtime.getHash().equals((Object)clazz)) {
                return context.tru;
            }
            return ((RubyBasicObject)self).kind_of_p(context, clazz);
        }
    }

    public static final class JavaCollectionOverride {
        private static final Collection<IRubyObject> NIL_COLLECTION = Collections.singletonList(RubyUtil.RUBY.getNil());
        private static final Collection<IRubyObject> NULL_COLLECTION = Collections.singletonList(null);

        private JavaCollectionOverride() {
        }

        @JRubyMethod(name={"is_a?"})
        public static IRubyObject isA(ThreadContext context, IRubyObject self, IRubyObject clazz) {
            if (context.runtime.getArray().equals((Object)clazz)) {
                return context.tru;
            }
            return ((RubyBasicObject)self).kind_of_p(context, clazz);
        }

        @JRubyMethod
        public static IRubyObject delete(ThreadContext context, IRubyObject self, IRubyObject obj, Block block) {
            Object java = obj.toJava(Object.class);
            Collection unwrappedSelf = (Collection)JavaUtil.unwrapIfJavaObject((IRubyObject)self);
            if (unwrappedSelf.removeAll(Collections.singletonList(java))) {
                return obj;
            }
            if (block.isGiven()) {
                return block.yield(context, obj);
            }
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject compact(ThreadContext context, IRubyObject self) {
            ArrayList dup = new ArrayList((Collection)JavaUtil.unwrapIfJavaObject((IRubyObject)self));
            JavaCollectionOverride.removeNilAndNull(dup);
            return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, dup);
        }

        @JRubyMethod(name={"compact!"})
        public static IRubyObject compactBang(ThreadContext context, IRubyObject self) {
            if (JavaCollectionOverride.removeNilAndNull((Collection)JavaUtil.unwrapIfJavaObject((IRubyObject)self))) {
                return self;
            }
            return context.nil;
        }

        @JRubyMethod(name={"&"})
        public static IRubyObject and(ThreadContext context, IRubyObject self, IRubyObject other) {
            LinkedHashSet dup = new LinkedHashSet((Collection)JavaUtil.unwrapIfJavaObject((IRubyObject)self));
            dup.retainAll((Collection)JavaUtil.unwrapIfJavaObject((IRubyObject)other));
            return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, dup);
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject or(ThreadContext context, IRubyObject self, IRubyObject other) {
            LinkedHashSet dup = new LinkedHashSet((Collection)JavaUtil.unwrapIfJavaObject((IRubyObject)self));
            dup.addAll((Collection)JavaUtil.unwrapIfJavaObject((IRubyObject)other));
            return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, dup);
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self) {
            return RubyString.newString((Ruby)context.runtime, (String)("<" + self.getMetaClass().name().asJavaString() + ':' + self.hashCode() + ' ' + self.convertToArray().inspect() + '>'));
        }

        private static boolean removeNilAndNull(Collection<?> collection) {
            boolean res = collection.removeAll(NIL_COLLECTION);
            return collection.removeAll(NULL_COLLECTION) || res;
        }
    }

    public static final class RubyMapProxyOverride {
        private RubyMapProxyOverride() {
        }

        @JRubyMethod(name={"has_key?", "include?", "member?", "key?"})
        public static IRubyObject containsKey(ThreadContext context, IRubyObject self, IRubyObject key) {
            return ((Map)JavaUtil.unwrapIfJavaObject((IRubyObject)self)).containsKey(key.toJava(Object.class)) ? context.tru : context.fals;
        }

        @JRubyMethod
        public static IRubyObject merge(ThreadContext context, IRubyObject self, IRubyObject other) {
            return ((MapJavaProxy)self.dup()).merge_bang(context, other, Block.NULL_BLOCK);
        }
    }
}

