/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.MissingConverterException;
import org.logstash.Timestamp;
import org.logstash.ext.JrubyTimestampExtLibrary;

public final class Rubyfier {
    private static final Converter IDENTITY = (runtime, input) -> (IRubyObject)input;
    private static final Converter FLOAT_CONVERTER = (runtime, input) -> runtime.newFloat(((Number)input).doubleValue());
    private static final Converter LONG_CONVERTER = (runtime, input) -> runtime.newFixnum(((Number)input).longValue());
    private static final Map<Class<?>, Converter> CONVERTER_MAP = Rubyfier.initConverters();

    private Rubyfier() {
    }

    public static IRubyObject deep(Ruby runtime, Object input) {
        if (input == null) {
            return runtime.getNil();
        }
        Class<?> cls = input.getClass();
        Converter converter = CONVERTER_MAP.get(cls);
        if (converter != null) {
            return converter.convert(runtime, input);
        }
        return Rubyfier.fallbackConvert(runtime, input, cls);
    }

    private static RubyArray deepList(Ruby runtime, Collection<?> list) {
        int length = list.size();
        RubyArray array = runtime.newArray(length);
        for (Object item : list) {
            array.add((Object)Rubyfier.deep(runtime, item));
        }
        return array;
    }

    private static RubyHash deepMap(Ruby runtime, Map<?, ?> map) {
        RubyHash hash = RubyHash.newHash((Ruby)runtime);
        map.forEach((key, value) -> hash.put(key, (Object)Rubyfier.deep(runtime, value)));
        return hash;
    }

    private static Map<Class<?>, Converter> initConverters() {
        ConcurrentHashMap converters = new ConcurrentHashMap(50, 0.2f, 1);
        converters.put(RubyString.class, IDENTITY);
        converters.put(RubyNil.class, IDENTITY);
        converters.put(RubySymbol.class, IDENTITY);
        converters.put(RubyBignum.class, IDENTITY);
        converters.put(RubyBigDecimal.class, IDENTITY);
        converters.put(RubyFloat.class, IDENTITY);
        converters.put(RubyFixnum.class, IDENTITY);
        converters.put(RubyBoolean.class, IDENTITY);
        converters.put(JrubyTimestampExtLibrary.RubyTimestamp.class, IDENTITY);
        converters.put(String.class, (runtime, input) -> runtime.newString((String)input));
        converters.put(Double.class, FLOAT_CONVERTER);
        converters.put(Float.class, FLOAT_CONVERTER);
        converters.put(Integer.class, LONG_CONVERTER);
        converters.put(BigInteger.class, (runtime, value) -> RubyBignum.newBignum((Ruby)runtime, (BigInteger)((BigInteger)value)));
        converters.put(BigDecimal.class, (runtime, value) -> new RubyBigDecimal(runtime, (BigDecimal)value));
        converters.put(Long.class, LONG_CONVERTER);
        converters.put(Boolean.class, (runtime, input) -> runtime.newBoolean(((Boolean)input).booleanValue()));
        converters.put(Map.class, (runtime, input) -> Rubyfier.deepMap(runtime, (Map)input));
        converters.put(Collection.class, (runtime, input) -> Rubyfier.deepList(runtime, (Collection)input));
        converters.put(Timestamp.class, (runtime, input) -> JrubyTimestampExtLibrary.RubyTimestamp.newRubyTimestamp(runtime, (Timestamp)input));
        return converters;
    }

    private static IRubyObject fallbackConvert(Ruby runtime, Object o, Class<?> cls) {
        for (Map.Entry<Class<?>, Converter> entry : CONVERTER_MAP.entrySet()) {
            if (!entry.getKey().isAssignableFrom(cls)) continue;
            Converter found = entry.getValue();
            CONVERTER_MAP.put(cls, found);
            return found.convert(runtime, o);
        }
        throw new MissingConverterException(cls);
    }

    private static interface Converter {
        public IRubyObject convert(Ruby var1, Object var2);
    }
}

