/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityCircleLine
extends Extremity {
    private final XPoint2D contact;
    private final double angle;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityCircleLine(XPoint2D p1, double angle) {
        this.contact = new XPoint2D(p1.getX(), p1.getY());
        this.angle = this.manageround(angle + 1.5707963267948966);
    }

    @Override
    public void drawU(UGraphic ug) {
        double thickness = ug.getParam().getStroke().getThickness();
        double radius = 4.0 + thickness - 1.0;
        double lineHeight = 4.0 + thickness - 1.0;
        int xWing = 4;
        AffineTransform rotate = AffineTransform.getRotateInstance(this.angle);
        XPoint2D middle = new XPoint2D(0.0, 0.0);
        XPoint2D base = new XPoint2D(-4.0 - radius - 3.0, 0.0);
        XPoint2D circleBase = new XPoint2D(-4.0 - radius - 3.0, 0.0);
        XPoint2D lineTop = new XPoint2D(-4.0, -lineHeight);
        XPoint2D lineBottom = new XPoint2D(-4.0, lineHeight);
        lineTop = lineTop.transform(rotate);
        lineBottom = lineBottom.transform(rotate);
        base = base.transform(rotate);
        circleBase = circleBase.transform(rotate);
        ExtremityCircleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), base, middle);
        UStroke stroke = UStroke.withThickness(thickness);
        ug.apply(new UTranslate(this.contact.getX() + circleBase.getX() - radius, this.contact.getY() + circleBase.getY() - radius)).apply(stroke).draw(UEllipse.build(2.0 * radius, 2.0 * radius));
        ExtremityCircleLine.drawLine(ug.apply(stroke), this.contact.getX(), this.contact.getY(), lineTop, lineBottom);
    }

    private static void drawLine(UGraphic ug, double x, double y, XPoint2D p1, XPoint2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

