/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.metrics;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.metrics.AbstractOWLMetric;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.DLExpressivityChecker;

public class DLExpressivityMetric
extends AbstractOWLMetric<String> {
    public DLExpressivityMetric(@Nonnull OWLOntology o) {
        super(o);
    }

    @Nonnull
    protected String recomputeMetric() {
        DLExpressivityChecker checker = new DLExpressivityChecker(this.getOntologies());
        Collection dlLangs = checker.expressibleInLanguages();
        return dlLangs.stream().map(Enum::name).collect(Collectors.joining(", "));
    }

    protected boolean isMetricInvalidated(@Nonnull List<? extends OWLOntologyChange> changes) {
        return changes.stream().filter(OWLOntologyChange::isAxiomChange).map(OWLOntologyChange::getAxiom).anyMatch(OWLAxiom::isLogicalAxiom);
    }

    protected void disposeMetric() {
    }

    @Nonnull
    public String getName() {
        return "Expressivity";
    }
}

