/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.JsonMapResponseParser;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.ConfigSetService;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class CreateCollectionTool
extends ToolBase {
    public CreateCollectionTool() {
        this(CLIO.getOutStream());
    }

    public CreateCollectionTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "create_collection";
    }

    @Override
    public List<Option> getOptions() {
        return SolrCLI.CREATE_COLLECTION_OPTIONS;
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        if (zkHost == null) {
            throw new IllegalStateException("Solr at " + cli.getOptionValue("solrUrl") + " is running in standalone server mode, please use the create_core command instead;\ncreate_collection can only be used when running in SolrCloud mode.\n");
        }
        try (CloudHttp2SolrClient cloudSolrClient = new CloudHttp2SolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).build();){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            cloudSolrClient.connect();
            this.runCloudTool((CloudSolrClient)cloudSolrClient, cli);
        }
    }

    protected void runCloudTool(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
        NamedList response;
        boolean configExistsInZk;
        Set liveNodes = cloudSolrClient.getClusterState().getLiveNodes();
        if (liveNodes.isEmpty()) {
            throw new IllegalStateException("No live nodes found! Cannot create a collection until there is at least 1 live node in the cluster.");
        }
        String solrUrl = cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            String firstLiveNode = (String)liveNodes.iterator().next();
            solrUrl = ZkStateReader.from((CloudSolrClient)cloudSolrClient).getBaseUrlForNodeName(firstLiveNode);
        }
        String collectionName = cli.getOptionValue("name");
        int numShards = Integer.parseInt(cli.getOptionValue("shards", String.valueOf(1)));
        int replicationFactor = Integer.parseInt(cli.getOptionValue("replicationFactor", String.valueOf(1)));
        String confname = cli.getOptionValue("confname");
        String confdir = cli.getOptionValue("confdir");
        String configsetsDir = cli.getOptionValue("configsetsDir");
        boolean bl = configExistsInZk = confname != null && !confname.trim().isEmpty() && ZkStateReader.from((CloudSolrClient)cloudSolrClient).getZkClient().exists("/configs/" + confname, true) != false;
        if (!".system".equals(collectionName)) {
            if (configExistsInZk) {
                this.echo("Re-using existing configuration directory " + confname);
            } else if (confdir != null && !confdir.trim().isEmpty()) {
                if (confname == null || confname.trim().isEmpty()) {
                    confname = collectionName;
                }
                Path confPath = ConfigSetService.getConfigsetPath(confdir, configsetsDir);
                this.echoIfVerbose("Uploading " + confPath.toAbsolutePath() + " for config " + confname + " to ZooKeeper at " + cloudSolrClient.getClusterStateProvider().getQuorumHosts(), cli);
                ZkMaintenanceUtils.uploadToZK((SolrZkClient)ZkStateReader.from((CloudSolrClient)cloudSolrClient).getZkClient(), (Path)confPath, (String)("/configs/" + confname), (Pattern)ZkMaintenanceUtils.UPLOAD_FILENAME_EXCLUDE_PATTERN);
            }
        }
        if (SolrCLI.safeCheckCollectionExists(solrUrl, collectionName)) {
            throw new IllegalStateException("\nCollection '" + collectionName + "' already exists!\nChecked collection existence using CollectionAdminRequest");
        }
        this.echoIfVerbose("\nCreating new collection '" + collectionName + "' using CollectionAdminRequest", cli);
        try {
            CollectionAdminRequest.Create req = CollectionAdminRequest.createCollection((String)collectionName, (String)confname, (int)numShards, (int)replicationFactor);
            req.setResponseParser((ResponseParser)new JsonMapResponseParser());
            response = cloudSolrClient.request((SolrRequest)CollectionAdminRequest.createCollection((String)collectionName, (String)confname, (int)numShards, (int)replicationFactor));
        }
        catch (SolrServerException sse) {
            throw new Exception("Failed to create collection '" + collectionName + "' due to: " + sse.getMessage());
        }
        if (cli.hasOption(SolrCLI.OPTION_VERBOSE.getOpt())) {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(response.asMap());
            this.echo(arr.toString());
            this.echo("\n");
        } else {
            Object endMessage = String.format(Locale.ROOT, "Created collection '%s' with %d shard(s), %d replica(s)", collectionName, numShards, replicationFactor);
            if (confname != null && !confname.trim().isEmpty()) {
                endMessage = (String)endMessage + String.format(Locale.ROOT, " with config-set '%s'", confname);
            }
            this.echo((String)endMessage);
        }
    }
}

