/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.common.cloud.SolrZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkMkrootTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkMkrootTool() {
        this(CLIO.getOutStream());
    }

    public ZkMkrootTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"path").argName("path").hasArg().required(true).desc("Path to create.").build(), SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_VERBOSE);
    }

    @Override
    public String getName() {
        return "mkroot";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        if (zkHost == null) {
            throw new IllegalStateException("Solr at " + cli.getOptionValue("zkHost") + " is running in standalone server mode, 'zk mkroot' can only be used when running in SolrCloud mode.\n");
        }
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).build();){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            String znode = cli.getOptionValue("path");
            this.echo("Creating ZooKeeper path " + znode + " on ZooKeeper at " + zkHost);
            zkClient.makePath(znode, true);
        }
        catch (Exception e) {
            log.error("Could not complete mkroot operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

