/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.IncrementalShardBackup;
import org.apache.solr.handler.SnapShooter;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/cores/{coreName}/backups")
public class BackupCoreAPI
extends CoreAdminAPIBase {
    @Inject
    public BackupCoreAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker) {
        super(coreContainer, coreAdminAsyncTracker, solrQueryRequest, solrQueryResponse);
    }

    @Override
    boolean isExpensive() {
        return true;
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createBackup(@Parameter(description="The name of the core.") @PathParam(value="coreName") String coreName, @Schema(description="The POJO for representing additional backup params.") @RequestBody BackupCoreRequestBody backupCoreRequestBody) throws Exception {
        this.ensureRequiredParameterProvided("coreName", coreName);
        return this.handlePotentiallyAsynchronousTask(null, coreName, backupCoreRequestBody.async, "backup", () -> {
            try (BackupRepository repository = this.coreContainer.newBackupRepository(backupCoreRequestBody.repository);){
                URI locationUri;
                SolrCore core;
                block21: {
                    core = this.coreContainer.getCore(coreName);
                    try {
                        String location = repository.getBackupLocation(backupCoreRequestBody.location);
                        if (location == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' parameter is not specified in the request body or as a default repository property");
                        }
                        locationUri = repository.createDirectoryURI(location);
                        repository.createDirectory(locationUri);
                        if (!Boolean.TRUE.equals(backupCoreRequestBody.incremental)) break block21;
                        if ("file".equals(locationUri.getScheme())) {
                            core.getCoreContainer().assertPathAllowed(Paths.get(locationUri));
                        }
                        this.ensureRequiredParameterProvided("shardBackupId", backupCoreRequestBody.shardBackupId);
                        ShardBackupId shardBackupId = ShardBackupId.from(backupCoreRequestBody.shardBackupId);
                        ShardBackupId prevShardBackupId = backupCoreRequestBody.prevShardBackupId != null ? ShardBackupId.from(backupCoreRequestBody.prevShardBackupId) : null;
                        BackupFilePaths incBackupFiles = new BackupFilePaths(repository, locationUri);
                        IncrementalShardBackup incSnapShooter = new IncrementalShardBackup(repository, core, incBackupFiles, prevShardBackupId, shardBackupId, Optional.ofNullable(backupCoreRequestBody.commitName));
                        IncrementalShardBackup.IncrementalShardSnapshotResponse incrementalShardSnapshotResponse = incSnapShooter.backup();
                        if (core != null) {
                            core.close();
                        }
                        return incrementalShardSnapshotResponse;
                    }
                    catch (Throwable throwable) {
                        if (core != null) {
                            try {
                                core.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                SnapShooter snapShooter = new SnapShooter(repository, core, locationUri, backupCoreRequestBody.backupName, backupCoreRequestBody.commitName);
                if (!snapShooter.getBackupRepository().exists(snapShooter.getLocation())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Directory to contain snapshots doesn't exist: " + snapShooter.getLocation() + ". Note that Backup/Restore of a SolrCloud collection requires a shared file system mounted at the same path on all nodes!");
                }
                snapShooter.validateCreateSnapshot();
                SnapShooter.CoreSnapshotResponse coreSnapshotResponse = snapShooter.createSnapshot();
                if (core != null) {
                    core.close();
                }
                return coreSnapshotResponse;
            }
            catch (Exception exp) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to backup core=" + coreName + " because " + exp, (Throwable)exp);
            }
        });
    }

    public static class BackupCoreRequestBody
    extends SolrJerseyResponse {
        @Schema(description="The name of the repository to be used for backup.")
        @JsonProperty(value="repository")
        public String repository;
        @Schema(description="The path where the backup will be created")
        @JsonProperty(value="location")
        public String location;
        @JsonProperty(value="shardBackupId")
        public String shardBackupId;
        @JsonProperty(value="prevShardBackupId")
        public String prevShardBackupId;
        @Schema(description="A descriptive name for the backup.  Only used by non-incremental backups.")
        @JsonProperty(value="name")
        public String backupName;
        @Schema(description="The name of the commit which was used while taking a snapshot using the CREATESNAPSHOT command.")
        @JsonProperty(value="commitName")
        public String commitName;
        @Schema(description="To turn on incremental backup feature")
        @JsonProperty(value="incremental")
        public Boolean incremental;
        @Schema(description="Request ID to track this action which will be processed asynchronously.")
        @JsonProperty(value="async")
        public String async;
    }
}

