/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.AsyncJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collName}/snapshots")
public class CreateCollectionSnapshotAPI
extends AdminAPIBase {
    @Inject
    public CreateCollectionSnapshotAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Path(value="/{snapshotName}")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public CreateSnapshotResponse createSnapshot(@Parameter(description="The name of the collection.", required=true) @PathParam(value="collName") String collName, @Parameter(description="The name of the snapshot to be created.", required=true) @PathParam(value="snapshotName") String snapshotName, @RequestBody(description="Contains user provided parameters", required=true) CreateSnapshotRequestBody requestBody) throws Exception {
        CreateSnapshotResponse response = this.instantiateJerseyResponse(CreateSnapshotResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        CreateCollectionSnapshotAPI.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        String collectionName = this.resolveCollectionName(collName, requestBody.followAliases);
        SolrZkClient client = coreContainer.getZkController().getZkClient();
        if (SolrSnapshotManager.snapshotExists(client, collectionName, snapshotName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name '" + snapshotName + "' already exists for collection '" + collectionName + "', no action taken.");
        }
        ZkNodeProps remoteMessage = CreateCollectionSnapshotAPI.createRemoteMessage(collName, requestBody.followAliases, snapshotName, requestBody.asyncId);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.CREATESNAPSHOT, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        response.collection = collName;
        response.followAliases = requestBody.followAliases;
        response.snapshotName = snapshotName;
        response.requestId = requestBody.asyncId;
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, boolean followAliases, String snapshotName, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATESNAPSHOT.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("commitName", snapshotName);
        remoteMessage.put("followAliases", followAliases);
        if (asyncId != null) {
            remoteMessage.put("async", asyncId);
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static class CreateSnapshotResponse
    extends AsyncJerseyResponse {
        @Schema(description="The name of the collection.")
        @JsonProperty(value="collection")
        String collection;
        @Schema(description="The name of the snapshot to be created.")
        @JsonProperty(value="snapshot")
        String snapshotName;
        @Schema(description="A flag that treats the collName parameter as a collection alias.")
        @JsonProperty(value="followAliases")
        boolean followAliases;
    }

    public static class CreateSnapshotRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(value="followAliases", defaultValue="false")
        public boolean followAliases;
        @JsonProperty(value="async")
        public String asyncId;
    }
}

