/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.routing.AffinityReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.NodesSysProps;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.stats.InstrumentedHttpListenerFactory;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized,
SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_SCHEME = "http";
    private ExecutorService commExecutor;
    protected volatile Http2SolrClient defaultClient;
    protected InstrumentedHttpListenerFactory httpListenerFactory;
    protected LBHttp2SolrClient loadbalancer;
    int corePoolSize = 0;
    int maximumPoolSize = Integer.MAX_VALUE;
    int keepAliveTime = 5;
    int queueSize = -1;
    int permittedLoadBalancerRequestsMinimumAbsolute = 0;
    float permittedLoadBalancerRequestsMaximumFraction = 1.0f;
    boolean accessPolicy = false;
    private SolrMetricsContext solrMetricsContext;
    private String scheme = null;
    private InstrumentedHttpListenerFactory.NameStrategy metricNameStrategy;
    protected final Random r = new Random();
    private RequestReplicaListTransformerGenerator requestReplicaListTransformerGenerator = new RequestReplicaListTransformerGenerator();
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE = "loadBalancerRequestsMinimumAbsolute";
    static final String LOAD_BALANCER_REQUESTS_MAX_FRACTION = "loadBalancerRequestsMaximumFraction";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";

    @Override
    public ShardHandler getShardHandler() {
        return new HttpShardHandler(this);
    }

    private static NamedList<?> getNamedList(Object val) {
        if (val instanceof NamedList) {
            return (NamedList)val;
        }
        throw new IllegalArgumentException("Invalid config for replicaRouting; expected NamedList, but got " + val);
    }

    private static String checkDefaultReplicaListTransformer(NamedList<?> c, String setTo, String extantDefaultRouting) {
        if (!Boolean.TRUE.equals(c.getBooleanArg("default"))) {
            return null;
        }
        if (extantDefaultRouting == null) {
            return setTo;
        }
        throw new IllegalArgumentException("more than one routing scheme marked as default");
    }

    private void initReplicaListTransformers(NamedList<?> routingConfig) {
        String defaultRouting = null;
        AffinityReplicaListTransformerFactory stableRltFactory = null;
        if (routingConfig != null && routingConfig.size() > 0) {
            Iterator iter = routingConfig.iterator();
            do {
                String key;
                Map.Entry e = (Map.Entry)iter.next();
                switch (key = (String)e.getKey()) {
                    case "random": {
                        defaultRouting = HttpShardHandlerFactory.checkDefaultReplicaListTransformer(HttpShardHandlerFactory.getNamedList(e.getValue()), key, defaultRouting);
                        break;
                    }
                    case "stable": {
                        NamedList<?> c = HttpShardHandlerFactory.getNamedList(e.getValue());
                        defaultRouting = HttpShardHandlerFactory.checkDefaultReplicaListTransformer(c, key, defaultRouting);
                        stableRltFactory = new AffinityReplicaListTransformerFactory(c);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid replica routing spec name: " + key);
                    }
                }
            } while (iter.hasNext());
        }
        if (stableRltFactory == null) {
            stableRltFactory = new AffinityReplicaListTransformerFactory();
        }
        Object defaultRltFactory = "stable".equals(defaultRouting) ? stableRltFactory : RequestReplicaListTransformerGenerator.RANDOM_RLTF;
        this.requestReplicaListTransformerGenerator = new RequestReplicaListTransformerGenerator((ReplicaListTransformerFactory)defaultRltFactory, (ReplicaListTransformerFactory)stableRltFactory);
    }

    @Override
    public void init(PluginInfo info) {
        String v;
        StringBuilder sb = new StringBuilder();
        NamedList<Object> args = info.initArgs;
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, null, sb);
        if (this.scheme != null && this.scheme.endsWith("://")) {
            this.scheme = this.scheme.replace("://", "");
        }
        String strategy = this.getParameter(args, "metricNameStrategy", "queryLessURLAndMethod", sb);
        this.metricNameStrategy = InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.get(strategy);
        if (this.metricNameStrategy == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + strategy + " found. Must be one of: " + InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, this.corePoolSize, sb);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, this.maximumPoolSize, sb);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, this.keepAliveTime, sb);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, this.queueSize, sb);
        this.permittedLoadBalancerRequestsMinimumAbsolute = this.getParameter(args, LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE, this.permittedLoadBalancerRequestsMinimumAbsolute, sb);
        this.permittedLoadBalancerRequestsMaximumFraction = this.getParameter(args, LOAD_BALANCER_REQUESTS_MAX_FRACTION, Float.valueOf(this.permittedLoadBalancerRequestsMaximumFraction), sb).floatValue();
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, this.accessPolicy, sb);
        if (args != null && args.get("shardsWhitelist") != null) {
            log.warn("Property 'shardsWhitelist' is deprecated, please use '{}' instead.", (Object)"allowUrls");
        }
        if ((v = System.getProperty("tests.shardhandler.randomSeed")) != null) {
            this.r.setSeed(Long.parseLong(v));
        }
        AbstractQueue blockingQueue = this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy);
        this.commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, blockingQueue, (ThreadFactory)new SolrNamedThreadFactory("httpShardExecutor"), false);
        this.httpListenerFactory = new InstrumentedHttpListenerFactory(this.metricNameStrategy);
        int connectionTimeout = this.getParameter(args, "connTimeout", 60000, sb);
        int maxConnectionsPerHost = this.getParameter(args, "maxConnectionsPerHost", 100000, sb);
        int soTimeout = this.getParameter(args, "socketTimeout", 600000, sb);
        this.defaultClient = new Http2SolrClient.Builder().withConnectionTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).withIdleTimeout((long)soTimeout, TimeUnit.MILLISECONDS).withExecutor(this.commExecutor).withMaxConnectionsPerHost(maxConnectionsPerHost).build();
        this.defaultClient.addListenerFactory((HttpListenerFactory)this.httpListenerFactory);
        this.loadbalancer = new LBHttp2SolrClient.Builder(this.defaultClient, new String[0]).build();
        this.initReplicaListTransformers(this.getParameter(args, "replicaRouting", null, sb));
        log.debug("created with {}", (Object)sb);
    }

    @Override
    public void setSecurityBuilder(HttpClientBuilderPlugin clientBuilderPlugin) {
        if (clientBuilderPlugin != null) {
            clientBuilderPlugin.setup(this.defaultClient);
        }
    }

    protected <T> T getParameter(NamedList<?> initArgs, String configKey, T defaultValue, StringBuilder sb) {
        Object toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            T t = toReturn = temp != null ? temp : defaultValue;
        }
        if (sb != null && toReturn != null) {
            sb.append(configKey).append(" : ").append(toReturn).append(",");
        }
        return toReturn;
    }

    @Override
    public void close() {
        try {
            if (this.loadbalancer != null) {
                this.loadbalancer.close();
            }
        }
        finally {
            try {
                if (this.defaultClient != null) {
                    IOUtils.closeQuietly((Closeable)this.defaultClient);
                }
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.commExecutor);
            }
        }
        try {
            SolrMetricProducer.super.close();
        }
        catch (Exception e) {
            log.warn("Exception closing.", (Throwable)e);
        }
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    protected LBSolrClient.Req newLBHttpSolrClientReq(QueryRequest req, List<String> urls) {
        int numServersToTry = (int)Math.floor((float)urls.size() * this.permittedLoadBalancerRequestsMaximumFraction);
        if (numServersToTry < this.permittedLoadBalancerRequestsMinimumAbsolute) {
            numServersToTry = this.permittedLoadBalancerRequestsMinimumAbsolute;
        }
        return new LBSolrClient.Req((SolrRequest)req, urls, Integer.valueOf(numServersToTry));
    }

    public List<String> buildURLList(String shard) {
        List urls = StrUtils.splitSmart((String)shard, (String)"|", (boolean)true);
        for (int i = 0; i < urls.size(); ++i) {
            urls.set(i, this.buildUrl((String)urls.get(i)));
        }
        return urls;
    }

    protected ReplicaListTransformer getReplicaListTransformer(SolrQueryRequest req) {
        SolrParams params = req.getParams();
        SolrCore core = req.getCore();
        ZkController zkController = req.getCoreContainer().getZkController();
        if (zkController != null) {
            return this.requestReplicaListTransformerGenerator.getReplicaListTransformer(params, zkController.getZkStateReader().getClusterProperties().getOrDefault("defaultShardPreferences", "").toString(), zkController.getNodeName(), zkController.getBaseUrl(), (NodesSysProps)zkController.getSysPropsCacher());
        }
        return this.requestReplicaListTransformerGenerator.getReplicaListTransformer(params);
    }

    public SolrClient getClient() {
        return this.defaultClient;
    }

    private String buildUrl(String url) {
        if (!URLUtil.hasScheme((String)url)) {
            return (StrUtils.isNullOrEmpty((String)this.scheme) ? DEFAULT_SCHEME : this.scheme) + "://" + url;
        }
        if (StrUtils.isNotNullOrEmpty((String)this.scheme)) {
            return this.scheme + "://" + URLUtil.removeScheme((String)url);
        }
        return url;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        String expandedScope = SolrMetricManager.mkName(scope, SolrInfoBean.Category.QUERY.name());
        this.httpListenerFactory.initializeMetrics(this.solrMetricsContext, expandedScope);
        this.commExecutor = MetricUtils.instrumentedExecutorService(this.commExecutor, null, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("httpShardExecutor", expandedScope, "threadPool"));
    }
}

