/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;
import org.apache.solr.handler.export.TripleValueSortDoc;

class QuadValueSortDoc
extends TripleValueSortDoc {
    protected SortValue value4;

    @Override
    public SortValue getSortValue(String field) {
        if (this.value1.getField().equals(field)) {
            return this.value1;
        }
        if (this.value2.getField().equals(field)) {
            return this.value2;
        }
        if (this.value3.getField().equals(field)) {
            return this.value3;
        }
        if (this.value4.getField().equals(field)) {
            return this.value4;
        }
        return null;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.ord = context.ord;
        this.docBase = context.docBase;
        this.value1.setNextReader(context);
        this.value2.setNextReader(context);
        this.value3.setNextReader(context);
        this.value4.setNextReader(context);
    }

    @Override
    public void setGlobalValues(SortDoc previous) {
        QuadValueSortDoc quadValueSortDoc = (QuadValueSortDoc)previous;
        this.value1.toGlobalValue(quadValueSortDoc.value1);
        this.value2.toGlobalValue(quadValueSortDoc.value2);
        this.value3.toGlobalValue(quadValueSortDoc.value3);
        this.value4.toGlobalValue(quadValueSortDoc.value4);
    }

    @Override
    public void reset() {
        this.docId = -1;
        this.docBase = -1;
        this.ord = -1;
        this.value1.reset();
        this.value2.reset();
        this.value3.reset();
        this.value4.reset();
    }

    @Override
    public void setValues(int docId) throws IOException {
        this.docId = docId;
        this.value1.setCurrentValue(docId);
        this.value2.setCurrentValue(docId);
        this.value3.setCurrentValue(docId);
        this.value4.setCurrentValue(docId);
    }

    @Override
    public void setValues(SortDoc sortDoc) {
        this.docId = sortDoc.docId;
        this.ord = sortDoc.ord;
        this.docBase = sortDoc.docBase;
        this.value1.setCurrentValue(((QuadValueSortDoc)sortDoc).value1);
        this.value2.setCurrentValue(((QuadValueSortDoc)sortDoc).value2);
        this.value3.setCurrentValue(((QuadValueSortDoc)sortDoc).value3);
        this.value4.setCurrentValue(((QuadValueSortDoc)sortDoc).value4);
    }

    public QuadValueSortDoc(SortValue value1, SortValue value2, SortValue value3, SortValue value4) {
        super(value1, value2, value3);
        this.value4 = value4;
    }

    @Override
    public SortDoc copy() {
        return new QuadValueSortDoc(this.value1.copy(), this.value2.copy(), this.value3.copy(), this.value4.copy());
    }

    @Override
    public boolean lessThan(Object o) {
        QuadValueSortDoc sd = (QuadValueSortDoc)o;
        int comp = this.value1.compareTo(sd.value1);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        comp = this.value2.compareTo(sd.value2);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        comp = this.value3.compareTo(sd.value3);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        comp = this.value4.compareTo(sd.value4);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        return this.docId + this.docBase > sd.docId + sd.docBase;
    }

    @Override
    public int compareTo(SortDoc o) {
        QuadValueSortDoc sd = (QuadValueSortDoc)o;
        int comp = this.value1.compareTo(sd.value1);
        if (comp == 0) {
            comp = this.value2.compareTo(sd.value2);
            if (comp == 0) {
                comp = this.value3.compareTo(sd.value3);
                if (comp == 0) {
                    comp = this.value4.compareTo(sd.value4);
                    if (comp == 0) {
                        return sd.docId + sd.docBase - (this.docId + this.docBase);
                    }
                    return comp;
                }
                return comp;
            }
            return comp;
        }
        return comp;
    }
}

