/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.IntFloatHashMap;
import com.carrotsearch.hppc.IntIntHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.ReRankOperator;
import org.apache.solr.search.ReRankScaler;
import org.apache.solr.search.SolrIndexSearcher;

public class ReRankCollector
extends TopDocsCollector<ScoreDoc> {
    private final TopDocsCollector<? extends ScoreDoc> mainCollector;
    private final IndexSearcher searcher;
    private final int reRankDocs;
    private final int length;
    private final Set<BytesRef> boostedPriority;
    private final Rescorer reRankQueryRescorer;
    private final Sort sort;
    private final Query query;
    private ReRankScaler reRankScaler;
    private ReRankOperator reRankOperator;

    public ReRankCollector(int reRankDocs, int length, Rescorer reRankQueryRescorer, QueryCommand cmd, IndexSearcher searcher, Set<BytesRef> boostedPriority, ReRankScaler reRankScaler, ReRankOperator reRankOperator) throws IOException {
        this(reRankDocs, length, reRankQueryRescorer, cmd, searcher, boostedPriority);
        this.reRankScaler = reRankScaler;
        this.reRankOperator = reRankOperator;
    }

    public ReRankCollector(int reRankDocs, int length, Rescorer reRankQueryRescorer, QueryCommand cmd, IndexSearcher searcher, Set<BytesRef> boostedPriority) throws IOException {
        super(null);
        this.reRankDocs = reRankDocs;
        this.length = length;
        this.boostedPriority = boostedPriority;
        this.query = cmd.getQuery();
        Sort sort = cmd.getSort();
        if (sort == null) {
            this.sort = null;
            this.mainCollector = TopScoreDocCollector.create((int)Math.max(this.reRankDocs, length), (int)cmd.getMinExactCount());
        } else {
            this.sort = sort = sort.rewrite(searcher);
            this.mainCollector = TopFieldCollector.create((Sort)sort, (int)Math.max(this.reRankDocs, length), (int)cmd.getMinExactCount());
        }
        this.searcher = searcher;
        this.reRankQueryRescorer = reRankQueryRescorer;
    }

    public int getTotalHits() {
        return this.mainCollector.getTotalHits();
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.mainCollector.getLeafCollector(context);
    }

    public ScoreMode scoreMode() {
        return this.mainCollector.scoreMode();
    }

    public TopDocs topDocs(int start, int howMany) {
        try {
            ScoreDoc[] scoreDocs;
            TopDocs mainDocs = this.mainCollector.topDocs(0, Math.max(this.reRankDocs, this.length));
            if (mainDocs.totalHits.value == 0L || mainDocs.scoreDocs.length == 0) {
                return mainDocs;
            }
            if (this.sort != null) {
                TopFieldCollector.populateScores((ScoreDoc[])mainDocs.scoreDocs, (IndexSearcher)this.searcher, (Query)this.query);
            }
            ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
            ScoreDoc[] mainScoreDocsClone = this.reRankScaler != null && this.reRankScaler.scaleScores() ? this.deepCloneAndZeroOut(mainScoreDocs) : null;
            ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
            System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
            mainDocs.scoreDocs = reRankScoreDocs;
            TopDocs rescoredDocs = this.reRankScaler != null && this.reRankScaler.scaleScores() ? this.reRankScaler.getReplaceRescorer().rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length) : this.reRankQueryRescorer.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
            howMany = Math.min(howMany, mainScoreDocs.length);
            if (this.boostedPriority != null) {
                SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
                Map<Object, Object> requestContext = null;
                if (info != null) {
                    requestContext = info.getReq().getContext();
                }
                IntIntHashMap boostedDocs = QueryElevationComponent.getBoostDocs((SolrIndexSearcher)this.searcher, this.boostedPriority, requestContext);
                float maxScore = rescoredDocs.scoreDocs.length == 0 ? Float.NaN : rescoredDocs.scoreDocs[0].score;
                Arrays.sort(rescoredDocs.scoreDocs, new BoostedComp(boostedDocs, mainDocs.scoreDocs, maxScore));
            }
            if (howMany == rescoredDocs.scoreDocs.length) {
                if (this.reRankScaler != null && this.reRankScaler.scaleScores()) {
                    rescoredDocs.scoreDocs = this.reRankScaler.scaleScores(mainScoreDocsClone, rescoredDocs.scoreDocs, reRankScoreDocs.length);
                }
                return rescoredDocs;
            }
            if (howMany > rescoredDocs.scoreDocs.length) {
                scoreDocs = new ScoreDoc[howMany];
                System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                rescoredDocs.scoreDocs = scoreDocs;
                if (this.reRankScaler != null && this.reRankScaler.scaleScores()) {
                    rescoredDocs.scoreDocs = this.reRankScaler.scaleScores(mainScoreDocsClone, rescoredDocs.scoreDocs, reRankScoreDocs.length);
                }
                return rescoredDocs;
            }
            if (this.reRankScaler != null && this.reRankScaler.scaleScores()) {
                rescoredDocs.scoreDocs = this.reRankScaler.scaleScores(mainScoreDocsClone, rescoredDocs.scoreDocs, rescoredDocs.scoreDocs.length);
            }
            scoreDocs = new ScoreDoc[howMany];
            System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
            rescoredDocs.scoreDocs = scoreDocs;
            return rescoredDocs;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    private ScoreDoc[] deepCloneAndZeroOut(ScoreDoc[] scoreDocs) {
        ScoreDoc[] scoreDocs1 = new ScoreDoc[scoreDocs.length];
        for (int i = 0; i < scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i];
            if (scoreDoc == null) continue;
            scoreDocs1[i] = new ScoreDoc(scoreDoc.doc, scoreDoc.score);
            scoreDoc.score = 0.0f;
        }
        return scoreDocs1;
    }

    public static class BoostedComp
    implements Comparator<ScoreDoc> {
        IntFloatHashMap boostedMap;

        public BoostedComp(IntIntHashMap boostedDocs, ScoreDoc[] scoreDocs, float maxScore) {
            int idx;
            this.boostedMap = new IntFloatHashMap(boostedDocs.size() * 2);
            for (int i = 0; i < scoreDocs.length && (idx = boostedDocs.indexOf(scoreDocs[i].doc)) >= 0; ++i) {
                this.boostedMap.put(scoreDocs[i].doc, maxScore + (float)boostedDocs.indexGet(idx));
            }
        }

        @Override
        public int compare(ScoreDoc doc1, ScoreDoc doc2) {
            float score1 = doc1.score;
            float score2 = doc2.score;
            int idx = this.boostedMap.indexOf(doc1.doc);
            if (idx >= 0) {
                score1 = this.boostedMap.indexGet(idx);
            }
            if ((idx = this.boostedMap.indexOf(doc2.doc)) >= 0) {
                score2 = this.boostedMap.indexGet(idx);
            }
            return -Float.compare(score1, score2);
        }
    }
}

