/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.context.Context;
import io.opentelemetry.extension.incubator.metrics.DoubleUpDownCounterAdviceConfigurer;
import io.opentelemetry.extension.incubator.metrics.ExtendedDoubleUpDownCounterBuilder;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleUpDownCounter
extends AbstractInstrument
implements DoubleUpDownCounter {
    private final WriteableMetricStorage storage;

    private SdkDoubleUpDownCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    public void add(double increment, Attributes attributes, Context context) {
        this.storage.recordDouble(increment, attributes, context);
    }

    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    static final class SdkDoubleUpDownCounterBuilder
    extends AbstractInstrumentBuilder<SdkDoubleUpDownCounterBuilder>
    implements ExtendedDoubleUpDownCounterBuilder,
    DoubleUpDownCounterAdviceConfigurer {
        SdkDoubleUpDownCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            super(meterProviderSharedState, sharedState, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, name, description, unit, adviceBuilder);
        }

        @Override
        protected SdkDoubleUpDownCounterBuilder getThis() {
            return this;
        }

        public DoubleUpDownCounterBuilder setAdvice(Consumer<DoubleUpDownCounterAdviceConfigurer> adviceConsumer) {
            adviceConsumer.accept(this);
            return this;
        }

        public DoubleUpDownCounter build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleUpDownCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        public ObservableDoubleMeasurement buildObserver() {
            return this.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        public DoubleUpDownCounterAdviceConfigurer setAttributes(List<AttributeKey<?>> attributes) {
            this.adviceBuilder.setAttributes(attributes);
            return this;
        }
    }
}

