/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.ReloadCollectionRequestBody;
import org.apache.solr.client.api.model.RenameCollectionRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CollectionsApi {

    public static class RenameCollection
    extends SolrRequest<RenameCollectionResponse> {
        private final RenameCollectionRequestBody requestBody;
        private final String collectionName;

        public RenameCollection(String collectionName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/rename".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
            this.requestBody = new RenameCollectionRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setTo(String to) {
            this.requestBody.to = to;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.requestBody.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected RenameCollectionResponse createResponse(SolrClient client) {
            return new RenameCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class RenameCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public RenameCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class ReloadCollection
    extends SolrRequest<ReloadCollectionResponse> {
        private final ReloadCollectionRequestBody requestBody;
        private final String collectionName;

        public ReloadCollection(String collectionName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/reload".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
            this.requestBody = new ReloadCollectionRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected ReloadCollectionResponse createResponse(SolrClient client) {
            return new ReloadCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ReloadCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public ReloadCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class ListCollections
    extends SolrRequest<ListCollectionsResponse> {
        public ListCollections() {
            super(SolrRequest.METHOD.valueOf("GET"), "/collections");
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected ListCollectionsResponse createResponse(SolrClient client) {
            return new ListCollectionsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListCollectionsResponse
    extends JacksonParsingResponse<ListCollectionsResponse> {
        public ListCollectionsResponse() {
            super(ListCollectionsResponse.class);
        }
    }

    public static class DeleteCollection
    extends SolrRequest<DeleteCollectionResponse> {
        private final String collectionName;
        private Boolean followAliases;
        private String async;

        public DeleteCollection(String collectionName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collectionName}".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.followAliases != null) {
                params.add("followAliases", this.followAliases.toString());
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteCollectionResponse createResponse(SolrClient client) {
            return new DeleteCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public DeleteCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }
}

